/*
 * Decompiled with CFR 0.152.
 */
package me.bullobily.objects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.bullobily.main.Main;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.Player;

public class ExchangeZone
implements ConfigurationSerializable {
    private String zoneName;
    private Location loc1;
    private Location loc2;
    private String sendPermission;
    private String acceptPermission;
    private Main plugin;

    public static List<ExchangeZone> getAllExchangesZones(Main plugin) {
        if (plugin.getConfig().getList("zones_list") == null) {
            return new ArrayList<ExchangeZone>();
        }
        return plugin.getConfig().getList("zones_list");
    }

    public static ExchangeZone getPlayerZone(Main plugin, Player p) {
        Location pLoc = p.getLocation();
        if (plugin.getConfig().getList("zones_list") == null) {
            return null;
        }
        for (Object exZ : plugin.getConfig().getList("zones_list")) {
            if (!((ExchangeZone)exZ).isInZone(pLoc)) continue;
            return (ExchangeZone)exZ;
        }
        return null;
    }

    public static ExchangeZone getZone(Main plugin, String name) {
        if (plugin.getConfig().getList("zones_list") == null) {
            return null;
        }
        for (Object exZ : plugin.getConfig().getList("zones_list")) {
            if (!((ExchangeZone)exZ).getName().equals(name)) continue;
            return (ExchangeZone)exZ;
        }
        return null;
    }

    public ExchangeZone(Main plugin, String zoneName, Location loc1, Location loc2, String sendPerm, String acceptPerm) {
        this.plugin = plugin;
        this.zoneName = zoneName;
        this.loc1 = loc1;
        this.loc2 = loc2;
        this.loc2.setWorld(loc1.getWorld());
        this.sendPermission = sendPerm;
        this.acceptPermission = acceptPerm;
    }

    public ExchangeZone(Map<String, Object> serializedData) {
        this.zoneName = (String)serializedData.get("zone_name");
        this.sendPermission = (String)serializedData.get("permission_to_demand_exchange");
        this.acceptPermission = (String)serializedData.get("permission_to_accept_exchange");
        this.loc1 = new Location(Bukkit.getWorld((String)((String)serializedData.get("world_name"))), ((Double)serializedData.get("x1")).doubleValue(), ((Double)serializedData.get("y1")).doubleValue(), ((Double)serializedData.get("z1")).doubleValue());
        this.loc2 = new Location(Bukkit.getWorld((String)((String)serializedData.get("world_name"))), ((Double)serializedData.get("x2")).doubleValue(), ((Double)serializedData.get("y2")).doubleValue(), ((Double)serializedData.get("z2")).doubleValue());
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> toSerialization = new HashMap<String, Object>();
        toSerialization.put("zone_name", this.zoneName);
        toSerialization.put("permission_to_demand_exchange", this.sendPermission);
        toSerialization.put("permission_to_accept_exchange", this.acceptPermission);
        toSerialization.put("world_name", this.loc1.getWorld().getName());
        toSerialization.put("x1", this.loc1.getX());
        toSerialization.put("x2", this.loc2.getX());
        toSerialization.put("y1", this.loc1.getY());
        toSerialization.put("y2", this.loc2.getY());
        toSerialization.put("z1", this.loc1.getZ());
        toSerialization.put("z2", this.loc2.getZ());
        return toSerialization;
    }

    public String toString() {
        return "\u00a76Exchange zone '" + this.zoneName + "' \u00a76(" + this.loc1.getWorld().getName() + ")\n\u00a7e  >> " + (int)this.loc1.getX() + " " + (int)this.loc1.getY() + " " + (int)this.loc1.getZ() + " | " + (int)this.loc2.getX() + " " + (int)this.loc2.getY() + " " + (int)this.loc2.getZ() + "\n  >> " + this.sendPermission + "\n  >> " + this.acceptPermission;
    }

    public String getName() {
        return this.zoneName;
    }

    public String getSendPerm() {
        return this.sendPermission;
    }

    public String getAcceptPerm() {
        return this.acceptPermission;
    }

    public Location getLocation_1() {
        return this.loc1;
    }

    public Location getLocation_2() {
        return this.loc2;
    }

    public void setLocation_1(Location loc) {
        this.loc1 = loc;
    }

    public void setLocation_2(Location loc) {
        this.loc2 = loc;
    }

    public boolean isInZone(Location loc) {
        if (loc.getWorld().getName().equals(this.loc1.getWorld().getName())) {
            if (loc.getX() >= Math.min(this.loc1.getX(), this.loc2.getX()) && loc.getX() <= Math.max(this.loc1.getX(), this.loc2.getX())) {
                if (loc.getY() >= Math.min(this.loc1.getY(), this.loc2.getY()) && loc.getY() <= Math.max(this.loc1.getY(), this.loc2.getY())) {
                    return loc.getZ() >= Math.min(this.loc1.getZ(), this.loc2.getZ()) && loc.getZ() <= Math.max(this.loc1.getZ(), this.loc2.getZ());
                }
                return false;
            }
            return false;
        }
        return false;
    }
}

