/*
 * Decompiled with CFR 0.152.
 */
package me.bullobily.objects;

import java.util.ArrayList;
import java.util.List;
import me.bullobily.command.CommandTradeSend;
import me.bullobily.main.Main;
import me.bullobily.objects.PlayerExchangeData;
import me.bullobily.threads.UpdateInterfaceItemList;
import me.bullobily.utils.ItemLibrary;
import me.bullobily.utils.MessageLibrary;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Exchange {
    private static ArrayList<Exchange> exchangesInProgress = new ArrayList();
    private PlayerExchangeData p1Data;
    private PlayerExchangeData p2Data;
    private Main plugin;
    private int countdown;

    public static Exchange getExchange(Player p) {
        for (Exchange e : exchangesInProgress) {
            if (!e.isInExchange(p)) continue;
            return e;
        }
        return null;
    }

    public static void cancelAllExchanges() {
        for (Exchange ex : new ArrayList<Exchange>(exchangesInProgress)) {
            ex.conclude(false);
        }
        Bukkit.getLogger().info("[SecuresExchanges] All exchanges in progress have been succesfully cancelled.");
        exchangesInProgress.clear();
    }

    public static boolean existingExchange(Exchange ex) {
        return exchangesInProgress.contains(ex);
    }

    public Exchange(Main plugin, Player p1, Player p2) {
        this.p1Data = new PlayerExchangeData(plugin, p1, p2);
        this.p2Data = new PlayerExchangeData(plugin, p2, p1);
        this.plugin = plugin;
        this.countdown = 6;
        p1.openInventory(this.p1Data.getInterface());
        p2.openInventory(this.p2Data.getInterface());
        CommandTradeSend.setTarget(p1, p1);
        CommandTradeSend.setTarget(p2, p2);
        exchangesInProgress.add(this);
        new UpdateInterfaceItemList(this).start();
    }

    public int getCountdown() {
        return this.countdown;
    }

    public boolean isInExchange(Player p) {
        return this.p1Data.getPlayer().equals(p) || this.p2Data.getPlayer().equals(p);
    }

    public Player getOtherPlayer(Player p) {
        if (p.equals(this.p1Data.getPlayer())) {
            return this.p2Data.getPlayer();
        }
        if (p.equals(this.p2Data.getPlayer())) {
            return this.p1Data.getPlayer();
        }
        return null;
    }

    public List<Player> getPlayers() {
        ArrayList<Player> list = new ArrayList<Player>();
        list.add(this.p1Data.getPlayer());
        list.add(this.p2Data.getPlayer());
        return list;
    }

    public PlayerExchangeData getPlayerExchangeData(Player p) {
        if (this.p1Data.getPlayer().equals(p)) {
            return this.p1Data;
        }
        if (this.p2Data.getPlayer().equals(p)) {
            return this.p2Data;
        }
        return null;
    }

    public void setCountdown(int i) {
        this.countdown = i;
    }

    public void updateItemsListOnInterface(PlayerExchangeData ped) {
        PlayerExchangeData ped2 = ped.equals(this.p1Data) ? this.p2Data : this.p1Data;
        ArrayList<ItemStack> itList = new ArrayList<ItemStack>(ped2.getItemList());
        int i = 23;
        while (i < 27) {
            if (itList.get(i - 23) != null) {
                ped.getInterface().setItem(i, itList.get(i - 23));
            } else {
                ped.getInterface().setItem(i, ItemLibrary.INTERFACE_DARK_FULFILLER.getItem(this.plugin, ped.getPlayer()));
            }
            ++i;
        }
        i = 32;
        while (i < 36) {
            if (itList.get(i - 32 + 4) != null) {
                ped.getInterface().setItem(i, itList.get(i - 32 + 4));
            } else {
                ped.getInterface().setItem(i, ItemLibrary.INTERFACE_DARK_FULFILLER.getItem(this.plugin, ped.getPlayer()));
            }
            ++i;
        }
        i = 41;
        while (i < 45) {
            if (itList.get(i - 41 + 8) != null) {
                ped.getInterface().setItem(i, itList.get(i - 41 + 8));
            } else {
                ped.getInterface().setItem(i, ItemLibrary.INTERFACE_DARK_FULFILLER.getItem(this.plugin, ped.getPlayer()));
            }
            ++i;
        }
        i = 50;
        while (i < 54) {
            if (itList.get(i - 50 + 12) != null) {
                ped.getInterface().setItem(i, itList.get(i - 50 + 12));
            } else {
                ped.getInterface().setItem(i, ItemLibrary.INTERFACE_DARK_FULFILLER.getItem(this.plugin, ped.getPlayer()));
            }
            ++i;
        }
        if (this.plugin.getConfig().getBoolean("authorize_exp_exchange")) {
            ped.getInterface().setItem(3, ItemLibrary.EXP_BUTTON.getItem(this.plugin, ped.getPlayer()));
        }
        if (this.plugin.getConfig().getBoolean("authorize_money_exchange")) {
            ped.getInterface().setItem(4, ItemLibrary.MONEY_BUTTON.getItem(this.plugin, ped.getPlayer()));
        }
    }

    public void conclude(boolean isExecuted) {
        exchangesInProgress.remove(this);
        this.p1Data.generateItemsList();
        this.p2Data.generateItemsList();
        this.p1Data.setExp(Math.max(this.p1Data.getExp(), 0.0f));
        this.p2Data.setExp(Math.max(this.p2Data.getExp(), 0.0f));
        this.p1Data.setMoney(Math.max(this.p1Data.getMoney(), 0.0f));
        this.p2Data.setMoney(Math.max(this.p2Data.getMoney(), 0.0f));
        if (isExecuted) {
            for (ItemStack it : this.p2Data.getItemList()) {
                if (it == null) continue;
                this.p1Data.getPlayer().getInventory().addItem(new ItemStack[]{it});
            }
            for (ItemStack it : this.p1Data.getItemList()) {
                if (it == null) continue;
                this.p2Data.getPlayer().getInventory().addItem(new ItemStack[]{it});
            }
            if (this.plugin.getConfig().getBoolean("authorize_exp_exchange")) {
                this.p1Data.getPlayer().setLevel((int)(this.p2Data.getExp() + (float)this.p1Data.getPlayer().getLevel()));
                this.p2Data.getPlayer().setLevel((int)(this.p1Data.getExp() + (float)this.p2Data.getPlayer().getLevel()));
            }
            if (this.plugin.getConfig().getBoolean("authorize_money_exchange")) {
                this.plugin.getEconomy().depositPlayer((OfflinePlayer)this.p1Data.getPlayer(), (double)this.p2Data.getMoney());
                this.plugin.getEconomy().depositPlayer((OfflinePlayer)this.p2Data.getPlayer(), (double)this.p1Data.getMoney());
            }
            this.p1Data.getPlayer().sendMessage(MessageLibrary.EXCHANGE_EXECUTED.getMessage(this.plugin, this.p1Data.getPlayer(), this.p2Data.getPlayer()));
            this.p2Data.getPlayer().sendMessage(MessageLibrary.EXCHANGE_EXECUTED.getMessage(this.plugin, this.p2Data.getPlayer(), this.p1Data.getPlayer()));
        } else {
            for (ItemStack it : this.p1Data.getItemList()) {
                if (it == null) continue;
                this.p1Data.getPlayer().getInventory().addItem(new ItemStack[]{it});
            }
            for (ItemStack it : this.p2Data.getItemList()) {
                if (it == null) continue;
                this.p2Data.getPlayer().getInventory().addItem(new ItemStack[]{it});
            }
            if (this.plugin.getConfig().getBoolean("authorize_exp_exchange")) {
                this.p1Data.getPlayer().setLevel((int)(this.p1Data.getExp() + (float)this.p1Data.getPlayer().getLevel()));
                this.p2Data.getPlayer().setLevel((int)(this.p2Data.getExp() + (float)this.p2Data.getPlayer().getLevel()));
            }
            if (this.plugin.getConfig().getBoolean("authorize_money_exchange")) {
                this.plugin.getEconomy().depositPlayer((OfflinePlayer)this.p1Data.getPlayer(), (double)this.p1Data.getMoney());
                this.plugin.getEconomy().depositPlayer((OfflinePlayer)this.p2Data.getPlayer(), (double)this.p2Data.getMoney());
            }
        }
        this.p1Data.getPlayer().closeInventory();
        this.p2Data.getPlayer().closeInventory();
    }
}

