/*
 * Decompiled with CFR 0.152.
 */
package me.bullobily.main;

import me.bullobily.command.CommandTrade;
import me.bullobily.command.CommandTradeAccept;
import me.bullobily.command.CommandTradeSend;
import me.bullobily.command.PluginTabCompleter;
import me.bullobily.events.EventClickInventory;
import me.bullobily.events.EventsHandler;
import me.bullobily.objects.Exchange;
import me.bullobily.objects.ExchangeZone;
import me.bullobily.utils.Metrics_bStats;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    private Economy economy = null;

    public Economy getEconomy() {
        return this.economy;
    }

    public void onEnable() {
        ConfigurationSerialization.registerClass(ExchangeZone.class);
        this.saveDefaultConfig();
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new EventClickInventory(this), (Plugin)this);
        pm.registerEvents((Listener)new EventsHandler(this), (Plugin)this);
        this.getCommand("se").setExecutor((CommandExecutor)new CommandTrade(this));
        this.getCommand("se").setTabCompleter((TabCompleter)new PluginTabCompleter(this));
        this.getCommand("sea").setExecutor((CommandExecutor)new CommandTradeAccept(this));
        this.getCommand("ses").setExecutor((CommandExecutor)new CommandTradeSend(this));
        for (Player p : Bukkit.getOnlinePlayers()) {
            CommandTradeSend.setTarget(p, p);
        }
        if (this.getConfig().getBoolean("authorize_money_exchange")) {
            if (this.setupEconomy()) {
                Bukkit.getLogger().info("[SecuresExchanges] Vault and economy plugin loaded successfully. Money exchange feathure enabled.");
            } else {
                this.getConfig().set("authorize_money_exchange", (Object)false);
                Bukkit.getLogger().warning("[SecuresExchanges] Impossible to load Vault or economy plugin (to setup in config.yml). Money exchange disabled.");
            }
        } else {
            Bukkit.getLogger().info("[SecuresExchanges] Money exchange disabled (see config).");
        }
        Metrics_bStats metrics = new Metrics_bStats((Plugin)this, 6643);
    }

    public void onDisable() {
        Exchange.cancelAllExchanges();
    }

    private boolean setupEconomy() {
        if (Bukkit.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        try {
            RegisteredServiceProvider economyProvider = this.getServer().getServicesManager().getRegistration(Economy.class);
            if (economyProvider != null) {
                this.economy = (Economy)economyProvider.getProvider();
            }
            return this.economy != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String applyVariables_fullParameters(String s, Player p, Player partner) {
        Exchange ex = Exchange.getExchange(p);
        ExchangeZone exZonePlayer = ExchangeZone.getPlayerZone(this, p);
        String response = s.replace("%player%", p.getDisplayName());
        if (exZonePlayer != null) {
            response = response.replace("%playerZone%", exZonePlayer.getName()).replace("%send_permission%", exZonePlayer.getSendPerm()).replace("%accept_permission%", exZonePlayer.getAcceptPerm());
        }
        if (ex != null) {
            response = response.replace("%playerExp%", String.valueOf(ex.getPlayerExchangeData(p).getExp())).replace("%playerOwnExp%", String.valueOf(p.getLevel())).replace("%countdown%", String.valueOf(ex.getCountdown()));
        }
        if (ex != null && this.getConfig().getBoolean("authorize_money_exchange")) {
            response = response.replace("%playerMoney%", String.valueOf(ex.getPlayerExchangeData(p).getMoney())).replace("%playerOwnMoney%", String.valueOf(this.economy.getBalance((OfflinePlayer)p)));
        }
        if (partner != null) {
            response = response.replace("%partner%", partner.getDisplayName());
            ExchangeZone exZonePartner = ExchangeZone.getPlayerZone(this, partner);
            if (exZonePartner != null) {
                response = response.replace("%partnerZone%", exZonePartner.getName()).replace("%send_permission%", exZonePartner.getSendPerm()).replace("%accept_permission%", exZonePartner.getAcceptPerm());
            }
            if (ex != null) {
                response = response.replace("%partnerExp%", String.valueOf(ex.getPlayerExchangeData(partner).getExp())).replace("%partnerOwnExp%", String.valueOf(partner.getLevel()));
            }
            if (ex != null && this.getConfig().getBoolean("authorize_money_exchange")) {
                response = response.replace("%partnerMoney%", String.valueOf(ex.getPlayerExchangeData(partner).getMoney())).replace("%partnerOwnMoney%", String.valueOf(this.economy.getBalance((OfflinePlayer)partner)));
            }
        }
        return response;
    }

    public String applyVariables(String text, Player p, Player partner) {
        return this.applyVariables_fullParameters(text, p, partner);
    }

    public String applyVariables(String text, Player p) {
        Exchange ex = Exchange.getExchange(p);
        if (ex == null) {
            return this.applyVariables_fullParameters(text, p, null);
        }
        return this.applyVariables_fullParameters(text, p, ex.getOtherPlayer(p));
    }
}

