/*
 * Decompiled with CFR 0.152.
 */
package me.bullobily.events;

import me.bullobily.command.CommandTradeSend;
import me.bullobily.main.Main;
import me.bullobily.objects.Exchange;
import me.bullobily.objects.ExchangeZone;
import me.bullobily.objects.PlayerExchangeData;
import me.bullobily.utils.MessageLibrary;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.server.PluginDisableEvent;

public class EventsHandler
implements Listener {
    private Main plugin;

    public EventsHandler(Main main) {
        this.plugin = main;
    }

    @EventHandler
    public void onJoinEvent(PlayerJoinEvent e) {
        CommandTradeSend.setTarget(e.getPlayer(), e.getPlayer());
    }

    @EventHandler
    public void onQuitEvent(PlayerQuitEvent e) {
        Exchange ex = Exchange.getExchange(e.getPlayer());
        if (ex != null) {
            ex.getOtherPlayer(e.getPlayer()).sendMessage(this.plugin.getConfig().getString("text.message.exchange_cancel_partner_choice"));
            ex.conclude(false);
        }
    }

    @EventHandler
    public void onBlockDamage(BlockDamageEvent e) {
    }

    @EventHandler
    public void onCloseInventory(InventoryCloseEvent e) {
        PlayerExchangeData ped;
        if (!(e.getPlayer() instanceof Player)) {
            return;
        }
        Exchange ex = Exchange.getExchange((Player)e.getPlayer());
        if (ex != null && (ped = ex.getPlayerExchangeData((Player)e.getPlayer())).getExp() > -1.0f && ped.getMoney() > -1.0f) {
            ped.getPlayer().sendMessage(this.plugin.getConfig().getString("text.message.exchange_cancel_player_choice"));
            ex.getOtherPlayer(ped.getPlayer()).sendMessage(this.plugin.getConfig().getString("text.message.exchange_cancel_partner_choice"));
            ex.conclude(false);
        }
    }

    @EventHandler
    public void onPickupItem(EntityPickupItemEvent e) {
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        Exchange ex = Exchange.getExchange((Player)e.getEntity());
        if (ex != null) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent e) {
        Exchange ex = Exchange.getExchange(e.getPlayer());
        if (ex != null) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onServerClose(PluginDisableEvent e) {
        if (e.getPlugin().getName().equals(this.plugin.getConfig().getString("economy_plugin_name"))) {
            Exchange.cancelAllExchanges();
        }
    }

    @EventHandler
    public void onChatEvent(AsyncPlayerChatEvent e) {
        Exchange ex = Exchange.getExchange(e.getPlayer());
        if (ex == null) {
            return;
        }
        e.setCancelled(true);
        PlayerExchangeData ped = ex.getPlayerExchangeData(e.getPlayer());
        long amount = 0L;
        try {
            amount = Math.max(Long.parseLong(e.getMessage()), 0L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ped.getExp() == -1.0f) {
            amount = Math.min(amount, (long)ped.getPlayer().getLevel());
            ped.getPlayer().setLevel((int)((long)ped.getPlayer().getLevel() - amount));
            ped.setExp(amount);
        } else if (ped.getMoney() == -1.0f) {
            amount = (long)Math.min((double)amount, this.plugin.getEconomy().getBalance((OfflinePlayer)ped.getPlayer()));
            this.plugin.getEconomy().withdrawPlayer((OfflinePlayer)ped.getPlayer(), (double)amount);
            ped.setMoney(amount);
        }
        ped.getPlayer().openInventory(ped.getInterface());
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent e) {
        Exchange ex = Exchange.getExchange(e.getPlayer());
        if (ex == null) {
            return;
        }
        Player p1 = e.getPlayer();
        Player p2 = ex.getOtherPlayer(p1);
        if (ExchangeZone.getPlayerZone(this.plugin, p1) != null && ExchangeZone.getPlayerZone(this.plugin, p2) != null && ExchangeZone.getPlayerZone(this.plugin, p1).equals(ExchangeZone.getPlayerZone(this.plugin, p2)) && p1.getLocation().distance(p2.getLocation()) < (double)this.plugin.getConfig().getInt("max_distance_between_players")) {
            return;
        }
        p1.sendMessage(MessageLibrary.CANCELLATION_PLAYER_DEMAND.getMessage(this.plugin, p1, p2));
        p2.sendMessage(MessageLibrary.CANCELLATION_PARTNER_DEMAND.getMessage(this.plugin, p2, p1));
        ex.conclude(false);
    }
}

