/*
 * Decompiled with CFR 0.152.
 */
package me.bullobily.events;

import me.bullobily.main.Main;
import me.bullobily.objects.Exchange;
import me.bullobily.objects.PlayerExchangeData;
import me.bullobily.threads.GiveCountdown;
import me.bullobily.threads.LoadingItem;
import me.bullobily.utils.ItemLibrary;
import me.bullobily.utils.MessageLibrary;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;

public class EventClickInventory
implements Listener {
    private Main plugin;

    public EventClickInventory(Main main) {
        this.plugin = main;
    }

    @EventHandler
    public void onInventoryClose(InventoryClickEvent e) {
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Exchange ex = Exchange.getExchange((Player)e.getWhoClicked());
        if (ex == null) {
            return;
        }
        PlayerExchangeData pData = ex.getPlayerExchangeData((Player)e.getWhoClicked());
        PlayerExchangeData pOtherData = ex.getPlayerExchangeData(ex.getOtherPlayer((Player)e.getWhoClicked()));
        InventoryAction act = e.getAction();
        if (act.equals((Object)InventoryAction.HOTBAR_SWAP) || act.equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY) || act.equals((Object)InventoryAction.HOTBAR_MOVE_AND_READD) || act.equals((Object)InventoryAction.UNKNOWN)) {
            e.setCancelled(true);
        }
        if (pData.getExchangeStatus() == 1) {
            int slot = e.getRawSlot();
            if (!(slot >= 18 && slot <= 21 || slot >= 27 && slot <= 30 || slot >= 36 && slot <= 39 || slot >= 45 && slot <= 48 || slot >= 54)) {
                e.setCancelled(true);
            }
        } else {
            e.setCancelled(true);
        }
        if (e.getRawSlot() == 1) {
            pData.getPlayer().sendMessage(MessageLibrary.CANCELLATION_PLAYER_DEMAND.getMessage(this.plugin, pData.getPlayer(), pOtherData.getPlayer()));
            pOtherData.getPlayer().sendMessage(MessageLibrary.CANCELLATION_PARTNER_DEMAND.getMessage(this.plugin, pOtherData.getPlayer(), pData.getPlayer()));
            ex.conclude(false);
            return;
        }
        if (e.getRawSlot() == 0) {
            if (pData.getExchangeStatus() <= pOtherData.getExchangeStatus() && pData.getExchangeStatus() < 3) {
                pData.setNextExchangeStep();
                if (pData.getExchangeStatus() != pOtherData.getExchangeStatus()) {
                    new LoadingItem(this.plugin, ex, pData.getPlayer()).start();
                } else {
                    pData.getInterface().setItem(8, ItemLibrary.PLAYERSTATE_BOTH_WAITING.getItem(this.plugin, pData.getPlayer()));
                    pOtherData.getInterface().setItem(8, ItemLibrary.PLAYERSTATE_BOTH_WAITING.getItem(this.plugin, pOtherData.getPlayer()));
                    if (pData.getExchangeStatus() == 2) {
                        pData.getInterface().setItem(6, ItemLibrary.EXCHANGE_STATE_2.getItem(this.plugin, pData.getPlayer()));
                        pOtherData.getInterface().setItem(6, ItemLibrary.EXCHANGE_STATE_2.getItem(this.plugin, pOtherData.getPlayer()));
                        pData.generateItemsList();
                        pOtherData.generateItemsList();
                        ex.updateItemsListOnInterface(pOtherData);
                        ex.updateItemsListOnInterface(pData);
                    } else if (pData.getExchangeStatus() == 3) {
                        pData.getInterface().setItem(6, ItemLibrary.EXCHANGE_STATE_3.getItem(this.plugin, pData.getPlayer()));
                        pOtherData.getInterface().setItem(6, ItemLibrary.EXCHANGE_STATE_3.getItem(this.plugin, pOtherData.getPlayer()));
                        new GiveCountdown(this.plugin, ex).start();
                    }
                }
            }
            return;
        }
        if (e.getRawSlot() == 3 && pData.getExchangeStatus() == 1 && this.plugin.getConfig().getBoolean("authorize_exp_exchange")) {
            pData.getPlayer().setLevel((int)(pData.getExp() + (float)pData.getPlayer().getLevel()));
            pData.setExp(-1.0f);
            pData.getPlayer().sendMessage(MessageLibrary.EXP_SELECTION.getMessage(this.plugin, pData.getPlayer(), ex.getOtherPlayer(pData.getPlayer())));
            pData.getPlayer().closeInventory();
        }
        if (e.getRawSlot() == 4 && pData.getExchangeStatus() == 1 && this.plugin.getConfig().getBoolean("authorize_money_exchange")) {
            this.plugin.getEconomy().depositPlayer((OfflinePlayer)pData.getPlayer(), (double)pData.getMoney());
            pData.setMoney(-1.0f);
            pData.getPlayer().sendMessage(MessageLibrary.MONEY_SELECTION.getMessage(this.plugin, pData.getPlayer(), ex.getOtherPlayer(pData.getPlayer())));
            pData.getPlayer().closeInventory();
        }
    }
}

