/*
 * Decompiled with CFR 0.152.
 */
package me.bullobily.command;

import java.util.HashMap;
import java.util.Map;
import me.bullobily.main.Main;
import me.bullobily.objects.ExchangeZone;
import me.bullobily.utils.MessageLibrary;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandTradeSend
implements CommandExecutor {
    private Main plugin;
    private static Map<Player, Player> waitingQueries = new HashMap<Player, Player>();

    public CommandTradeSend(Main main) {
        this.plugin = main;
    }

    public static void setTarget(Player p, Player target) {
        waitingQueries.put(p, target);
    }

    public static Player getTarget(Player p) {
        return waitingQueries.get(p);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String arg, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("You can't use /" + arg + " via command blocks or console.");
            return false;
        }
        if (args.length != 1) {
            sender.sendMessage(MessageLibrary.COMMAND_INVALID_USAGE.getMessage(this.plugin, (Player)sender, null));
            return false;
        }
        CommandTradeSend.commandSend(this.plugin, (Player)sender, args[0]);
        return false;
    }

    public static void commandSend(Main plugin, Player p, String targetPlayerName) {
        ExchangeZone exZ;
        Player target = Bukkit.getPlayer((String)targetPlayerName);
        if (!Bukkit.getOnlinePlayers().contains(target)) {
            p.sendMessage(MessageLibrary.COMMAND_OFFLINE_TARGET.getMessage(plugin, p, target));
            return;
        }
        if (p.equals(target)) {
            p.sendMessage(MessageLibrary.COMMAND_HIMSELF_TRADE.getMessage(plugin, p, null));
            return;
        }
        if (!CommandTradeSend.getTarget(p).equals(p)) {
            p.sendMessage(MessageLibrary.COMMAND_OTHERS_REQUESTS_CANCELLED.getMessage(plugin, p, null));
            target.sendMessage(MessageLibrary.COMMAND_CANCELLED_DEMAND.getMessage(plugin, p, target));
        }
        if ((exZ = ExchangeZone.getPlayerZone(plugin, p)) == null) {
            p.sendMessage(MessageLibrary.COMMAND_OUT_OF_ZONE.getMessage(plugin, p, target));
            return;
        }
        if (!p.hasPermission(exZ.getSendPerm())) {
            p.sendMessage(MessageLibrary.COMMAND_SEND_PERMISSION_DENIED.getMessage(plugin, p, target));
            return;
        }
        CommandTradeSend.setTarget(p, target);
        p.sendMessage(MessageLibrary.COMMAND_SEND_DEMAND.getMessage(plugin, p, target));
        target.sendMessage(MessageLibrary.COMMAND_RECIEVE_DEMAND.getMessage(plugin, target, p));
    }
}

