/*
 * Decompiled with CFR 0.152.
 */
package me.bullobily.command;

import me.bullobily.command.CommandTradeSend;
import me.bullobily.main.Main;
import me.bullobily.objects.Exchange;
import me.bullobily.objects.ExchangeZone;
import me.bullobily.utils.MessageLibrary;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandTradeAccept
implements CommandExecutor {
    private Main plugin;

    public CommandTradeAccept(Main main) {
        this.plugin = main;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String arg, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("You can't use /" + arg + " via command blocks or console.");
            return false;
        }
        if (args.length != 1) {
            sender.sendMessage(MessageLibrary.COMMAND_INVALID_USAGE.getMessage(this.plugin, (Player)sender, null));
            return false;
        }
        CommandTradeAccept.commandAccept(this.plugin, (Player)sender, args[0]);
        return false;
    }

    public static void commandAccept(Main plugin, Player p, String targetPlayerName) {
        Player target = Bukkit.getPlayer((String)targetPlayerName);
        if (!Bukkit.getOnlinePlayers().contains(target)) {
            p.sendMessage(MessageLibrary.COMMAND_OFFLINE_TARGET.getMessage(plugin, p, target));
            return;
        }
        if (p.equals(target)) {
            p.sendMessage(MessageLibrary.COMMAND_HIMSELF_TRADE.getMessage(plugin, p, null));
            return;
        }
        if (!CommandTradeSend.getTarget(target).equals(p)) {
            p.sendMessage(MessageLibrary.COMMAND_NO_DEMAND.getMessage(plugin, p, target));
            return;
        }
        ExchangeZone exZ = ExchangeZone.getPlayerZone(plugin, p);
        if (exZ == null) {
            p.sendMessage(MessageLibrary.COMMAND_OUT_OF_ZONE.getMessage(plugin, p, target));
            return;
        }
        if (!p.hasPermission(exZ.getAcceptPerm())) {
            p.sendMessage(MessageLibrary.COMMAND_ACCEPT_PERMISSION_DENIED.getMessage(plugin, p, target));
            return;
        }
        if (ExchangeZone.getPlayerZone(plugin, target).equals(ExchangeZone.getPlayerZone(plugin, p))) {
            if (target.getLocation().distance(p.getLocation()) <= (double)plugin.getConfig().getInt("max_distance_between_players")) {
                p.sendMessage(MessageLibrary.COMMAND_EXCHANGE_START.getMessage(plugin, p, target));
                target.sendMessage(MessageLibrary.COMMAND_EXCHANGE_START.getMessage(plugin, target, p));
                new Exchange(plugin, p, target);
            } else {
                p.sendMessage(MessageLibrary.COMMAND_TOO_FAR.getMessage(plugin, p, target));
                target.sendMessage(MessageLibrary.COMMAND_TOO_FAR.getMessage(plugin, target, p));
            }
        } else {
            p.sendMessage(MessageLibrary.COMMAND_DIFFERENT_ZONE.getMessage(plugin, p, target));
            target.sendMessage(MessageLibrary.COMMAND_DIFFERENT_ZONE.getMessage(plugin, target, p));
        }
    }
}

