/*
 * Decompiled with CFR 0.152.
 */
package me.bullobily.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.bullobily.command.CommandTradeAccept;
import me.bullobily.command.CommandTradeSend;
import me.bullobily.main.Main;
import me.bullobily.objects.ExchangeZone;
import me.bullobily.utils.MessageLibrary;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandTrade
implements CommandExecutor {
    private Main plugin;
    public static Map<Player, ExchangeZone> zonesAddingInProgress = new HashMap<Player, ExchangeZone>();

    public CommandTrade(Main main) {
        this.plugin = main;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String arg, String[] args) {
        block44: {
            block49: {
                Player p;
                block47: {
                    block45: {
                        block42: {
                            if (!(sender instanceof Player)) {
                                sender.sendMessage("You can't use /" + arg + " via command blocks or console.");
                                return false;
                            }
                            if (args.length == 0) {
                                sender.sendMessage("\u00a76[SecuredExchanges] Secured exchanges plugin v" + this.plugin.getDescription().getVersion() + " by Bullobily. \nSee more at spigotmc.org");
                                return false;
                            }
                            p = (Player)sender;
                            if (args.length != 1) break block42;
                            switch (args[0]) {
                                case "send": {
                                    CommandTradeSend.commandSend(this.plugin, p, args[0]);
                                    break;
                                }
                                case "accept": {
                                    CommandTradeAccept.commandAccept(this.plugin, p, args[0]);
                                    break;
                                }
                                case "help": {
                                    this.commandHelp(p);
                                    break;
                                }
                                default: {
                                    sender.sendMessage(MessageLibrary.COMMAND_INVALID_USAGE.getMessage(this.plugin, (Player)sender, null));
                                }
                            }
                            return false;
                        }
                        if (!args[0].equals("zone")) break block44;
                        if (args.length != 2) break block45;
                        switch (args[1]) {
                            case "list": {
                                this.commandZonesList(p);
                                break;
                            }
                            case "corner": {
                                this.commandCorner(p);
                                break;
                            }
                            default: {
                                sender.sendMessage(MessageLibrary.COMMAND_INVALID_USAGE.getMessage(this.plugin, (Player)sender, null));
                            }
                        }
                    }
                    if (args.length != 3) break block47;
                    switch (args[1]) {
                        case "info": {
                            this.commandInfo(p, args[2]);
                            break;
                        }
                        case "delete": {
                            this.commandDelete(p, args[2]);
                            break;
                        }
                        default: {
                            sender.sendMessage(MessageLibrary.COMMAND_INVALID_USAGE.getMessage(this.plugin, (Player)sender, null));
                        }
                    }
                }
                if (args.length != 5) break block49;
                switch (args[1]) {
                    case "add": {
                        this.commandAdd(p, args[2], args[3], args[4]);
                        break;
                    }
                    default: {
                        sender.sendMessage(MessageLibrary.COMMAND_INVALID_USAGE.getMessage(this.plugin, (Player)sender, null));
                    }
                }
            }
            return false;
        }
        sender.sendMessage(MessageLibrary.COMMAND_INVALID_USAGE.getMessage(this.plugin, (Player)sender, null));
        return false;
    }

    private void commandHelp(Player p) {
        if (!p.hasPermission("securesexchanges.zone.display.help")) {
            p.sendMessage(MessageLibrary.COMMAND_PERMISSION_DENIED.getMessage(this.plugin, p, null));
            return;
        }
        p.sendMessage("\n\u00a7e   >>> \u00a76SECURED EXCHANGES HELP \u00a7e<<<");
        p.sendMessage("\u00a7e\n/se send <player> OR /ses <player> \u00a76: envoie une req <player");
        p.sendMessage("\u00a7e/se accept <player> OR /sea <player> \u00a76: accept trade request from <player>");
        p.sendMessage("\u00a7e/se zone list \u00a76: display all existing zones");
        p.sendMessage("\u00a7e/se zone info <zone> \u00a76: display location and permissions of <zone> zone");
        p.sendMessage("\u00a7e/se zone delete <zone> \u00a76: delete <zone> exchange zone");
        p.sendMessage("\u00a7e/se zone add <zone> <send_permission> <accept_permission> \u00a76: add <zone> exchange zone and set the first corner at your current location. Then use /se zone corner to setup the 2nd area corner");
        p.sendMessage("\u00a7e/se zone corner \u00a76: after using /se zone add, use this command to define the 2nd area corner");
        p.sendMessage("\u00a7e/se help \u00a76: display commands list and descriptions");
    }

    private void commandZonesList(Player p) {
        if (!p.hasPermission("securesexchanges.zone.display.list")) {
            p.sendMessage(MessageLibrary.COMMAND_PERMISSION_DENIED.getMessage(this.plugin, p, null));
            return;
        }
        p.sendMessage("\n\u00a7e   >>> \u00a76EXCHANGED ZONES \u00a7e<<<");
        for (ExchangeZone exZ : ExchangeZone.getAllExchangesZones(this.plugin)) {
            p.sendMessage("\n" + exZ.toString());
        }
        if (ExchangeZone.getAllExchangesZones(this.plugin).size() == 0) {
            p.sendMessage("\n\u00a7c   >> No zone found.\n");
        }
    }

    private void commandInfo(Player p, String zoneName) {
        if (!p.hasPermission("securesexchanges.zone.display.info")) {
            p.sendMessage(MessageLibrary.COMMAND_PERMISSION_DENIED.getMessage(this.plugin, p, null));
            return;
        }
        ExchangeZone exZ = ExchangeZone.getZone(this.plugin, zoneName);
        if (exZ == null) {
            p.sendMessage(MessageLibrary.COMMAND_WRONG_ZONE_NAME.getMessage(this.plugin, p, null));
            return;
        }
        p.sendMessage(exZ.toString());
    }

    private void commandDelete(Player p, String zoneName) {
        if (!p.hasPermission("securesexchanges.zone.edit.delete")) {
            p.sendMessage(MessageLibrary.COMMAND_PERMISSION_DENIED.getMessage(this.plugin, p, null));
            return;
        }
        ExchangeZone exZ = ExchangeZone.getZone(this.plugin, zoneName);
        if (exZ == null) {
            p.sendMessage(MessageLibrary.COMMAND_WRONG_ZONE_NAME.getMessage(this.plugin, p, null));
            return;
        }
        List newZoneList = new ArrayList();
        if (this.plugin.getConfig().getList("zones_list") != null) {
            newZoneList = this.plugin.getConfig().getList("zones_list");
        }
        newZoneList.remove(exZ);
        this.plugin.getConfig().set("zones_list", newZoneList);
        p.sendMessage("\u00a7eExchange zone '" + zoneName + "' successfully deleted.");
    }

    private void commandAdd(Player p, String zoneName, String permSend, String permAccept) {
        if (!p.hasPermission("securesexchanges.zone.edit.add")) {
            p.sendMessage(MessageLibrary.COMMAND_PERMISSION_DENIED.getMessage(this.plugin, p, null));
            return;
        }
        zonesAddingInProgress.put(p, new ExchangeZone(this.plugin, zoneName, p.getLocation(), p.getLocation(), permSend, permAccept));
        p.sendMessage("\u00a7a" + zoneName + "\u00a7a creation is in progress! To complete, execute '/se zone corner' to define the 2nd corner of the area.");
    }

    private void commandCorner(Player p) {
        if (!p.hasPermission("securesexchanges.zone.edit.add")) {
            p.sendMessage(MessageLibrary.COMMAND_PERMISSION_DENIED.getMessage(this.plugin, p, null));
            return;
        }
        if (!zonesAddingInProgress.keySet().contains(p)) {
            p.sendMessage("\u00a7cYou aren't currently creating an exchange zone. Use /se zone add to create a new one.");
            return;
        }
        List<ExchangeZone> newZoneList = new ArrayList();
        if (this.plugin.getConfig().getList("zones_list") != null) {
            newZoneList = this.plugin.getConfig().getList("zones_list");
        }
        zonesAddingInProgress.get(p).setLocation_2(p.getLocation());
        newZoneList.add(zonesAddingInProgress.get(p));
        this.plugin.getConfig().set("zones_list", newZoneList);
        p.sendMessage("\u00a76New exchange zone " + zonesAddingInProgress.get(p).getName() + "\u00a76 added! Description: \n" + zonesAddingInProgress.get(p).toString());
        zonesAddingInProgress.remove(p);
    }
}

