/*
 * Decompiled with CFR 0.152.
 */
package org.jnbt;

import org.jnbt.Tag;

public final class FloatTag
extends Tag {
    private final float value;

    public FloatTag(String name, float value) {
        super(name);
        this.value = value;
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    public String toString() {
        String name = this.getName();
        Object append = "";
        if (name != null && !name.equals("")) {
            append = "(\"" + this.getName() + "\")";
        }
        return "TAG_Float" + (String)append + ": " + this.value;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + Float.floatToIntBits(this.value);
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof FloatTag)) {
            return false;
        }
        FloatTag other = (FloatTag)obj;
        return Float.floatToIntBits(this.value) == Float.floatToIntBits(other.value);
    }
}

