/*
 * Decompiled with CFR 0.152.
 */
package org.jnbt;

import org.jnbt.Tag;

public final class DoubleTag
extends Tag {
    private final double value;

    public DoubleTag(String name, double value) {
        super(name);
        this.value = value;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    public String toString() {
        String name = this.getName();
        Object append = "";
        if (name != null && !name.equals("")) {
            append = "(\"" + this.getName() + "\")";
        }
        return "TAG_Double" + (String)append + ": " + this.value;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        long temp = Double.doubleToLongBits(this.value);
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DoubleTag)) {
            return false;
        }
        DoubleTag other = (DoubleTag)obj;
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
    }
}

