/*
 * Decompiled with CFR 0.152.
 */
package org.jnbt;

import java.util.Collections;
import java.util.Map;
import org.jnbt.Tag;

public final class CompoundTag
extends Tag {
    private final Map<String, Tag> value;

    public CompoundTag(String name, Map<String, Tag> value) {
        super(name);
        this.value = Collections.unmodifiableMap(value);
    }

    @Override
    public Map<String, Tag> getValue() {
        return this.value;
    }

    public String toString() {
        String name = this.getName();
        Object append = "";
        if (name != null && !name.equals("")) {
            append = "(\"" + this.getName() + "\")";
        }
        StringBuilder bldr = new StringBuilder();
        bldr.append("TAG_Compound").append((String)append).append(": ").append(this.value.size()).append(" entries\r\n{\r\n");
        for (Map.Entry<String, Tag> entry : this.value.entrySet()) {
            bldr.append("   ").append(entry.getValue().toString().replaceAll("\r\n", "\r\n   ")).append("\r\n");
        }
        bldr.append("}");
        return bldr.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.value == null ? 0 : this.value.hashCode());
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CompoundTag)) {
            return false;
        }
        CompoundTag other = (CompoundTag)obj;
        if (this.value == null) {
            return other.value == null;
        }
        return this.value.equals(other.value);
    }
}

