/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.undo;

import com._14ercooper.worldeditor.async.AsyncManager;
import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.undo.UndoElement;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\b\u0016\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0016J\b\u0010\u0017\u001a\u00020\rH\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0014H\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/_14ercooper/worldeditor/undo/UserUndo;", "", "thisName", "", "(Ljava/lang/String;)V", "name", "getName", "()Ljava/lang/String;", "setName", "redoList", "", "undoElements", "Ljava/util/HashMap;", "Lcom/_14ercooper/worldeditor/undo/UndoElement;", "getUndoElements", "()Ljava/util/HashMap;", "setUndoElements", "(Ljava/util/HashMap;)V", "undoList", "finalizeUndo", "", "undo", "flush", "getNewUndoElement", "loadUndoList", "redoChanges", "count", "", "saveUndoList", "undoChanges", "Companion", "14erEdit"})
public class UserUndo {
    @NotNull
    private HashMap<String, UndoElement> undoElements;
    private List<String> undoList;
    private List<String> redoList;
    @NotNull
    private String name;
    public static final long maxListSize = 500L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final HashMap<String, UndoElement> getUndoElements() {
        return this.undoElements;
    }

    public final void setUndoElements(@NotNull HashMap<String, UndoElement> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, "<set-?>");
        this.undoElements = hashMap;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.name = string;
    }

    @NotNull
    public UndoElement getNewUndoElement() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue(string, "UUID.randomUUID().toString()");
        String uuid = string;
        UndoElement undoElement = new UndoElement(uuid, this);
        ((Map)this.undoElements).put(uuid, undoElement);
        Main.Companion.logDebug("New undo for user " + this.name + " created with ID " + uuid);
        return undoElement;
    }

    public boolean finalizeUndo(@NotNull UndoElement undo) {
        Intrinsics.checkNotNullParameter(undo, "undo");
        if (this.undoElements.containsKey(undo.getName())) {
            BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(undo, null){
                int label;
                final /* synthetic */ UndoElement $undo;

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            this.label = 1;
                            Object object3 = this.$undo.flush(this);
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure($result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$undo = undoElement;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkNotNullParameter(completion, "completion");
                    Function2<CoroutineScope, Continuation<? super Boolean>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 1, null);
            this.undoList.add(undo.getName());
            this.undoElements.remove(undo.getName());
            Main.Companion.logDebug("Undo with id " + undo.getName() + " finalized");
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean undoChanges(int count2) {
        void $this$filterTo$iv$iv2;
        void $this$filter$iv;
        this.flush();
        Iterable iterable = this.undoList;
        UserUndo userUndo = this;
        boolean $i$f$filter = false;
        void var4_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = false;
            if (!(!StringsKt.isBlank(charSequence))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        userUndo.undoList = TypeIntrinsics.asMutableList(list);
        int undoCount = RangesKt.coerceAtMost(count2, this.undoList.size());
        int $this$filterTo$iv$iv2 = 0;
        List undoSet = new ArrayList();
        $this$filterTo$iv$iv2 = 1;
        int n = undoCount;
        if ($this$filterTo$iv$iv2 <= n) {
            while (true) {
                void i;
                String s = this.undoList.get(this.undoList.size() - 1);
                UndoElement ue = new UndoElement(s, this);
                ue.startApplyUndo();
                undoSet.add(ue);
                this.redoList.add(s);
                this.undoList.remove(this.undoList.size() - 1);
                if (i == n) break;
                ++i;
            }
        }
        if (undoSet.isEmpty()) {
            Main.Companion.logDebug("Nothing to undo for " + this.name);
            return true;
        }
        UUID uuid = UUID.fromString(this.name);
        Player player = Bukkit.getServer().getPlayer(uuid);
        if (player == null) {
            ConsoleCommandSender consoleCommandSender = Bukkit.getConsoleSender();
            player = consoleCommandSender;
            Intrinsics.checkNotNullExpressionValue(consoleCommandSender, "Bukkit.getConsoleSender()");
        }
        AsyncManager.scheduleEdit(undoSet, (CommandSender)player);
        Main.Companion.logDebug("Undoing " + count2 + " changes for " + this.name);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean redoChanges(int count2) {
        void $this$filterTo$iv$iv2;
        void $this$filter$iv;
        this.flush();
        Iterable iterable = this.redoList;
        UserUndo userUndo = this;
        boolean $i$f$filter = false;
        void var4_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = false;
            if (!(!StringsKt.isBlank(charSequence))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        userUndo.redoList = TypeIntrinsics.asMutableList(list);
        int redoCount = RangesKt.coerceAtMost(count2, this.redoList.size());
        int $this$filterTo$iv$iv2 = 0;
        List redoSet = new ArrayList();
        $this$filterTo$iv$iv2 = 1;
        int n = redoCount;
        if ($this$filterTo$iv$iv2 <= n) {
            while (true) {
                void i;
                String s = this.redoList.get(this.redoList.size() - 1);
                UndoElement ue = new UndoElement(s, this);
                ue.startApplyRedo();
                redoSet.add(ue);
                this.undoList.add(s);
                this.redoList.remove(this.redoList.size() - 1);
                if (i == n) break;
                ++i;
            }
        }
        if (redoSet.isEmpty()) {
            Main.Companion.logDebug("Nothing to redo for " + this.name);
            return true;
        }
        UUID uuid = UUID.fromString(this.name);
        Player player = Bukkit.getServer().getPlayer(uuid);
        if (player == null) {
            ConsoleCommandSender consoleCommandSender = Bukkit.getConsoleSender();
            player = consoleCommandSender;
            Intrinsics.checkNotNullExpressionValue(consoleCommandSender, "Bukkit.getConsoleSender()");
        }
        AsyncManager.scheduleEdit(redoSet, (CommandSender)player);
        Main.Companion.logDebug("Redoing " + count2 + " changes for " + this.name);
        return true;
    }

    private final boolean saveUndoList() {
        String fileName = "plugins/14erEdit/undo/" + this.name + '/';
        while ((long)this.undoList.size() > 500L) {
            String undoName = CollectionsKt.removeFirst(this.undoList);
            FilesKt.deleteRecursively(new File(fileName + undoName));
        }
        while ((long)this.redoList.size() > 500L) {
            String redoName = CollectionsKt.removeFirst(this.redoList);
            FilesKt.deleteRecursively(new File(fileName + redoName));
        }
        UserUndo userUndo = this;
        boolean bl = false;
        boolean bl2 = false;
        UserUndo $this$run = userUndo;
        boolean bl3 = false;
        Files.deleteIfExists(Path.of(fileName + "undoList", new String[0]));
        String str = "";
        for (String s : $this$run.undoList) {
            str = str + s + "\n";
        }
        Files.writeString(Path.of(fileName + "undoList", new String[0]), (CharSequence)str, new OpenOption[0]);
        userUndo = this;
        bl = false;
        bl2 = false;
        $this$run = userUndo;
        boolean bl4 = false;
        Files.deleteIfExists(Path.of(fileName + "redoList", new String[0]));
        str = "";
        for (String s : $this$run.redoList) {
            str = str + s + "\n";
        }
        Files.writeString(Path.of(fileName + "redoList", new String[0]), (CharSequence)str, new OpenOption[0]);
        Main.Companion.logDebug("Undo and redo lists for " + this.name + " saved to disk");
        return true;
    }

    private final boolean loadUndoList() {
        List list;
        boolean bl;
        CharSequence charSequence;
        String it;
        Iterable $this$filterTo$iv$iv;
        boolean $i$f$filterTo;
        Collection destination$iv$iv;
        Iterable $this$filter$iv;
        boolean $i$f$filter;
        UserUndo userUndo;
        String fileName = "plugins/14erEdit/undo/" + this.name + '/';
        if (Files.exists(Path.of(fileName + "undoList", new String[0]), new LinkOption[0])) {
            String string = Files.readString(Path.of(fileName + "undoList", new String[0]));
            Intrinsics.checkNotNullExpressionValue(string, "Files.readString(Path.of(fileName + \"undoList\"))");
            List<String> list2 = StringsKt.lines(string);
            if (list2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.String>");
            }
            this.undoList = TypeIntrinsics.asMutableList(list2);
            Iterable iterable = this.undoList;
            userUndo = this;
            $i$f$filter = false;
            void var4_5 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl2 = false;
                charSequence = it;
                bl = false;
                if (!(!StringsKt.isBlank(charSequence))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
            userUndo.undoList = TypeIntrinsics.asMutableList(list);
        }
        if (Files.exists(Path.of(fileName + "redoList", new String[0]), new LinkOption[0])) {
            String string = Files.readString(Path.of(fileName + "redoList", new String[0]));
            Intrinsics.checkNotNullExpressionValue(string, "Files.readString(Path.of(fileName + \"redoList\"))");
            List<String> list3 = StringsKt.lines(string);
            if (list3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.String>");
            }
            this.redoList = TypeIntrinsics.asMutableList(list3);
            $this$filter$iv = this.redoList;
            userUndo = this;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl3 = false;
                charSequence = it;
                bl = false;
                if (!(!StringsKt.isBlank(charSequence))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
            userUndo.redoList = TypeIntrinsics.asMutableList(list);
        }
        Main.Companion.logDebug("Loaded undo and redo lists for " + this.name + " from disk");
        return true;
    }

    public boolean flush() {
        try {
            this.saveUndoList();
        }
        catch (NoSuchFileException e) {
            Files.createDirectories(Path.of("plugins/14erEdit/undo/" + this.name, new String[0]), new FileAttribute[0]);
            this.saveUndoList();
        }
        BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ UserUndo this$0;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$forEach$iv = this.this$0.getUndoElements();
                        $i$f$forEach = false;
                        var4_5 = $this$forEach$iv;
                        var5_6 = false;
                        var6_7 = var4_5.entrySet().iterator();
lbl10:
                        // 3 sources

                        while (var6_7.hasNext()) {
                            $dstr$_u24__u24$undoElement = element$iv = var6_7.next();
                            $i$a$-forEach-UserUndo$flush$1$1 = false;
                            var10_11 = $dstr$_u24__u24$undoElement;
                            var11_12 = false;
                            undoElement = (UndoElement)var10_11.getValue();
                            this.L$0 = var6_7;
                            this.label = 1;
                            v0 = undoElement.flush(this);
                            if (v0 != var13_2) continue;
                            return var13_2;
                        }
                        break;
                    }
                    case 1: {
                        $i$f$forEach = false;
                        $i$a$-forEach-UserUndo$flush$1$1 = false;
                        var6_7 = (Iterator<Map.Entry<K, V>>)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
                        ** GOTO lbl10
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = userUndo;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, "completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
        this.undoElements = new HashMap();
        Main.Companion.logDebug("Flushed user undo for " + this.name);
        return true;
    }

    public UserUndo(@NotNull String thisName) {
        Intrinsics.checkNotNullParameter(thisName, "thisName");
        this.name = thisName;
        this.undoElements = new HashMap();
        boolean bl = false;
        this.undoList = new ArrayList();
        bl = false;
        this.redoList = new ArrayList();
        if (!StringsKt.equals(thisName, "dummy", true)) {
            this.loadUndoList();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/_14ercooper/worldeditor/undo/UserUndo$Companion;", "", "()V", "maxListSize", "", "14erEdit"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

