/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.undo;

import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.undo.UserUndo;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0005H\u0007J\u0012\u0010\u0007\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\b\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\fH\u0007R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/_14ercooper/worldeditor/undo/UndoSystem;", "", "()V", "userUndos", "", "", "Lcom/_14ercooper/worldeditor/undo/UserUndo;", "findUserUndo", "name", "user", "Lorg/bukkit/command/CommandSender;", "flush", "", "isFlushed", "14erEdit"})
public final class UndoSystem {
    private static Map<String, UserUndo> userUndos;
    @NotNull
    public static final UndoSystem INSTANCE;

    @JvmStatic
    @NotNull
    public static final UserUndo findUserUndo(@NotNull String name) {
        UserUndo userUndo;
        Intrinsics.checkNotNullParameter(name, "name");
        if (userUndos.containsKey(name)) {
            Main.Companion.logDebug("Found undo for user " + name);
            UserUndo userUndo2 = userUndos.get(name);
            Intrinsics.checkNotNull(userUndo2);
            userUndo = userUndo2;
        } else {
            Main.Companion.logDebug("Loading new undo for user " + name);
            userUndos.put(name, new UserUndo(name));
            UserUndo userUndo3 = userUndos.get(name);
            Intrinsics.checkNotNull(userUndo3);
            userUndo = userUndo3;
        }
        return userUndo;
    }

    @JvmStatic
    @NotNull
    public static final UserUndo findUserUndo(@Nullable CommandSender user) {
        String string = user instanceof Player ? ((Player)user).getUniqueId().toString() : "console";
        Intrinsics.checkNotNullExpressionValue(string, "if (user is Player) {\n  \u2026  \"console\"\n            }");
        return UndoSystem.findUserUndo(string);
    }

    @JvmStatic
    public static final boolean flush() {
        Map<String, UserUndo> $this$forEach$iv = userUndos;
        boolean $i$f$forEach = false;
        Map<String, UserUndo> map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, UserUndo>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, UserUndo> element$iv;
            Map.Entry<String, UserUndo> $dstr$_u24__u24$userUndo = element$iv = iterator2.next();
            boolean bl2 = false;
            Map.Entry<String, UserUndo> entry = $dstr$_u24__u24$userUndo;
            boolean bl3 = false;
            UserUndo userUndo = entry.getValue();
            userUndo.flush();
        }
        userUndos = new HashMap();
        Main.Companion.logDebug("Flushed undo system");
        return true;
    }

    @JvmStatic
    public static final boolean isFlushed() {
        boolean userUndosEmpty = true;
        Map<String, UserUndo> map2 = userUndos;
        boolean bl = false;
        Iterator<Map.Entry<String, UserUndo>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, UserUndo> entry;
            Map.Entry<String, UserUndo> entry2 = entry = iterator2.next();
            boolean bl2 = false;
            UserUndo userUndo = entry2.getValue();
            userUndosEmpty = userUndosEmpty && userUndo.getUndoElements().isEmpty();
        }
        return userUndos.isEmpty() && userUndosEmpty;
    }

    private UndoSystem() {
    }

    static {
        UndoSystem undoSystem;
        INSTANCE = undoSystem = new UndoSystem();
        userUndos = new HashMap();
    }
}

