/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.undo;

import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.main.NBTExtractor;
import com._14ercooper.worldeditor.main.SetBlock;
import com._14ercooper.worldeditor.undo.UndoElement;
import com._14ercooper.worldeditor.undo.UndoMode;
import com._14ercooper.worldeditor.undo.UserUndo;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.Job;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0010\b\u0016\u0018\u0000 @2\u00020\u0001:\u0001@B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0016J\u0010\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020$2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010,\u001a\u00020$H\u0016J\b\u0010-\u001a\u00020$H\u0016J\u0011\u0010.\u001a\u00020$H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010/J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\u0003012\u0006\u0010\u0002\u001a\u00020\fH\u0002J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\u0003012\u0006\u00103\u001a\u00020\fH\u0002J\b\u00104\u001a\u00020$H\u0002J\b\u00105\u001a\u00020$H\u0002J\b\u00106\u001a\u00020$H\u0002J@\u00107\u001a\u00020$2\u0006\u00108\u001a\u00020\u00032\u0006\u00109\u001a\u00020\f2\u0006\u0010:\u001a\u00020\f2\u0006\u0010;\u001a\u00020\f2\u0006\u0010<\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u0003H\u0016J\b\u0010>\u001a\u00020$H\u0016J\b\u0010?\u001a\u00020$H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006A"}, d2={"Lcom/_14ercooper/worldeditor/undo/UndoElement;", "", "id", "", "parent", "Lcom/_14ercooper/worldeditor/undo/UserUndo;", "(Ljava/lang/String;Lcom/_14ercooper/worldeditor/undo/UserUndo;)V", "asyncFiles", "", "Ljava/nio/channels/AsynchronousFileChannel;", "blockSizes", "currBlock", "", "currData", "<set-?>", "Lcom/_14ercooper/worldeditor/undo/UndoMode;", "currentState", "getCurrentState", "()Lcom/_14ercooper/worldeditor/undo/UndoMode;", "data", "getData", "()Ljava/util/List;", "setData", "(Ljava/util/List;)V", "dataBlockCount", "jobsRunning", "Lkotlinx/coroutines/Job;", "name", "getName", "()Ljava/lang/String;", "userUndo", "getUserUndo", "()Lcom/_14ercooper/worldeditor/undo/UserUndo;", "setUserUndo", "(Lcom/_14ercooper/worldeditor/undo/UserUndo;)V", "addBlock", "", "blockFrom", "Lorg/bukkit/block/BlockState;", "blockTo", "applyRedo", "blockCount", "", "applyUndo", "finalizeRedo", "finalizeUndo", "flush", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadBlock", "", "loadBlockLast", "idFromLast", "loadFromDisk", "serialize", "serializeBlock", "setBlock", "world", "x", "y", "z", "type", "nbt", "startApplyRedo", "startApplyUndo", "Companion", "14erEdit"})
public class UndoElement {
    @NotNull
    private UndoMode currentState;
    @NotNull
    private UserUndo userUndo;
    @NotNull
    private final String name;
    private List<Job> jobsRunning;
    private List<AsynchronousFileChannel> asyncFiles;
    private List<String> blockSizes;
    @NotNull
    private List<String> data;
    private int currBlock;
    private int dataBlockCount;
    private List<String> currData;
    public static final int blockSize = 65536;
    public static final int compressionLevel = 16;
    @NotNull
    private static final LZ4Factory factory;
    @NotNull
    private static final NBTExtractor nbtE;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final UndoMode getCurrentState() {
        return this.currentState;
    }

    @NotNull
    public final UserUndo getUserUndo() {
        return this.userUndo;
    }

    public final void setUserUndo(@NotNull UserUndo userUndo) {
        Intrinsics.checkNotNullParameter(userUndo, "<set-?>");
        this.userUndo = userUndo;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<String> getData() {
        return this.data;
    }

    public final void setData(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.data = list;
    }

    public boolean addBlock(@NotNull BlockState blockFrom, @NotNull BlockState blockTo) {
        Intrinsics.checkNotNullParameter(blockFrom, "blockFrom");
        Intrinsics.checkNotNullParameter(blockTo, "blockTo");
        if (this.currentState == UndoMode.IDLE) {
            this.currentState = UndoMode.WAITING_FOR_BLOCKS;
        }
        StringBuilder stringBuilder = new StringBuilder();
        World world = blockFrom.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "blockFrom.world");
        StringBuilder stringBuilder2 = stringBuilder.append(world.getName()).append("\t").append(String.valueOf(blockFrom.getX())).append("\t").append(String.valueOf(blockFrom.getY())).append("\t").append(String.valueOf(blockFrom.getZ())).append("\t").append(blockFrom.getType().toString()).append("\t");
        BlockData blockData = blockFrom.getBlockData();
        Intrinsics.checkNotNullExpressionValue(blockData, "blockFrom.blockData");
        StringBuilder stringBuilder3 = stringBuilder2.append(blockData.getAsString()).append("\t").append(nbtE.getNBT(blockFrom)).append("\t").append(blockTo.getType().toString()).append("\t");
        BlockData blockData2 = blockTo.getBlockData();
        Intrinsics.checkNotNullExpressionValue(blockData2, "blockTo.blockData");
        String str = stringBuilder3.append(blockData2.getAsString()).append("\t").append(nbtE.getNBT(blockTo)).toString();
        this.data.add(str);
        if (this.data.size() > 65536) {
            this.serializeBlock();
        }
        return true;
    }

    private final boolean serializeBlock() {
        int blockId = this.blockSizes.size();
        String string = CollectionsKt.joinToString$default(this.data, "\n", null, null, 0, null, null, 62, null);
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "(this as java.lang.String).getBytes(charset)");
        byte[] toSerialize = byArray;
        boolean bl2 = false;
        this.data = new ArrayList();
        int serializeLength = toSerialize.length;
        this.blockSizes.add(String.valueOf(serializeLength));
        LZ4Compressor compressor = factory.highCompressor(16);
        AsynchronousFileChannel asynchronousFileChannel = AsynchronousFileChannel.open(Path.of("plugins/14erEdit/undo/" + this.userUndo.getName() + '/' + this.name + '/' + blockId, new String[0]), StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        Intrinsics.checkNotNullExpressionValue(asynchronousFileChannel, "AsynchronousFileChannel.\u2026enOption.CREATE\n        )");
        AsynchronousFileChannel asyncFile = asynchronousFileChannel;
        this.jobsRunning.add(BuildersKt.launch$default(GlobalScope.INSTANCE, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, compressor, toSerialize, asyncFile, blockId, serializeLength, null){
            int label;
            final /* synthetic */ UndoElement this$0;
            final /* synthetic */ LZ4Compressor $compressor;
            final /* synthetic */ byte[] $toSerialize;
            final /* synthetic */ AsynchronousFileChannel $asyncFile;
            final /* synthetic */ int $blockId;
            final /* synthetic */ int $serializeLength;

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        byte[] compressed = this.$compressor.compress(this.$toSerialize);
                        this.$asyncFile.write(ByteBuffer.wrap(compressed), 0L);
                        Main.Companion.logDebug("Serialized undo block " + this.$blockId + " for undo " + this.this$0.getName() + " for user " + this.this$0.getUserUndo().getName() + " with length " + this.$serializeLength);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = undoElement;
                this.$compressor = lZ4Compressor;
                this.$toSerialize = byArray;
                this.$asyncFile = asynchronousFileChannel;
                this.$blockId = n;
                this.$serializeLength = n2;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, "completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null));
        return true;
    }

    private final List<String> loadBlock(int id) {
        String string = this.blockSizes.get(id);
        boolean bl = false;
        int decompLen = Integer.parseInt(string);
        byte[] compressedBytes = Files.readAllBytes(Path.of("plugins/14erEdit/undo/" + this.userUndo.getName() + '/' + this.name + '/' + id, new String[0]));
        LZ4FastDecompressor decompressor = factory.fastDecompressor();
        byte[] decompBytes = decompressor.decompress(compressedBytes, decompLen);
        Intrinsics.checkNotNullExpressionValue(decompBytes, "decompBytes");
        byte[] byArray = decompBytes;
        Charset charset = Charsets.UTF_8;
        boolean bl2 = false;
        boolean bl3 = false;
        String decompStr = new String(byArray, charset);
        Main.Companion.logDebug("Loaded undo block " + id + " for undo " + this.name + " for user " + this.userUndo.getName() + " with length " + decompLen);
        return StringsKt.lines(decompStr);
    }

    private final List<String> loadBlockLast(int idFromLast) {
        int id = this.blockSizes.size() - idFromLast - 1;
        return this.loadBlock(id);
    }

    private final boolean serialize() {
        Collection collection = this.data;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.serializeBlock();
        }
        Files.writeString(Path.of("plugins/14erEdit/undo/" + this.userUndo.getName() + '/' + this.name + "/blockSizes", new String[0]), (CharSequence)CollectionsKt.joinToString$default(this.blockSizes, "\\", null, null, 0, null, null, 62, null), new OpenOption[0]);
        int numBlocks = this.blockSizes.size();
        Main.Companion.logDebug("Serialized undo element " + this.name + " for user " + this.userUndo.getName() + " to disk with " + numBlocks + " blocks");
        return true;
    }

    private final boolean loadFromDisk() {
        String string = Files.readString(Path.of("plugins/14erEdit/undo/" + this.userUndo.getName() + '/' + this.name + "/blockSizes", new String[0]));
        Intrinsics.checkNotNullExpressionValue(string, "Files.readString(Path.of\u2026name}/$name/blockSizes\"))");
        List list = StringsKt.split$default((CharSequence)string, new String[]{"\\"}, false, 0, 6, null);
        if (list == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.String>");
        }
        this.blockSizes = TypeIntrinsics.asMutableList(list);
        int numBlocks = this.blockSizes.size();
        Main.Companion.logDebug("Loaded undo element " + this.name + " for user " + this.userUndo.getName() + " from disk with " + numBlocks + " blocks");
        return true;
    }

    public boolean startApplyUndo() {
        this.currBlock = -1;
        this.dataBlockCount = this.blockSizes.size();
        boolean bl = false;
        this.currData = new ArrayList();
        this.currentState = UndoMode.PERFORMING_UNDO;
        Main.Companion.logDebug("Started applying undo " + this.name + " for user " + this.userUndo.getName());
        return true;
    }

    public boolean applyUndo(long blockCount) {
        if (this.currentState != UndoMode.PERFORMING_UNDO) {
            return false;
        }
        long remBlocks = blockCount;
        while (remBlocks > 0L) {
            if (this.currData.size() == 0) {
                int n = this.currBlock;
                this.currBlock = n + 1;
                if (this.currBlock == this.dataBlockCount) {
                    this.currentState = UndoMode.UNDO_FINISHED;
                    return true;
                }
                n = 0;
                this.currData = new ArrayList();
                this.currData.addAll((Collection<String>)this.loadBlockLast(this.currBlock));
            }
            if (this.currData.isEmpty()) {
                Main.Companion.logDebug("Data in block " + this.currBlock + " is empty, continuing");
                continue;
            }
            String s = this.currData.remove(CollectionsKt.getLastIndex(this.currData));
            List nextBlockData = StringsKt.split$default((CharSequence)s, new String[]{"\t"}, false, 0, 6, null);
            if (s.length() >= 10) {
                String string = (String)nextBlockData.get(1);
                boolean bl = false;
                int n = Integer.parseInt(string);
                string = (String)nextBlockData.get(2);
                bl = false;
                int n2 = Integer.parseInt(string);
                string = (String)nextBlockData.get(3);
                bl = false;
                this.setBlock((String)nextBlockData.get(0), n, n2, Integer.parseInt(string), (String)nextBlockData.get(4), (String)nextBlockData.get(5), (String)nextBlockData.get(6));
            }
            long l = remBlocks;
            remBlocks = l + -1L;
        }
        return true;
    }

    public boolean finalizeUndo() {
        Main.Companion.logDebug("Finalized applying undo " + this.name + " for user " + this.userUndo.getName());
        return this.currentState == UndoMode.UNDO_FINISHED;
    }

    public boolean startApplyRedo() {
        this.currBlock = -1;
        this.dataBlockCount = this.blockSizes.size();
        boolean bl = false;
        this.currData = new ArrayList();
        this.currentState = UndoMode.PERFORMING_REDO;
        Main.Companion.logDebug("Started applying redo " + this.name + " for user " + this.userUndo.getName());
        return true;
    }

    public boolean applyRedo(long blockCount) {
        if (this.currentState != UndoMode.PERFORMING_REDO) {
            return false;
        }
        long remBlocks = blockCount;
        while (remBlocks > 0L) {
            if (this.currData.size() == 0) {
                int n = this.currBlock;
                this.currBlock = n + 1;
                if (this.currBlock == this.dataBlockCount) {
                    this.currentState = UndoMode.REDO_FINISHED;
                    return true;
                }
                n = 0;
                this.currData = new ArrayList();
                this.currData.addAll((Collection<String>)this.loadBlock(this.currBlock));
            }
            if (this.currData.isEmpty()) {
                Main.Companion.logDebug("Data in block " + this.currBlock + " is empty, continuing");
                continue;
            }
            String s = this.currData.remove(0);
            List nextBlockData = StringsKt.split$default((CharSequence)s, new String[]{"\t"}, false, 0, 6, null);
            if (s.length() >= 10) {
                String string = (String)nextBlockData.get(1);
                boolean bl = false;
                int n = Integer.parseInt(string);
                string = (String)nextBlockData.get(2);
                bl = false;
                int n2 = Integer.parseInt(string);
                string = (String)nextBlockData.get(3);
                bl = false;
                this.setBlock((String)nextBlockData.get(0), n, n2, Integer.parseInt(string), (String)nextBlockData.get(7), (String)nextBlockData.get(8), (String)nextBlockData.get(9));
            }
            long l = remBlocks;
            remBlocks = l + -1L;
        }
        return true;
    }

    public boolean finalizeRedo() {
        Main.Companion.logDebug("Finalized applying redo " + this.name + " for user " + this.userUndo.getName());
        return this.currentState == UndoMode.REDO_FINISHED;
    }

    public boolean setBlock(@NotNull String world, int x, int y, int z, @NotNull String type, @NotNull String data, @NotNull String nbt) {
        boolean bl;
        Block blk;
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter(data, "data");
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        World world2 = Bukkit.getServer().getWorld(world);
        Block block = blk = world2 != null ? world2.getBlockAt(x, y, z) : null;
        if (blk != null) {
            Material material = Material.matchMaterial((String)type);
            ConsoleCommandSender consoleCommandSender = Bukkit.getConsoleSender();
            Intrinsics.checkNotNullExpressionValue(consoleCommandSender, "Bukkit.getConsoleSender()");
            SetBlock.setMaterial(blk, material, false, this, (CommandSender)consoleCommandSender);
            blk.setBlockData(Bukkit.getServer().createBlockData(data));
            CharSequence charSequence = nbt;
            boolean bl2 = false;
            if (charSequence.length() > 0) {
                String command2 = "data merge block " + x + " " + y + " " + z + " " + nbt;
                Bukkit.dispatchCommand((CommandSender)((CommandSender)Bukkit.getConsoleSender()), (String)command2);
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public Object flush(@NotNull Continuation<? super Boolean> $completion) {
        return UndoElement.flush$suspendImpl(this, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object flush$suspendImpl(UndoElement var0, Continuation var1_1) {
        if (!(var1_1 instanceof flush.1)) ** GOTO lbl-1000
        var5_2 = var1_1;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, var1_1){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ UndoElement this$0;
                Object L$0;
                Object L$1;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return UndoElement.flush$suspendImpl(this.this$0, this);
                }
                {
                    this.this$0 = undoElement;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                var3_5 = this.jobsRunning.iterator();
lbl13:
                // 3 sources

                while (var3_5.hasNext()) {
                    j = var3_5.next();
                    $continuation.L$0 = this;
                    $continuation.L$1 = var3_5;
                    $continuation.label = 1;
                    v0 = j.join($continuation);
                    if (v0 != var6_4) continue;
                    return var6_4;
                }
                break;
            }
            case 1: {
                var3_5 = (Iterator<Job>)$continuation.L$1;
                this = (UndoElement)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
                ** GOTO lbl13
            }
        }
        for (AsynchronousFileChannel a : this.asyncFiles) {
            if (!a.isOpen()) continue;
            a.close();
        }
        var2_7 = false;
        this.jobsRunning = new ArrayList<E>();
        var2_7 = false;
        this.asyncFiles = new ArrayList<E>();
        if (this.currentState == UndoMode.PERFORMING_UNDO) {
            this.applyUndo(0x7FFFFFFFFFFFFFFFL);
            this.finalizeUndo();
        }
        if (this.currentState == UndoMode.PERFORMING_REDO) {
            this.applyRedo(0x7FFFFFFFFFFFFFFFL);
            this.finalizeRedo();
        }
        this.serialize();
        Main.Companion.logDebug("Flushed undo element " + this.name + " for user " + this.userUndo.getName());
        return Boxing.boxBoolean(true);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public UndoElement(@NotNull String id, @NotNull UserUndo parent) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(parent, "parent");
        this.currentState = UndoMode.IDLE;
        this.userUndo = parent;
        this.name = id;
        boolean bl = false;
        this.jobsRunning = new ArrayList();
        bl = false;
        this.asyncFiles = new ArrayList();
        bl = false;
        this.blockSizes = new ArrayList();
        bl = false;
        this.data = new ArrayList();
        if (!StringsKt.equals(id, "dummy", true)) {
            if (Files.exists(Path.of("plugins/14erEdit/undo/" + parent.getName() + '/' + this.name, new String[0]), new LinkOption[0])) {
                this.loadFromDisk();
                Main.Companion.logDebug("Loaded undo element " + this.name + " from disk for user " + parent.getName());
            } else {
                Files.createDirectories(Path.of("plugins/14erEdit/undo/" + parent.getName() + '/' + this.name, new String[0]), new FileAttribute[0]);
                this.serialize();
                Main.Companion.logDebug("Created new undo element " + this.name + " for user " + parent.getName());
            }
        }
        this.currBlock = -1;
        bl = false;
        this.currData = new ArrayList();
    }

    static {
        Companion = new Companion(null);
        LZ4Factory lZ4Factory = LZ4Factory.fastestInstance();
        Intrinsics.checkNotNullExpressionValue(lZ4Factory, "LZ4Factory.fastestInstance()");
        factory = lZ4Factory;
        nbtE = new NBTExtractor();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/_14ercooper/worldeditor/undo/UndoElement$Companion;", "", "()V", "blockSize", "", "compressionLevel", "factory", "Lnet/jpountz/lz4/LZ4Factory;", "getFactory", "()Lnet/jpountz/lz4/LZ4Factory;", "nbtE", "Lcom/_14ercooper/worldeditor/main/NBTExtractor;", "getNbtE", "()Lcom/_14ercooper/worldeditor/main/NBTExtractor;", "14erEdit"})
    public static final class Companion {
        @NotNull
        public final LZ4Factory getFactory() {
            return factory;
        }

        @NotNull
        public final NBTExtractor getNbtE() {
            return nbtE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

