/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.selection;

import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.player.PlayerManager;
import com._14ercooper.worldeditor.player.PlayerWrapper;
import com._14ercooper.worldeditor.selection.SelectionWand;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SelectionWandListener
implements Listener {
    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        boolean isValidPlayer;
        Player p = event.getPlayer();
        PlayerWrapper playerWrapper = PlayerManager.getPlayerWrapper((CommandSender)p);
        SelectionWand wand = playerWrapper.getSelectionWand();
        ItemStack itemStack = p.getInventory().getItemInMainHand();
        ItemMeta itemMeta = itemStack.getItemMeta();
        try {
            isValidPlayer = itemMeta.getDisplayName().equals("Selection Wand") && itemStack.getType().equals((Object)Material.WOODEN_AXE) && itemMeta.getEnchants().containsKey(Enchantment.MENDING);
        }
        catch (NullPointerException e) {
            isValidPlayer = false;
        }
        if (!isValidPlayer) {
            return;
        }
        if (wand.manager == null) {
            Main.logError("Could not use wand. Did you get a new wand after relogging?", (CommandSender)p, null);
            return;
        }
        if (event.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) {
            Block b = event.getClickedBlock();
            if (wand.manager.isMultiMode()) {
                wand.manager.setAnchorPoint(b.getX(), b.getY(), b.getZ(), p.getUniqueId().toString());
            } else {
                wand.manager.updatePositionOne(b.getX(), b.getY(), b.getZ(), p.getUniqueId().toString());
            }
            event.setCancelled(true);
        } else if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && (e = event.getHand()).equals((Object)EquipmentSlot.HAND)) {
            Block b = event.getClickedBlock();
            if (wand.manager.isMultiMode()) {
                wand.manager.addAdditionalPoint(b.getX(), b.getY(), b.getZ(), p.getUniqueId().toString());
            } else {
                wand.manager.updatePositionTwo(b.getX(), b.getY(), b.getZ(), p.getUniqueId().toString());
            }
            event.setCancelled(true);
        }
    }
}

