/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.selection;

import com._14ercooper.math.Point3;
import com._14ercooper.worldeditor.blockiterator.BlockIterator;
import com._14ercooper.worldeditor.blockiterator.IteratorManager;
import com._14ercooper.worldeditor.player.PlayerManager;
import com._14ercooper.worldeditor.player.PlayerWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SelectionManager {
    private Mode mode = Mode.SELECTION;
    protected final int[] clipboardOffset = new int[]{0, 0, 0};
    private double[] positionOne = new double[]{-1.0, -1.0, -1.0};
    private double[] positionTwo = new double[]{-1.0, -1.0, -1.0};
    protected String mirrorString = "";
    protected int executionOrder = 0;
    private double[] mostNegativeCorner = new double[3];
    private double[] mostPositiveCorner = new double[3];
    Point3 anchorPoint = null;
    List<Point3> additionalPoints = new ArrayList<Point3>();

    public static SelectionManager getSelectionManager(UUID player) {
        PlayerWrapper playerWrapper = PlayerManager.getPlayerWrapper(player);
        return playerWrapper.getSelectionWand().manager;
    }

    public boolean updatePositionOne(double x, double y, double z, String player) {
        this.positionOne[0] = x;
        PlayerWrapper playerWrapper = PlayerManager.getPlayerWrapper(player);
        this.positionOne[1] = y < (double)playerWrapper.getMinEditY() ? (double)playerWrapper.getMinEditY() : (y > (double)playerWrapper.getMaxEditY() ? (double)playerWrapper.getMaxEditY() : y);
        this.positionOne[2] = z;
        this.getPlayer(player).sendMessage("\u00a7dFirst position updated to (" + x + ", " + y + ", " + z + "); giving a volume of " + (Math.abs(this.positionOne[0] - this.positionTwo[0]) + 1.0) * (Math.abs(this.positionOne[1] - this.positionTwo[1]) + 1.0) * (Math.abs(this.positionOne[2] - this.positionTwo[2]) + 1.0));
        this.recalculateCorners();
        return true;
    }

    public boolean updatePositionTwo(double x, double y, double z, String player) {
        this.positionTwo[0] = x;
        PlayerWrapper playerWrapper = PlayerManager.getPlayerWrapper(player);
        this.positionTwo[1] = y < (double)playerWrapper.getMinEditY() ? (double)playerWrapper.getMinEditY() : (y > (double)playerWrapper.getMaxEditY() ? (double)playerWrapper.getMaxEditY() : y);
        this.positionTwo[2] = z;
        this.getPlayer(player).sendMessage("\u00a7dSecond position updated to (" + x + ", " + y + ", " + z + "); giving a volume of " + (Math.abs(this.positionOne[0] - this.positionTwo[0]) + 1.0) * (Math.abs(this.positionOne[1] - this.positionTwo[1]) + 1.0) * (Math.abs(this.positionOne[2] - this.positionTwo[2]) + 1.0));
        this.recalculateCorners();
        return true;
    }

    public boolean regionDefined() {
        if (this.positionOne[0] == -1.0 && this.positionOne[1] == -1.0 && this.positionOne[2] == -1.0) {
            return false;
        }
        return this.positionTwo[0] != -1.0 || this.positionTwo[1] != -1.0 || this.positionTwo[2] != -1.0;
    }

    private void recalculateCorners() {
        if (!this.regionDefined()) {
            return;
        }
        if (this.positionOne[0] <= this.positionTwo[0]) {
            this.mostNegativeCorner[0] = this.positionOne[0];
            this.mostPositiveCorner[0] = this.positionTwo[0];
        } else {
            this.mostNegativeCorner[0] = this.positionTwo[0];
            this.mostPositiveCorner[0] = this.positionOne[0];
        }
        if (this.positionOne[1] <= this.positionTwo[1]) {
            this.mostNegativeCorner[1] = this.positionOne[1];
            this.mostPositiveCorner[1] = this.positionTwo[1];
        } else {
            this.mostNegativeCorner[1] = this.positionTwo[1];
            this.mostPositiveCorner[1] = this.positionOne[1];
        }
        if (this.positionOne[2] <= this.positionTwo[2]) {
            this.mostNegativeCorner[2] = this.positionOne[2];
            this.mostPositiveCorner[2] = this.positionTwo[2];
        } else {
            this.mostNegativeCorner[2] = this.positionTwo[2];
            this.mostPositiveCorner[2] = this.positionOne[2];
        }
    }

    public double[] getMostNegativeCorner() {
        return this.mostNegativeCorner;
    }

    public double[] getMostPositiveCorner() {
        return this.mostPositiveCorner;
    }

    public double[] getPositionOne() {
        return this.positionOne;
    }

    public double[] getPositionTwo() {
        return this.positionTwo;
    }

    public boolean expandSelection(double amt, String direction, String player) {
        if (direction.equalsIgnoreCase("north")) {
            this.mostNegativeCorner[2] = this.mostNegativeCorner[2] - amt;
            this.expandSelectionMessage(player);
            return true;
        }
        if (direction.equalsIgnoreCase("south")) {
            this.mostPositiveCorner[2] = this.mostPositiveCorner[2] + amt;
            this.expandSelectionMessage(player);
            return true;
        }
        if (direction.equalsIgnoreCase("east")) {
            this.mostPositiveCorner[0] = this.mostPositiveCorner[0] + amt;
            this.expandSelectionMessage(player);
            return true;
        }
        if (direction.equalsIgnoreCase("west")) {
            this.mostNegativeCorner[0] = this.mostNegativeCorner[0] - amt;
            this.expandSelectionMessage(player);
            return true;
        }
        if (direction.equalsIgnoreCase("up")) {
            this.mostPositiveCorner[1] = this.mostPositiveCorner[1] + amt;
            this.expandSelectionMessage(player);
            return true;
        }
        if (direction.equalsIgnoreCase("down")) {
            this.mostNegativeCorner[1] = this.mostNegativeCorner[1] - amt;
            this.expandSelectionMessage(player);
            return true;
        }
        return false;
    }

    private void expandSelectionMessage(String player) {
        this.getPlayer(player).sendMessage("\u00a7dRegion expanded to " + Math.abs(this.mostNegativeCorner[0] - this.mostPositiveCorner[0] * Math.signum(this.mostPositiveCorner[0]) + Math.signum(this.mostPositiveCorner[0])) * Math.abs(this.mostNegativeCorner[1] - this.mostPositiveCorner[1] * Math.signum(this.mostPositiveCorner[1]) + Math.signum(this.mostPositiveCorner[1])) * Math.abs(this.mostNegativeCorner[2] - this.mostPositiveCorner[2] * Math.signum(this.mostPositiveCorner[2]) + Math.signum(this.mostPositiveCorner[2])) + " blocks.");
    }

    public boolean resetSelection() {
        double[] positionOneNew = new double[]{-1.0, -1.0, -1.0};
        double[] positionTwoNew = new double[]{-1.0, -1.0, -1.0};
        this.positionOne = positionOneNew;
        this.positionTwo = positionTwoNew;
        this.mostNegativeCorner = new double[3];
        this.mostPositiveCorner = new double[3];
        return true;
    }

    public BlockIterator getBlocks(World world) {
        double[] pos1 = this.mostNegativeCorner;
        double[] pos2 = this.mostPositiveCorner;
        ArrayList<String> args2 = new ArrayList<String>();
        args2.add(Integer.toString((int)pos1[0]));
        args2.add(Integer.toString((int)pos1[1]));
        args2.add(Integer.toString((int)pos1[2]));
        args2.add(Integer.toString((int)pos2[0]));
        args2.add(Integer.toString((int)pos2[1]));
        args2.add(Integer.toString((int)pos2[2]));
        args2.add("1");
        return IteratorManager.INSTANCE.getIterator("cube").newIterator(args2, world, (CommandSender)Bukkit.getConsoleSender());
    }

    public Player getPlayer(String player) {
        return Bukkit.getServer().getPlayer(UUID.fromString(player));
    }

    public Mode toggleMode(String player) {
        if (this.mode == Mode.SELECTION) {
            this.mode = Mode.MULTI;
            this.getPlayer(player).sendMessage("\u00a7dWand mode is now Multiselect");
        } else {
            this.mode = Mode.SELECTION;
            this.getPlayer(player).sendMessage("\u00a7dWand mode is now Selection");
        }
        return this.mode;
    }

    public boolean isMultiMode() {
        return this.mode == Mode.MULTI;
    }

    public boolean setAnchorPoint(double x, double y, double z, String player) {
        this.anchorPoint = new Point3(x, y, z);
        this.getPlayer(player).sendMessage("\u00a7dAnchor point updated");
        return true;
    }

    public boolean addAdditionalPoint(double x, double y, double z, String player) {
        Point3 point = new Point3(x, y, z);
        this.additionalPoints.add(point);
        this.getPlayer(player).sendMessage("\u00a7dAdditional point added (" + this.additionalPoints.size() + " points)");
        return true;
    }

    public boolean removeAdditionalPoint(String player) {
        this.additionalPoints.remove(this.additionalPoints.size() - 1);
        this.getPlayer(player).sendMessage("\u00a7dAdditional point removed (" + this.additionalPoints.size() + " points)");
        return true;
    }

    public boolean resetMultiSelect(String player) {
        this.anchorPoint = null;
        this.additionalPoints = new ArrayList<Point3>();
        this.getPlayer(player).sendMessage("\u00a7dMultiselection reset");
        return true;
    }

    public Point3 getAnchorPoint() {
        return new Point3(this.anchorPoint);
    }

    public List<Point3> getAdditionalPoints() {
        ArrayList<Point3> points = new ArrayList<Point3>();
        for (Point3 additionalPoint : this.additionalPoints) {
            points.add(new Point3(additionalPoint));
        }
        return points;
    }

    public List<Point3> getAllPoints() {
        ArrayList<Point3> points = new ArrayList<Point3>();
        if (this.anchorPoint != null) {
            points.add(new Point3(this.anchorPoint));
        }
        for (Point3 additionalPoint : this.additionalPoints) {
            points.add(new Point3(additionalPoint));
        }
        return points;
    }

    public boolean isValidMultiselect() {
        return this.anchorPoint != null && this.additionalPoints.size() > 0;
    }

    public static enum Mode {
        SELECTION,
        MULTI;

    }
}

