/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.scripts;

import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.scripts.Craftscript;
import com._14ercooper.worldeditor.undo.UndoElement;
import com._14ercooper.worldeditor.undo.UserUndo;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\bJ*\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00072\u0010\u0010\u0012\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/_14ercooper/worldeditor/scripts/CraftscriptManager;", "", "()V", "currentPlayer", "Lorg/bukkit/command/CommandSender;", "registeredScripts", "", "", "Lcom/_14ercooper/worldeditor/scripts/Craftscript;", "undoElement", "Lcom/_14ercooper/worldeditor/undo/UndoElement;", "usedUndo", "", "registerCraftscript", "", "label", "handler", "runCraftscript", "args", "Ljava/util/LinkedList;", "player", "14erEdit"})
public final class CraftscriptManager {
    private static CommandSender currentPlayer;
    private static UndoElement undoElement;
    private static boolean usedUndo;
    @JvmField
    @NotNull
    public static final Map<String, Craftscript> registeredScripts;
    @NotNull
    public static final CraftscriptManager INSTANCE;

    public final void registerCraftscript(@NotNull String label, @NotNull Craftscript handler) {
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(handler, "handler");
        registeredScripts.put(label, handler);
    }

    public final boolean runCraftscript(@NotNull String label, @Nullable LinkedList<String> args2, @Nullable CommandSender player) {
        Intrinsics.checkNotNullParameter(label, "label");
        Main.Companion.logDebug("Calling Craftsript: " + label);
        try {
            usedUndo = false;
            currentPlayer = player;
            Craftscript craftscript = registeredScripts.get(label);
            Intrinsics.checkNotNull(craftscript);
            craftscript.perform(args2, player, label);
            if (usedUndo) {
                UndoElement undoElement = CraftscriptManager.undoElement;
                Intrinsics.checkNotNull(undoElement);
                UserUndo userUndo = undoElement.getUserUndo();
                UndoElement undoElement2 = CraftscriptManager.undoElement;
                Intrinsics.checkNotNull(undoElement2);
                userUndo.finalizeUndo(undoElement2);
            }
        }
        catch (Exception e) {
            Main.Companion.logError("Error performing CraftScript. Check your syntax?", player, e);
        }
        return true;
    }

    private CraftscriptManager() {
    }

    static {
        CraftscriptManager craftscriptManager;
        INSTANCE = craftscriptManager = new CraftscriptManager();
        registeredScripts = new HashMap();
    }
}

