/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.player;

import com._14ercooper.worldeditor.brush.Brush;
import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.selection.SelectionWand;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010?\u001a\u00020:2\u0006\u0010@\u001a\u00020\u0003J\u001e\u0010A\u001a\u00020\u00172\u0006\u0010B\u001a\u00020\u001c2\u0006\u0010C\u001a\u00020\u001c2\u0006\u0010D\u001a\u00020\u001cJ\u0006\u0010E\u001a\u00020FJ\u0006\u0010G\u001a\u00020FJ\u0016\u0010H\u001a\u00020F2\u0006\u0010@\u001a\u00020\u00032\u0006\u0010I\u001a\u00020:J\u000e\u0010J\u001a\u00020\u00172\u0006\u0010K\u001a\u00020\u0007R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R\u001a\u0010$\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001e\"\u0004\b&\u0010 R\u001a\u0010'\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u001e\"\u0004\b)\u0010 R\u001a\u0010*\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u001e\"\u0004\b,\u0010 R\u001a\u0010-\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u001e\"\u0004\b/\u0010 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u001a\u00102\u001a\u000203X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R&\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020:09X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>\u00a8\u0006L"}, d2={"Lcom/_14ercooper/worldeditor/player/PlayerWrapper;", "", "playerName", "", "(Ljava/lang/String;)V", "brushMask", "", "Lorg/bukkit/Material;", "getBrushMask", "()Ljava/util/Set;", "setBrushMask", "(Ljava/util/Set;)V", "brushes", "", "Lcom/_14ercooper/worldeditor/brush/Brush;", "getBrushes", "()Ljava/util/List;", "setBrushes", "(Ljava/util/List;)V", "globalMask", "getGlobalMask", "setGlobalMask", "isDebug", "", "()Z", "setDebug", "(Z)V", "maxEditX", "", "getMaxEditX", "()J", "setMaxEditX", "(J)V", "maxEditY", "getMaxEditY", "setMaxEditY", "maxEditZ", "getMaxEditZ", "setMaxEditZ", "minEditX", "getMinEditX", "setMinEditX", "minEditY", "getMinEditY", "setMinEditY", "minEditZ", "getMinEditZ", "setMinEditZ", "getPlayerName", "()Ljava/lang/String;", "selectionWand", "Lcom/_14ercooper/worldeditor/selection/SelectionWand;", "getSelectionWand", "()Lcom/_14ercooper/worldeditor/selection/SelectionWand;", "setSelectionWand", "(Lcom/_14ercooper/worldeditor/selection/SelectionWand;)V", "variables", "", "", "getVariables", "()Ljava/util/Map;", "setVariables", "(Ljava/util/Map;)V", "getVariable", "name", "outsideEditRegion", "x", "y", "z", "resetGlobalMask", "", "resetVariables", "setVariable", "value", "shouldEdit", "material", "14erEdit"})
public final class PlayerWrapper {
    @NotNull
    private Set<Material> brushMask;
    private boolean isDebug;
    private long minEditX;
    private long minEditY;
    private long minEditZ;
    private long maxEditX;
    private long maxEditY;
    private long maxEditZ;
    @NotNull
    private List<Brush> brushes;
    @NotNull
    private SelectionWand selectionWand;
    @NotNull
    private List<Material> globalMask;
    @NotNull
    private Map<String, Double> variables;
    @NotNull
    private final String playerName;

    @NotNull
    public final Set<Material> getBrushMask() {
        return this.brushMask;
    }

    public final void setBrushMask(@NotNull Set<Material> set) {
        Intrinsics.checkNotNullParameter(set, "<set-?>");
        this.brushMask = set;
    }

    public final boolean isDebug() {
        return this.isDebug;
    }

    public final void setDebug(boolean bl) {
        this.isDebug = bl;
    }

    public final long getMinEditX() {
        return this.minEditX;
    }

    public final void setMinEditX(long l) {
        this.minEditX = l;
    }

    public final long getMinEditY() {
        return this.minEditY;
    }

    public final void setMinEditY(long l) {
        this.minEditY = l;
    }

    public final long getMinEditZ() {
        return this.minEditZ;
    }

    public final void setMinEditZ(long l) {
        this.minEditZ = l;
    }

    public final long getMaxEditX() {
        return this.maxEditX;
    }

    public final void setMaxEditX(long l) {
        this.maxEditX = l;
    }

    public final long getMaxEditY() {
        return this.maxEditY;
    }

    public final void setMaxEditY(long l) {
        this.maxEditY = l;
    }

    public final long getMaxEditZ() {
        return this.maxEditZ;
    }

    public final void setMaxEditZ(long l) {
        this.maxEditZ = l;
    }

    public final boolean outsideEditRegion(long x, long y, long z) {
        return x <= this.minEditX || y <= this.minEditY || z <= this.minEditZ || x >= this.maxEditX || y >= this.maxEditY || z >= this.maxEditZ;
    }

    @NotNull
    public final List<Brush> getBrushes() {
        return this.brushes;
    }

    public final void setBrushes(@NotNull List<Brush> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.brushes = list;
    }

    @NotNull
    public final SelectionWand getSelectionWand() {
        return this.selectionWand;
    }

    public final void setSelectionWand(@NotNull SelectionWand selectionWand) {
        Intrinsics.checkNotNullParameter(selectionWand, "<set-?>");
        this.selectionWand = selectionWand;
    }

    @NotNull
    public final List<Material> getGlobalMask() {
        return this.globalMask;
    }

    public final void setGlobalMask(@NotNull List<Material> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.globalMask = list;
    }

    public final boolean shouldEdit(@NotNull Material material) {
        Intrinsics.checkNotNullParameter(material, "material");
        return this.globalMask.size() == 0 || this.globalMask.contains(material);
    }

    public final void resetGlobalMask() {
        boolean bl = false;
        this.globalMask = new ArrayList();
    }

    @NotNull
    public final Map<String, Double> getVariables() {
        return this.variables;
    }

    public final void setVariables(@NotNull Map<String, Double> map2) {
        Intrinsics.checkNotNullParameter(map2, "<set-?>");
        this.variables = map2;
    }

    public final void setVariable(@NotNull String name, double value) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.variables.put(name, value);
    }

    public final double getVariable(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return ((Number)this.variables.getOrDefault(name, 0.0)).doubleValue();
    }

    public final void resetVariables() {
        boolean bl = false;
        this.variables = new LinkedHashMap();
    }

    @NotNull
    public final String getPlayerName() {
        return this.playerName;
    }

    public PlayerWrapper(@NotNull String playerName) {
        Intrinsics.checkNotNullParameter(playerName, "playerName");
        this.playerName = playerName;
        boolean bl = false;
        this.brushMask = new LinkedHashSet();
        this.brushMask.add(Material.AIR);
        this.brushMask.add(Material.CAVE_AIR);
        this.brushMask.add(Material.VOID_AIR);
        this.minEditX = Long.MIN_VALUE;
        this.minEditY = -1L;
        this.minEditZ = Long.MIN_VALUE;
        this.maxEditX = Long.MAX_VALUE;
        this.maxEditY = 256L;
        this.maxEditZ = Long.MAX_VALUE;
        if (Main.Companion.getMajorVer() >= 17) {
            Server server = Bukkit.getServer();
            Intrinsics.checkNotNullExpressionValue(server, "Bukkit.getServer()");
            Object e = server.getWorlds().get(0);
            Intrinsics.checkNotNullExpressionValue(e, "Bukkit.getServer().worlds[0]");
            this.minEditY = (long)((World)e).getMinHeight() - 1L;
            Server server2 = Bukkit.getServer();
            Intrinsics.checkNotNullExpressionValue(server2, "Bukkit.getServer()");
            Object e2 = server2.getWorlds().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, "Bukkit.getServer().worlds[0]");
            this.maxEditY = (long)((World)e2).getMaxHeight() + 1L;
        }
        bl = false;
        this.brushes = new ArrayList();
        this.selectionWand = new SelectionWand();
        this.selectionWand.owner = this.playerName;
        bl = false;
        this.globalMask = new ArrayList();
        bl = false;
        this.variables = new LinkedHashMap();
    }
}

