/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.operations.operators.world;

import com._14ercooper.worldeditor.async.AsyncManager;
import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.main.SetBlock;
import com._14ercooper.worldeditor.operations.OperatorState;
import com._14ercooper.worldeditor.operations.Parser;
import com._14ercooper.worldeditor.operations.ParserState;
import com._14ercooper.worldeditor.operations.operators.Node;
import com._14ercooper.worldeditor.operations.operators.query.BlockAtNode;
import com._14ercooper.worldeditor.operations.operators.world.BlockNode;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;

public class SetNode
extends Node {
    public BlockNode arg;

    @Override
    public boolean isNextNodeBlock() {
        return true;
    }

    @Override
    public SetNode newNode(ParserState parserState) {
        SetNode node = new SetNode();
        try {
            parserState.setInSetNode(true);
            node.arg = (BlockNode)Parser.parsePart(parserState);
            parserState.setInSetNode(false);
        }
        catch (Exception e) {
            Main.logError("Error parsing set block node. Please check your syntax.", parserState, e);
            return null;
        }
        if (node.arg == null) {
            Main.logError("Could not create set block node. A block is required, but not provided.", parserState, null);
        }
        return node;
    }

    public SetNode newNode(BlockNode arg) {
        SetNode node = new SetNode();
        node.arg = arg;
        return node;
    }

    @Override
    public boolean performNode(OperatorState state, boolean perform) {
        try {
            this.arg.getBlock(state);
            if (this.arg instanceof BlockAtNode) {
                SetBlock.setMaterial(state.getCurrentBlock().block, Material.matchMaterial((String)state.getOtherValues().get("BlockMaterial")), Bukkit.getServer().createBlockData(state.getOtherValues().get("BlockData")), state.getIgnoringPhysics(), state.getCurrentUndo(), state.getCurrentPlayer());
                String nbt = state.getOtherValues().get("BlockNbt");
                if (nbt.length() > 2) {
                    String command2 = "data merge block " + state.getCurrentBlock().block.getX() + " " + state.getCurrentBlock().block.getY() + " " + state.getCurrentBlock().block.getZ() + " " + nbt;
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), command2);
                }
                return true;
            }
            Material storedMaterial = state.getCurrentBlock().block.getType();
            String storedData = state.getCurrentBlock().block.getBlockData().getAsString();
            Object setMaterial = state.getOtherValues().get("BlockMaterial");
            String setData = state.getOtherValues().get("BlockData");
            if (((String)setMaterial).equalsIgnoreCase("same")) {
                return true;
            }
            if (((String)setMaterial).equalsIgnoreCase("dataonly")) {
                BlockState oldBS = state.getCurrentBlock().block.getState();
                HashMap<String, String> oldData = new HashMap<String, String>();
                if (storedData.split("\\[").length < 2) {
                    return true;
                }
                for (String s : storedData.split("\\[")[1].replaceAll("]", "").split(",")) {
                    oldData.put(s.split("=")[0], s.split("=")[1]);
                }
                for (String s : setData.split("\\[")[0].replaceAll("]", "").split(",")) {
                    oldData.remove(s.split("=")[0]);
                    oldData.put(s.split("=")[0], s.split("=")[1]);
                }
                StringBuilder newData = new StringBuilder(storedMaterial.toString().toLowerCase() + "[");
                for (Map.Entry e : oldData.entrySet()) {
                    newData.append((String)e.getKey()).append("=").append((String)e.getValue()).append(",");
                }
                newData = new StringBuilder(newData.substring(0, newData.length() - 1));
                newData.append("]");
                SetBlock.setMaterial(state.getCurrentBlock().block, state.getCurrentBlock().block.getType(), Bukkit.getServer().createBlockData(newData.toString()), state.getIgnoringPhysics(), state.getCurrentUndo(), state.getCurrentPlayer());
                state.getCurrentUndo().addBlock(oldBS, state.getCurrentBlock().block.getState());
                return storedMaterial == Material.matchMaterial((String)setMaterial) && !storedData.equalsIgnoreCase(setData);
            }
            if (((String)setMaterial).equalsIgnoreCase("nbtonly")) {
                String command3 = "data merge block " + state.getCurrentBlock().block.getX() + " " + state.getCurrentBlock().block.getY() + " " + state.getCurrentBlock().block.getZ();
                command3 = command3 + " " + state.getOtherValues().get("BlockNbt");
                Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), command3);
                return true;
            }
            if (setData == null) {
                BlockData data = null;
                try {
                    if (!((String)setMaterial).contains("minecraft:")) {
                        setMaterial = "minecraft:" + (String)setMaterial;
                    }
                    String newData = (String)setMaterial + "[" + storedData.split("\\[")[1];
                    data = Bukkit.getServer().createBlockData(newData);
                    state.getCurrentBlock().block.setBlockData(data, state.getIgnoringPhysics());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SetBlock.setMaterial(state.getCurrentBlock().block, Material.matchMaterial((String)setMaterial), data, state.getIgnoringPhysics(), state.getCurrentUndo(), state.getCurrentPlayer());
                return storedMaterial == Material.matchMaterial((String)setMaterial);
            }
            SetBlock.setMaterial(state.getCurrentBlock().block, Material.matchMaterial((String)setMaterial), Bukkit.getServer().createBlockData(setData), state.getIgnoringPhysics(), state.getCurrentUndo(), state.getCurrentPlayer());
            return storedMaterial == Material.matchMaterial((String)setMaterial) && !storedData.equalsIgnoreCase(setData);
        }
        catch (Exception e) {
            e.printStackTrace();
            Main.logError("Error performing block set node, async queue has been dropped. Please check your syntax.", state.getCurrentPlayer(), e);
            AsyncManager.dropAsync();
            return false;
        }
    }

    @Override
    public int getArgCount() {
        return 1;
    }
}

