/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.operations.operators.world;

import com._14ercooper.worldeditor.blockiterator.BlockWrapper;
import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.operations.OperatorState;
import com._14ercooper.worldeditor.operations.Parser;
import com._14ercooper.worldeditor.operations.ParserState;
import com._14ercooper.worldeditor.operations.operators.Node;
import com._14ercooper.worldeditor.operations.operators.world.BlockNode;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockState;

public class SchemBlockNode
extends BlockNode {
    Node arg;
    boolean isInSet;

    @Override
    public BlockNode newNode(ParserState parserState) {
        SchemBlockNode node = new SchemBlockNode();
        node.isInSet = parserState.getInSetNode();
        if (!node.isInSet) {
            Main.logDebug("SchemBlockNode: Processing subnode");
            node.arg = Parser.parsePart(parserState);
        }
        return node;
    }

    @Override
    public BlockNode newNode(String text, ParserState parserState) {
        Main.logError("Schematic block node in invalid state", parserState, null);
        return null;
    }

    @Override
    public boolean getBlock(OperatorState state) {
        state.getOtherValues().put("BlockMaterial", state.getCurrentBlock().otherArgs.get(0));
        state.getOtherValues().put("BlockData", state.getCurrentBlock().otherArgs.get(1));
        state.getOtherValues().put("BlockNbt", state.getCurrentBlock().otherArgs.get(2));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean performNode(OperatorState state, boolean perform) {
        if (!this.isInSet) {
            ArrayList<String> stateArgs = new ArrayList<String>(state.getCurrentBlock().otherArgs);
            BlockState stateBlock = state.getCurrentWorld().getBlockAt(14, 0, 14).getState();
            BlockWrapper currBlock = state.getCurrentBlock();
            boolean retVal = false;
            try {
                state.setCurrentBlock(state.getCurrentWorld().getBlockAt(14, 0, 14));
                state.getCurrentBlock().otherArgs.addAll(stateArgs);
                state.getCurrentBlock().block.setType(Material.matchMaterial((String)state.getCurrentBlock().otherArgs.get(0)));
                state.getCurrentBlock().block.setBlockData(Bukkit.getServer().createBlockData(state.getCurrentBlock().otherArgs.get(1)));
                retVal = this.arg.performNode(state, true);
            }
            catch (Exception e) {
                Main.logError("Could not perform schem block node", state.getCurrentPlayer(), e);
            }
            finally {
                state.getCurrentBlock().block.setType(stateBlock.getType());
                state.getCurrentBlock().block.setBlockData(stateBlock.getBlockData());
                state.setCurrentBlock(currBlock);
                state.getCurrentBlock().otherArgs.addAll(stateArgs);
            }
            return retVal;
        }
        return true;
    }

    @Override
    public int getArgCount() {
        return 1;
    }
}

