/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.operations.operators.world;

import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.main.NBTExtractor;
import com._14ercooper.worldeditor.operations.OperatorState;
import com._14ercooper.worldeditor.operations.Parser;
import com._14ercooper.worldeditor.operations.ParserState;
import com._14ercooper.worldeditor.operations.operators.Node;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class BlockNode
extends Node {
    public List<BlockInstance> blockList;
    public List<String> textMasks;

    @Override
    public BlockNode newNode(ParserState parserState) {
        BlockNode node = new BlockNode();
        Object[] data = Parser.parseStringNode(parserState).getText().split(";");
        try {
            if (this.loadBlockList(node, (String[])data, parserState)) {
                return null;
            }
        }
        catch (Exception e) {
            Main.logError("Could not parse block node. Block name required, but not found: " + Arrays.toString(data), parserState.getCurrentPlayer(), e);
            return null;
        }
        return node;
    }

    private boolean loadBlockList(BlockNode node, String[] data, ParserState parserState) {
        node.blockList = new LinkedList<BlockInstance>();
        node.textMasks = new LinkedList<String>();
        for (String s : data) {
            if (s.contains("#")) {
                Main.logDebug("Created text mask");
                node.textMasks.add(s.replaceAll("#", ""));
                continue;
            }
            Main.logDebug("Created block instance");
            if (s.isBlank()) continue;
            node.blockList.add(new BlockInstance(s, parserState));
        }
        if (node.blockList.isEmpty() && node.textMasks.isEmpty()) {
            Main.logError("Error creating block node. No blocks were provided.", parserState.getCurrentPlayer(), null);
            return true;
        }
        return false;
    }

    public BlockNode newNode(String input, ParserState parserState) {
        BlockNode node = new BlockNode();
        try {
            String[] data = input.split(";");
            if (this.loadBlockList(node, data, parserState)) {
                return null;
            }
        }
        catch (Exception e) {
            Main.logError("Could not parse block node from input. Block name required, but not found: " + input, parserState.getCurrentPlayer(), e);
            return null;
        }
        return node;
    }

    public boolean getBlock(OperatorState state) {
        try {
            BlockInstance nextBlock = new BlockInstance().GetRandom(this.blockList);
            state.getOtherValues().put("BlockMaterial", nextBlock.mat);
            state.getOtherValues().put("BlockData", nextBlock.data);
            state.getOtherValues().put("BlockNbt", nextBlock.nbt);
            return true;
        }
        catch (Exception e) {
            Main.logError("Error performing block node. Does it contain blocks?", state.getCurrentPlayer(), e);
            return false;
        }
    }

    @Override
    public boolean performNode(OperatorState state, boolean perform) {
        try {
            return new BlockInstance().Contains(this.blockList, this.textMasks, state.getCurrentBlock().block);
        }
        catch (Exception e) {
            Main.logError("Error performing block node. Does it contain blocks?", state.getCurrentPlayer(), e);
            return false;
        }
    }

    @Override
    public int getArgCount() {
        return 1;
    }

    public static boolean blockDataStringsContained(String first2, String second) {
        String[] firstContents;
        String firstString = first2.replaceAll("[\\[\\]]", "").toLowerCase();
        String secondString = second.toLowerCase();
        for (String s : firstContents = firstString.split(",")) {
            if (secondString.contains(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean blockDataStringsMatch(String first2, String second) {
        String[] secondContents;
        String firstString = first2.split("\\[]")[first2.split("\\[]").length - 1].replaceAll("[\\[\\]]", "").toLowerCase();
        String secondString = second.split("\\[]")[second.split("\\[]").length - 1].replaceAll("[\\[\\]]", "").toLowerCase();
        String[] firstContents = firstString.split(",");
        if (firstContents.length != (secondContents = secondString.split(",")).length) {
            return false;
        }
        for (String s : firstContents) {
            if (secondString.contains(s)) continue;
            return false;
        }
        return true;
    }

    public static class BlockInstance {
        public String mat;
        public String data;
        public String nbt = "";
        public int weight;

        BlockInstance(String input, ParserState parserState) {
            if (input.toCharArray()[0] == '[') {
                Main.logDebug("Data only node");
                this.mat = "dataonly";
                this.data = input.replaceAll("[\\[\\]]", "");
                this.weight = 1;
            } else if (input.toCharArray()[0] == '{') {
                Main.logDebug("NBT node");
                this.mat = "nbtonly";
                this.data = null;
                StringBuilder inputBuilder = new StringBuilder(input);
                while (inputBuilder.charAt(inputBuilder.length() - 1) != '}') {
                    inputBuilder.append(" ").append(Parser.parseStringNode(parserState).getText());
                }
                input = inputBuilder.toString();
                this.nbt = input.replaceAll("[{}]", "");
                this.weight = 1;
            } else if (input.contains("%")) {
                if (input.contains("[")) {
                    this.mat = input.split("%")[1].split("\\[")[0];
                    this.data = input.split("%")[1];
                } else {
                    this.mat = input.split("%")[1];
                    this.data = null;
                }
                this.weight = Integer.parseInt(input.split("%")[0]);
            } else {
                if (input.contains("[")) {
                    this.mat = input.split("\\[")[0];
                    this.data = input;
                } else {
                    this.mat = input;
                    this.data = null;
                }
                this.weight = 1;
            }
        }

        BlockInstance() {
        }

        boolean Contains(List<BlockInstance> list, List<String> masks, Block b) {
            Material testMat = b.getType();
            if (!list.isEmpty()) {
                for (BlockInstance bi : list) {
                    NBTExtractor nbt;
                    try {
                        if (Material.matchMaterial((String)bi.mat) == testMat) {
                            if (bi.data != null) {
                                return BlockNode.blockDataStringsContained(bi.data.split("\\[")[1], b.getBlockData().getAsString());
                            }
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (bi.mat.equalsIgnoreCase("dataonly") && BlockNode.blockDataStringsContained(bi.data, b.getBlockData().getAsString())) {
                        return true;
                    }
                    if (!bi.mat.equalsIgnoreCase("nbtonly") || !(nbt = new NBTExtractor()).getNBT(b).contains(bi.nbt.replaceAll("[{}]", ""))) continue;
                    return true;
                }
            }
            if (!masks.isEmpty()) {
                String testString = b.getType().toString().toLowerCase();
                for (String mS : masks) {
                    if (!testString.contains(mS)) continue;
                    return true;
                }
            }
            return false;
        }

        BlockInstance GetRandom(List<BlockInstance> list) {
            int totalWeight = 0;
            for (BlockInstance bi : list) {
                totalWeight += bi.weight;
            }
            int randNum = Main.getRand().nextInt(totalWeight + 1);
            for (BlockInstance bi : list) {
                if ((randNum -= bi.weight) > 0) continue;
                return bi;
            }
            return null;
        }
    }
}

