/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.operations.operators.variable;

import com._14ercooper.worldeditor.operations.OperatorState;
import com._14ercooper.worldeditor.operations.Parser;
import com._14ercooper.worldeditor.operations.ParserState;
import com._14ercooper.worldeditor.operations.operators.Node;
import com._14ercooper.worldeditor.operations.operators.core.NumberNode;
import com._14ercooper.worldeditor.operations.operators.core.StringNode;
import com._14ercooper.worldeditor.player.PlayerManager;
import com._14ercooper.worldeditor.player.PlayerWrapper;

public class SetPlayerVariableNode
extends NumberNode {
    StringNode name;
    Node child;

    @Override
    public SetPlayerVariableNode newNode(ParserState parserState) {
        SetPlayerVariableNode node = new SetPlayerVariableNode();
        node.name = Parser.parseStringNode(parserState);
        node.child = Parser.parsePart(parserState);
        return node;
    }

    @Override
    public boolean performNode(OperatorState state, boolean perform) {
        return !(Math.abs(this.getValue(state)) < 0.01);
    }

    @Override
    public double getValue(OperatorState state) {
        PlayerWrapper playerWrapper = PlayerManager.getPlayerWrapper(state.getCurrentPlayer());
        if (this.child instanceof NumberNode) {
            double val = ((NumberNode)this.child).getValue(state);
            playerWrapper.setVariable(this.name.getText(), val);
            return val;
        }
        boolean val = this.child.performNode(state);
        double newVal = val ? 1.0 : 0.0;
        playerWrapper.setVariable(this.name.getText(), newVal);
        return newVal;
    }

    @Override
    public int getInt(OperatorState state) {
        return (int)this.getValue(state);
    }

    @Override
    public int getArgCount() {
        return 2;
    }
}

