/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.operations.operators.query;

import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.operations.OperatorState;
import com._14ercooper.worldeditor.operations.Parser;
import com._14ercooper.worldeditor.operations.ParserState;
import com._14ercooper.worldeditor.operations.operators.Node;
import com._14ercooper.worldeditor.operations.operators.function.RangeNode;
import org.bukkit.block.Block;

public class BlocksAdjacentDiagonalNode
extends Node {
    public Node arg1;
    public RangeNode arg2;

    @Override
    public boolean isNextNodeRange() {
        return true;
    }

    @Override
    public BlocksAdjacentDiagonalNode newNode(ParserState parserState) {
        BlocksAdjacentDiagonalNode node = new BlocksAdjacentDiagonalNode();
        try {
            node.arg2 = Parser.parseRangeNode(parserState);
            node.arg1 = Parser.parsePart(parserState);
        }
        catch (Exception e) {
            Main.logError("Error creating blocks adjacent node. Please check your syntax.", parserState, e);
            return null;
        }
        if (node.arg2 == null) {
            Main.logError("Could not parse blocks adjacent node. Two arguments are required, but not given.", parserState, null);
        }
        return node;
    }

    @Override
    public boolean performNode(OperatorState state, boolean perform) {
        Main.logDebug("Performing faces exposed node");
        int numAdjacentBlocks = 0;
        Block curBlock = state.getCurrentWorld().getBlockAt(state.getCurrentBlock().block.getLocation());
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 || y == 0 || z == 0) continue;
                    Block blockAdj = curBlock.getRelative(x, y, z);
                    state.setCurrentBlock(blockAdj);
                    if (!this.arg1.performNode(state, true)) continue;
                    ++numAdjacentBlocks;
                }
            }
        }
        state.setCurrentBlock(curBlock);
        return (double)numAdjacentBlocks >= this.arg2.getMin(state) - 0.1 && (double)numAdjacentBlocks <= this.arg2.getMax(state) + 0.1;
    }

    @Override
    public int getArgCount() {
        return 2;
    }
}

