/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.operations.operators.query;

import com._14ercooper.worldeditor.blockiterator.BlockWrapper;
import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.main.NBTExtractor;
import com._14ercooper.worldeditor.operations.OperatorState;
import com._14ercooper.worldeditor.operations.Parser;
import com._14ercooper.worldeditor.operations.ParserState;
import com._14ercooper.worldeditor.operations.operators.Node;
import com._14ercooper.worldeditor.operations.operators.core.NumberNode;
import com._14ercooper.worldeditor.operations.operators.world.BlockNode;

public class BlockAtNode
extends BlockNode {
    NumberNode x;
    NumberNode y;
    NumberNode z;
    boolean xA = false;
    boolean yA = false;
    boolean zA = false;
    Node node;
    private static final NBTExtractor nbt = new NBTExtractor();
    int xV;
    int yV;
    int zV;

    @Override
    public BlockAtNode newNode(ParserState parserState) {
        BlockAtNode baNode = new BlockAtNode();
        try {
            baNode.x = Parser.parseNumberNode(parserState);
            baNode.y = Parser.parseNumberNode(parserState);
            baNode.z = Parser.parseNumberNode(parserState);
            baNode.xA = baNode.x.isAbsolute;
            baNode.yA = baNode.y.isAbsolute;
            baNode.zA = baNode.z.isAbsolute;
            try {
                baNode.node = Parser.parsePart(parserState);
            }
            catch (Exception e) {
                Main.logDebug("Block at created with type blocknode");
            }
        }
        catch (Exception e) {
            Main.logError("Error creating block at node. Please check your syntax.", parserState, e);
            return null;
        }
        if (baNode.z == null) {
            Main.logError("Could not parse block at node. Three numbers and optionally an operation are required, but not given.", parserState, null);
        }
        return baNode;
    }

    @Override
    public boolean performNode(OperatorState state, boolean perform) {
        try {
            BlockWrapper currBlock = state.getCurrentBlock();
            this.xA = this.x.isAbsolute;
            this.yA = this.y.isAbsolute;
            this.zA = this.z.isAbsolute;
            state.setCurrentBlock(state.getCurrentWorld().getBlockAt(this.x.getInt(state) + (this.xA ? 0 : currBlock.block.getX()), this.y.getInt(state) + (this.yA ? 0 : currBlock.block.getY()), this.z.getInt(state) + (this.zA ? 0 : currBlock.block.getZ())));
            boolean matches = this.node.performNode(state, true);
            state.setCurrentBlock(currBlock);
            return matches;
        }
        catch (Exception e) {
            Main.logError("Error performing block at node. Please check your syntax.", state.getCurrentPlayer(), e);
            return false;
        }
    }

    @Override
    public boolean getBlock(OperatorState state) {
        this.xV = this.x.getInt(state);
        this.yV = this.y.getInt(state);
        this.zV = this.z.getInt(state);
        this.xA = this.x.isAbsolute;
        this.yA = this.y.isAbsolute;
        this.zA = this.z.isAbsolute;
        state.getOtherValues().put("BlockMaterial", state.getCurrentWorld().getBlockAt(this.xV + (this.xA ? 0 : state.getCurrentBlock().block.getX()), this.yV + (this.yA ? 0 : state.getCurrentBlock().block.getY()), this.zV + (this.zA ? 0 : state.getCurrentBlock().block.getZ())).toString());
        state.getOtherValues().put("BlockData", state.getCurrentWorld().getBlockAt(this.xV + (this.xA ? 0 : state.getCurrentBlock().block.getX()), this.yV + (this.yA ? 0 : state.getCurrentBlock().block.getY()), this.zV + (this.zA ? 0 : state.getCurrentBlock().block.getZ())).toString());
        state.getOtherValues().put("BlockNbt", nbt.getNBT(state.getCurrentWorld().getBlockAt(this.xV + (this.xA ? 0 : state.getCurrentBlock().block.getX()), this.yV + (this.yA ? 0 : state.getCurrentBlock().block.getY()), this.zV + (this.zA ? 0 : state.getCurrentBlock().block.getZ()))));
        return true;
    }

    @Override
    public int getArgCount() {
        return 4;
    }
}

