/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.operations.operators.logical;

import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.operations.OperatorState;
import com._14ercooper.worldeditor.operations.Parser;
import com._14ercooper.worldeditor.operations.ParserState;
import com._14ercooper.worldeditor.operations.operators.Node;

public class XorNode
extends Node {
    public Node arg1;
    public Node arg2;

    @Override
    public XorNode newNode(ParserState parserState) {
        XorNode node = new XorNode();
        try {
            node.arg1 = Parser.parsePart(parserState);
            node.arg2 = Parser.parsePart(parserState);
        }
        catch (Exception e) {
            Main.logError("Error creating xor node. Please check your syntax.", parserState, e);
            return null;
        }
        if (node.arg2 == null) {
            Main.logError("Error creating xor node. Requires 2 arguments, but these were not provided.", parserState, null);
        }
        return node;
    }

    @Override
    public boolean performNode(OperatorState state, boolean perform) {
        try {
            boolean x = this.arg1.performNode(state, true);
            boolean y = this.arg2.performNode(state, true);
            return !(!x && !y || x && y);
        }
        catch (Exception e) {
            Main.logError("Error performing xor node. Please check your syntax.", state.getCurrentPlayer(), e);
            return false;
        }
    }

    @Override
    public int getArgCount() {
        return 2;
    }
}

