/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.operations.operators.logical;

import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.operations.OperatorState;
import com._14ercooper.worldeditor.operations.Parser;
import com._14ercooper.worldeditor.operations.ParserState;
import com._14ercooper.worldeditor.operations.operators.Node;
import com._14ercooper.worldeditor.operations.operators.logical.ElseNode;

public class IfNode
extends Node {
    public Node arg1;
    public Node arg2;
    public Node arg3;

    @Override
    public IfNode newNode(ParserState parserState) {
        IfNode node = new IfNode();
        try {
            node.arg1 = Parser.parsePart(parserState);
            node.arg2 = Parser.parsePart(parserState);
            int iter = parserState.getIndex();
            node.arg3 = Parser.parsePart(parserState);
            if (!(node.arg3 instanceof ElseNode)) {
                Main.logDebug("Did not find an instance of an else node.");
                node.arg3 = null;
                parserState.setIndex(iter);
            }
        }
        catch (Exception e) {
            Main.logError("Error creating if node. Please check your syntax.", parserState, e);
            return null;
        }
        if (node.arg2 == null) {
            Main.logError("Error creating if node. At least a condition and on-true operator are required, but are not provided.", parserState, null);
        }
        return node;
    }

    public IfNode newNode(Node cond, Node onTrue, Node onFalse) {
        IfNode node = new IfNode();
        node.arg1 = cond;
        node.arg2 = onTrue;
        node.arg3 = onFalse;
        return node;
    }

    @Override
    public boolean performNode(OperatorState state, boolean perform) {
        try {
            boolean isTrue = this.arg1.performNode(state, true);
            if (isTrue) {
                this.arg2.performNode(state, true);
                return true;
            }
            if (this.arg3 == null) {
                return false;
            }
            this.arg3.performNode(state, true);
            return false;
        }
        catch (Exception e) {
            Main.logError("Error performing if node. Please check your syntax.", state.getCurrentPlayer(), e);
            return false;
        }
    }

    @Override
    public int getArgCount() {
        return 3;
    }
}

