/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.operations.operators.function;

import com._14ercooper.worldeditor.main.FastNoise;
import com._14ercooper.worldeditor.main.SimplexNoise;
import com._14ercooper.worldeditor.operations.DummyState;
import com._14ercooper.worldeditor.operations.OperatorState;
import com._14ercooper.worldeditor.operations.Parser;
import com._14ercooper.worldeditor.operations.ParserState;
import com._14ercooper.worldeditor.operations.operators.Node;
import com._14ercooper.worldeditor.operations.operators.core.NumberNode;
import com._14ercooper.worldeditor.operations.operators.core.StringNode;

public class NoiseNode
extends Node {
    public StringNode noiseType;
    public NumberNode dimensions;
    public NumberNode cutoff;
    public NumberNode frequency;
    public NumberNode octaves;
    public NumberNode lacunarity;
    public NumberNode gain;
    public NumberNode type;
    public StringNode distance;
    private FastNoise noise;

    @Override
    public NoiseNode newNode(ParserState parserState) {
        NoiseNode node = new NoiseNode();
        node.noiseType = Parser.parseStringNode(parserState);
        node.dimensions = Parser.parseNumberNode(parserState);
        node.cutoff = Parser.parseNumberNode(parserState);
        node.frequency = Parser.parseNumberNode(parserState);
        node.noise = new FastNoise();
        node.noise.SetSeed(SimplexNoise.noiseSeed);
        node.noise.SetFrequency((float)(node.frequency.getValue(new DummyState(parserState.getCurrentPlayer())) / 40.0));
        if (node.noiseType.getText().contains("Fractal") || node.noiseType.getText().contains("fractal")) {
            node.octaves = Parser.parseNumberNode(parserState);
            node.lacunarity = Parser.parseNumberNode(parserState);
            node.gain = Parser.parseNumberNode(parserState);
            node.type = Parser.parseNumberNode(parserState);
            node.noise.SetFractalOctaves((int)node.octaves.getValue(new DummyState(parserState.getCurrentPlayer())));
            node.noise.SetFractalLacunarity((float)node.lacunarity.getValue(new DummyState(parserState.getCurrentPlayer())));
            node.noise.SetFractalGain((float)node.gain.getValue(new DummyState(parserState.getCurrentPlayer())));
            int fractalType = (int)node.type.getValue(new DummyState(parserState.getCurrentPlayer()));
            if (fractalType == 1) {
                node.noise.SetFractalType(FastNoise.FractalType.FBM);
            } else if (fractalType == 2) {
                node.noise.SetFractalType(FastNoise.FractalType.Billow);
            } else if (fractalType == 3) {
                node.noise.SetFractalType(FastNoise.FractalType.RigidMulti);
            }
        }
        if (node.noiseType.getText().equalsIgnoreCase("cellular")) {
            node.distance = Parser.parseStringNode(parserState);
            if (node.distance.getText().equalsIgnoreCase("euclid")) {
                node.noise.SetCellularDistanceFunction(FastNoise.CellularDistanceFunction.Euclidean);
            } else if (node.distance.getText().equalsIgnoreCase("manhattan")) {
                node.noise.SetCellularDistanceFunction(FastNoise.CellularDistanceFunction.Manhattan);
            } else if (node.distance.getText().equalsIgnoreCase("natural")) {
                node.noise.SetCellularDistanceFunction(FastNoise.CellularDistanceFunction.Natural);
            }
        }
        return node;
    }

    @Override
    public boolean performNode(OperatorState state, boolean perform) {
        return (double)NoiseNode.scaleTo255(this.getNum(state)) <= this.cutoff.getValue(state);
    }

    public float getNum(OperatorState state) {
        int x = state.getCurrentBlock().block.getX();
        int y = state.getCurrentBlock().block.getY();
        int z = state.getCurrentBlock().block.getZ();
        int w = (int)((double)(x + y + z) / 0.33333333);
        int dim = (int)this.dimensions.getValue(state);
        if (this.noiseType.getText().equalsIgnoreCase("value")) {
            if (dim == 2) {
                return this.noise.GetValue(x, z);
            }
            if (dim == 3) {
                return this.noise.GetValue(x, z, y);
            }
            return 0.0f;
        }
        if (this.noiseType.getText().equalsIgnoreCase("valuefractal")) {
            if (dim == 2) {
                return this.noise.GetValueFractal(x, z);
            }
            if (dim == 3) {
                return this.noise.GetValueFractal(x, z, y);
            }
            return 0.0f;
        }
        if (this.noiseType.getText().equalsIgnoreCase("perlin")) {
            if (dim == 2) {
                return this.noise.GetPerlin(x, z);
            }
            if (dim == 3) {
                return this.noise.GetPerlin(x, z, y);
            }
            return 0.0f;
        }
        if (this.noiseType.getText().equalsIgnoreCase("perlinfractal")) {
            if (dim == 2) {
                return this.noise.GetPerlinFractal(x, z);
            }
            if (dim == 3) {
                return this.noise.GetPerlinFractal(x, z, y);
            }
            return 0.0f;
        }
        if (this.noiseType.getText().equalsIgnoreCase("simplex")) {
            if (dim == 2) {
                return this.noise.GetSimplex(x, z);
            }
            if (dim == 3) {
                return this.noise.GetSimplex(x, z, y);
            }
            if (dim == 4) {
                return this.noise.GetSimplex(x, z, y, w);
            }
            return 0.0f;
        }
        if (this.noiseType.getText().equalsIgnoreCase("simplexfractal")) {
            if (dim == 2) {
                return this.noise.GetSimplexFractal(x, z);
            }
            if (dim == 3) {
                return this.noise.GetSimplexFractal(x, z, y);
            }
            return 0.0f;
        }
        if (this.noiseType.getText().equalsIgnoreCase("cellular")) {
            if (dim == 2) {
                return this.noise.GetCellular(x, z);
            }
            if (dim == 3) {
                return this.noise.GetCellular(x, z, y);
            }
            return 0.0f;
        }
        if (this.noiseType.getText().equalsIgnoreCase("whitenoise") || this.noiseType.getText().equalsIgnoreCase("whitenoiseint")) {
            if (dim == 2) {
                return this.noise.GetWhiteNoise(x, z);
            }
            if (dim == 3) {
                return this.noise.GetWhiteNoise(x, z, y);
            }
            if (dim == 4) {
                return this.noise.GetWhiteNoise(x, z, y, w);
            }
            return 0.0f;
        }
        if (this.noiseType.getText().equalsIgnoreCase("cubic")) {
            if (dim == 2) {
                return this.noise.GetCubic(x, z);
            }
            if (dim == 3) {
                return this.noise.GetCubic(x, z, y);
            }
            return 0.0f;
        }
        if (this.noiseType.getText().equalsIgnoreCase("cubicfractal")) {
            if (dim == 2) {
                return this.noise.GetCubicFractal(x, z);
            }
            if (dim == 3) {
                return this.noise.GetCubicFractal(x, z, y);
            }
            return 0.0f;
        }
        return 0.0f;
    }

    @Override
    public int getArgCount() {
        return 3;
    }

    public static float scaleTo255(double val) {
        val += 1.0;
        return (float)(val *= 127.5);
    }
}

