/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.operations.operators.function;

import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.operations.DummyState;
import com._14ercooper.worldeditor.operations.OperatorState;
import com._14ercooper.worldeditor.operations.Parser;
import com._14ercooper.worldeditor.operations.ParserState;
import com._14ercooper.worldeditor.operations.operators.Node;
import com._14ercooper.worldeditor.operations.operators.core.NumberNode;
import com._14ercooper.worldeditor.operations.operators.function.NoiseNode;
import java.util.ArrayList;
import java.util.List;

public class MultiNoiseNode
extends Node {
    NumberNode noiseCount;
    NoiseNode noiseFunction;
    final List<Node> noises = new ArrayList<Node>();

    @Override
    public MultiNoiseNode newNode(ParserState parserState) {
        try {
            MultiNoiseNode node = new MultiNoiseNode();
            try {
                node.noiseCount = Parser.parseNumberNode(parserState);
            }
            catch (Exception e) {
                Main.logError("Multinoise node expected first argument to be a number, but it was not.", parserState, e);
                return null;
            }
            try {
                node.noiseFunction = (NoiseNode)Parser.parsePart(parserState);
            }
            catch (Exception e) {
                Main.logError("Multinoise node requires a noise node, but none was found.", parserState, e);
                return null;
            }
            try {
                for (int i = 0; i < node.noiseCount.getMaxInt(new DummyState(parserState.getCurrentPlayer())); ++i) {
                    node.noises.add(Parser.parsePart(parserState));
                }
            }
            catch (Exception e) {
                Main.logError("Error parsing nodes for multinoise, likely ran out of nodes.", parserState, e);
                return null;
            }
            return node;
        }
        catch (Exception e) {
            Main.logError("Could not create multinoise node. Are you missing an argument?", parserState, e);
            return null;
        }
    }

    @Override
    public boolean performNode(OperatorState state, boolean perform) {
        float cInv;
        float nColl;
        int nodeToRun;
        int c = this.noiseCount.getInt(state) + 1;
        float n = NoiseNode.scaleTo255(this.noiseFunction.getNum(state));
        if ((nodeToRun = (int)(nColl = (n *= this.sigmoid(n / 127.5f)) * (cInv = (float)c / 255.0f))) >= this.noises.size()) {
            nodeToRun = this.noises.size() - 1;
        }
        return this.noises.get(nodeToRun).performNode(state, true);
    }

    private float sigmoid(float val) {
        return (float)(1.0 / (1.0 + Math.exp(-2.0f * (val - 1.0f))));
    }

    @Override
    public int getArgCount() {
        return 3;
    }
}

