/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.operations.operators.function;

import com._14ercooper.worldeditor.functions.Function;
import com._14ercooper.worldeditor.operations.DummyState;
import com._14ercooper.worldeditor.operations.OperatorState;
import com._14ercooper.worldeditor.operations.Parser;
import com._14ercooper.worldeditor.operations.ParserState;
import com._14ercooper.worldeditor.operations.operators.core.NumberNode;
import java.util.ArrayList;
import java.util.List;

public class FunctionNode
extends NumberNode {
    String filename;
    final List<String> args = new ArrayList<String>();

    @Override
    public FunctionNode newNode(ParserState parserState) {
        int argNum;
        FunctionNode node = new FunctionNode();
        node.filename = Parser.parseStringNode(parserState).getText();
        try {
            argNum = (int)Parser.parseNumberNode(parserState).getValue(new DummyState(parserState.getCurrentPlayer()));
        }
        catch (NullPointerException e) {
            parserState.setIndex(parserState.getIndex() - 1);
            argNum = (int)Parser.parseNumberNode((ParserState)parserState).arg;
        }
        for (int i = 0; i < argNum; ++i) {
            node.args.add(Parser.parseStringNode(parserState).getText());
        }
        return node;
    }

    @Override
    public boolean performNode(OperatorState state, boolean perform) {
        Function fx = new Function(this.filename, this.args, state.getCurrentPlayer(), true, state);
        return Math.abs(fx.run()) > 0.001;
    }

    @Override
    public int getArgCount() {
        return 2;
    }

    @Override
    public double getValue(OperatorState state) {
        return this.getValue(state, 0.0);
    }

    @Override
    public double getValue(OperatorState state, double center) {
        Function fx = new Function(this.filename, this.args, state.getCurrentPlayer(), true, state);
        return fx.run();
    }

    @Override
    public int getInt(OperatorState state) {
        return this.getInt(state, 0);
    }

    @Override
    public int getInt(OperatorState state, int center) {
        Function fx = new Function(this.filename, this.args, state.getCurrentPlayer(), true, state);
        return (int)fx.run();
    }
}

