/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.operations.operators.fun;

import com._14ercooper.worldeditor.blockiterator.BlockWrapper;
import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.operations.OperatorState;
import com._14ercooper.worldeditor.operations.Parser;
import com._14ercooper.worldeditor.operations.ParserState;
import com._14ercooper.worldeditor.operations.operators.Node;
import com._14ercooper.worldeditor.operations.operators.function.RangeNode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class SmallRuinNode
extends Node {
    Node block;
    RangeNode stackSize;
    RangeNode xMax;
    RangeNode zMax;

    @Override
    public SmallRuinNode newNode(ParserState parserState) {
        SmallRuinNode node = new SmallRuinNode();
        node.xMax = Parser.parseRangeNode(parserState);
        node.zMax = Parser.parseRangeNode(parserState);
        node.stackSize = Parser.parseRangeNode(parserState);
        node.block = Parser.parsePart(parserState);
        return node;
    }

    @Override
    public boolean performNode(OperatorState state, boolean perform) {
        int xSize = Main.randRange((int)this.xMax.getMin(state), (int)this.xMax.getMax(state));
        int zSize = Main.randRange((int)this.zMax.getMin(state), (int)this.zMax.getMax(state));
        int stackCount = Main.randRange((int)this.stackSize.getMin(state), (int)this.stackSize.getMax(state));
        BlockWrapper savedBlock = state.getCurrentBlock();
        for (int ruinNum = 0; ruinNum < stackCount; ++ruinNum) {
            int zO;
            int xO;
            Block currBlock = savedBlock.block.getRelative(BlockFace.UP, 4 * ruinNum);
            for (xO = -xSize; xO <= xSize; ++xO) {
                for (zO = -zSize; zO <= zSize; ++zO) {
                    Block currBlockOffset = currBlock.getRelative(xO, 0, zO);
                    if (currBlockOffset.getType() == Material.AIR) {
                        state.setCurrentBlock(currBlockOffset);
                        this.block.performNode(state, true);
                    } else if (Main.getRand().nextBoolean()) {
                        state.setCurrentBlock(currBlockOffset);
                        this.block.performNode(state, true);
                    }
                    if (ruinNum != 0) continue;
                    for (int i = 1; i < 4; ++i) {
                        state.setCurrentBlock(currBlockOffset.getRelative(BlockFace.DOWN, i));
                        if (state.getCurrentBlock().block.getType() == Material.AIR) {
                            --i;
                        }
                        this.block.performNode(state, true);
                    }
                }
            }
            for (xO = -xSize; xO <= xSize; ++xO) {
                for (zO = -zSize; zO <= zSize; ++zO) {
                    if (xO != -xSize && xO != xSize && zO != -zSize && zO != zSize) continue;
                    for (int i = 0; i < 5 && Main.getRand().nextInt(5) != 0; ++i) {
                        state.setCurrentBlock(currBlock.getRelative(xO, i, zO));
                        this.block.performNode(state, true);
                    }
                }
            }
        }
        state.setCurrentBlock(savedBlock);
        return true;
    }

    @Override
    public int getArgCount() {
        return 3;
    }
}

