/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.operations.operators.core;

import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.operations.DummyState;
import com._14ercooper.worldeditor.operations.OperatorState;
import com._14ercooper.worldeditor.operations.Parser;
import com._14ercooper.worldeditor.operations.ParserState;
import com._14ercooper.worldeditor.operations.operators.Node;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TemplateNode
extends Node {
    String filename;
    final List<String> args = new ArrayList<String>();

    @Override
    public TemplateNode newNode(ParserState parserState) {
        TemplateNode node = new TemplateNode();
        node.filename = "plugins/14erEdit/templates/" + Parser.parseStringNode(parserState).getText();
        int argCount = parserState.getTestDummyState() == null ? (int)Parser.parseNumberNode(parserState).getValue(new DummyState(parserState.getCurrentPlayer())) : (int)Parser.parseNumberNode(parserState).getValue(parserState.getTestDummyState());
        for (int i = 0; i < argCount; ++i) {
            node.args.add(Parser.parseStringNode(parserState).getText());
        }
        return node;
    }

    @Override
    public boolean performNode(OperatorState state, boolean perform) {
        String command2;
        CommandSender player = state.getCurrentPlayer();
        if (!Files.exists(Paths.get(this.filename, new String[0]), new LinkOption[0])) {
            if (Files.exists(Paths.get(this.filename + ".txt", new String[0]), new LinkOption[0])) {
                this.filename = this.filename + ".txt";
            } else if (Files.exists(Paths.get(this.filename + ".fx", new String[0]), new LinkOption[0])) {
                this.filename = this.filename + ".fx";
            } else {
                Main.logError("Template not found.", player, null);
                return false;
            }
        }
        try {
            command2 = TemplateNode.readFile(this.filename);
        }
        catch (IOException e) {
            Main.logError("Error reading template file.", player, (Exception)e);
            return false;
        }
        command2 = command2.replaceAll("[\\n\\r]+", " ");
        for (int i = this.args.size() - 1; i >= 0; --i) {
            String thisArg = this.args.get(i);
            if (thisArg.equalsIgnoreCase("x")) {
                thisArg = Integer.toString(state.getCurrentBlock().x);
            } else if (thisArg.equalsIgnoreCase("y")) {
                thisArg = Integer.toString(state.getCurrentBlock().y);
            } else if (thisArg.equalsIgnoreCase("z")) {
                thisArg = Integer.toString(state.getCurrentBlock().z);
            }
            command2 = command2.replaceAll("\\$" + (i + 1), thisArg);
        }
        Main.logDebug("Template command: " + command2);
        try {
            if (player instanceof Player) {
                Player plyr = (Player)player;
                Location loc = plyr.getLocation();
                plyr.teleport(state.getCurrentBlock().block.getLocation());
                boolean retVal = Bukkit.dispatchCommand((CommandSender)player, (String)command2);
                plyr.teleport(loc);
                return retVal;
            }
            return false;
        }
        catch (Exception e) {
            Main.logError("Could not run command in template.", player, e);
            return false;
        }
    }

    static String readFile(String path) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, StandardCharsets.UTF_8);
    }

    @Override
    public int getArgCount() {
        return 2;
    }
}

