/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.operations.operators.core;

import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.operations.OperatorState;
import com._14ercooper.worldeditor.operations.Parser;
import com._14ercooper.worldeditor.operations.ParserState;
import com._14ercooper.worldeditor.operations.operators.Node;
import com._14ercooper.worldeditor.operations.operators.function.NoiseNode;

public class NumberNode
extends Node {
    public double arg = 0.0;
    boolean isRange = false;
    NumberNode rangeMin;
    NumberNode rangeMax;
    boolean isNoise = false;
    NoiseNode noise;
    public boolean isAbsolute = false;

    @Override
    public NumberNode newNode(ParserState parserState) {
        NumberNode node = new NumberNode();
        parserState.setIndex(parserState.getIndex() - 1);
        String num = "undefined";
        try {
            num = Parser.parseStringNode((ParserState)parserState).contents;
            if (num.equalsIgnoreCase("%-") || num.equalsIgnoreCase("randrange")) {
                node.rangeMin = Parser.parseNumberNode(parserState);
                node.rangeMax = Parser.parseNumberNode(parserState);
                node.isRange = true;
                return node;
            }
            if (num.equalsIgnoreCase("#-") || num.equalsIgnoreCase("randnoise")) {
                node.rangeMin = Parser.parseNumberNode(parserState);
                node.rangeMax = Parser.parseNumberNode(parserState);
                node.isNoise = true;
                return node;
            }
            if (num.toLowerCase().contains("a")) {
                node.isAbsolute = true;
                node.arg = Double.parseDouble(num.replaceAll("[A-Za-z]+", ""));
                return node;
            }
            node.arg = Double.parseDouble(num);
            return node;
        }
        catch (Exception e) {
            Main.logError("Could not parse number node. " + num + " is not a number.", parserState, e);
            return null;
        }
    }

    @Override
    public boolean performNode(OperatorState state, boolean perform) {
        return !(Math.abs(this.arg) < 0.01);
    }

    public double getValue(OperatorState state) {
        return this.getValue(state, 0.0);
    }

    public double getValue(OperatorState state, double center) {
        if (this.isRange) {
            double rangeMinVal = this.rangeMin.getValue(state);
            double rangeMaxVal = this.rangeMax.getValue(state);
            return Main.getRand().nextDouble() * (rangeMaxVal - rangeMinVal) + rangeMinVal + center;
        }
        if (this.isNoise) {
            return (double)this.noise.getNum(state) + center;
        }
        return this.arg;
    }

    public int getInt(OperatorState state) {
        return this.getInt(state, 0);
    }

    public int getInt(OperatorState state, int center) {
        return (int)this.getValue(state, center);
    }

    public int getMaxInt(OperatorState state) {
        if (this.isRange || this.isNoise) {
            return (int)this.rangeMax.getValue(state);
        }
        return (int)this.arg;
    }

    @Override
    public int getArgCount() {
        return 1;
    }
}

