/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.operations.operators.core;

import com._14ercooper.worldeditor.brush.Brush;
import com._14ercooper.worldeditor.brush.BrushShape;
import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.operations.Operator;
import com._14ercooper.worldeditor.operations.OperatorState;
import com._14ercooper.worldeditor.operations.Parser;
import com._14ercooper.worldeditor.operations.ParserState;
import com._14ercooper.worldeditor.operations.operators.Node;
import com._14ercooper.worldeditor.operations.operators.core.EntryNode;
import com._14ercooper.worldeditor.operations.operators.core.StringNode;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;

public class BrushNode
extends Node {
    public BrushShape shape = null;
    public final List<EntryNode> entry = new ArrayList<EntryNode>();

    @Override
    public BrushNode newNode(ParserState parserState) {
        try {
            StringNode stringNode;
            BrushNode node = new BrushNode();
            node.shape = Brush.GetBrushShape(Parser.parseStringNode((ParserState)parserState).contents);
            while ((stringNode = Parser.parseStringNode(parserState)) != null) {
                String nextText = stringNode.getText();
                if (nextText.equalsIgnoreCase("end")) {
                    parserState.setIndex(parserState.getIndex() + 1);
                    break;
                }
                node.shape.addNewArgument(nextText);
                if (node.shape.lastInputProcessed()) continue;
            }
            parserState.setIndex(parserState.getIndex() - 1);
            if (node.shape.gotEnoughArgs()) {
                throw new Exception("Too few arguments for the brush shape");
            }
            for (int i = 0; i < node.shape.operatorCount(); ++i) {
                Node op = Parser.parsePart(parserState);
                node.entry.add(new EntryNode(op, parserState.getIndex() + 1));
            }
            return node;
        }
        catch (Exception e) {
            Main.logError("Could not create brush node. Did you provide the correct number of arguments?", parserState, e);
            return null;
        }
    }

    @Override
    public boolean performNode(OperatorState state, boolean perform) {
        int x = state.getCurrentBlock().x;
        int y = state.getCurrentBlock().y;
        int z = state.getCurrentBlock().z;
        ArrayList<Operator> operations = new ArrayList<Operator>();
        for (EntryNode e : this.entry) {
            operations.add(new Operator(e));
        }
        this.shape.runBrush(operations, x, y, z, (Player)state.getCurrentPlayer());
        return true;
    }

    @Override
    public int getArgCount() {
        return 3;
    }
}

