/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.operations;

import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.operations.Parser;
import com._14ercooper.worldeditor.operations.ParserState;
import com._14ercooper.worldeditor.operations.operators.Node;
import com._14ercooper.worldeditor.operations.operators.core.EntryNode;
import com._14ercooper.worldeditor.operations.operators.core.NumberNode;
import com._14ercooper.worldeditor.operations.operators.core.StringNode;
import com._14ercooper.worldeditor.operations.operators.function.RangeNode;
import com._14ercooper.worldeditor.operations.operators.world.BlockNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0006H\u0007J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0005H\u0007J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0007J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001e"}, d2={"Lcom/_14ercooper/worldeditor/operations/Parser;", "", "()V", "operators", "", "", "Lcom/_14ercooper/worldeditor/operations/operators/Node;", "getOperators", "()Ljava/util/Map;", "addOperator", "", "name", "node", "getOperator", "currentPlayer", "Lorg/bukkit/command/CommandSender;", "parseNumberNode", "Lcom/_14ercooper/worldeditor/operations/operators/core/NumberNode;", "parserState", "Lcom/_14ercooper/worldeditor/operations/ParserState;", "parseOperation", "Lcom/_14ercooper/worldeditor/operations/operators/core/EntryNode;", "op", "parsePart", "numberNode", "", "parseRangeNode", "Lcom/_14ercooper/worldeditor/operations/operators/function/RangeNode;", "parseStringNode", "Lcom/_14ercooper/worldeditor/operations/operators/core/StringNode;", "14erEdit"})
public final class Parser {
    @NotNull
    private static final Map<String, Node> operators;
    @NotNull
    public static final Parser INSTANCE;

    @NotNull
    public final Map<String, Node> getOperators() {
        return operators;
    }

    @JvmStatic
    public static final void addOperator(@NotNull String name, @NotNull Node node) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(node, "node");
        if (operators.containsKey(name)) {
            return;
        }
        operators.put(name, node);
    }

    @JvmStatic
    @Nullable
    public static final Node getOperator(@NotNull CommandSender currentPlayer, @NotNull String name) {
        Intrinsics.checkNotNullParameter(currentPlayer, "currentPlayer");
        Intrinsics.checkNotNullParameter(name, "name");
        if (!operators.containsKey(name)) {
            Main.Companion.logError("Operator \"" + name + "\" not found. Please check that you input a valid operator.", currentPlayer, null);
            return null;
        }
        return operators.get(name);
    }

    @JvmStatic
    @Nullable
    public static final EntryNode parseOperation(@NotNull CommandSender currentPlayer, @NotNull String op) {
        Intrinsics.checkNotNullParameter(currentPlayer, "currentPlayer");
        Intrinsics.checkNotNullParameter(op, "op");
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)op, new String[]{" "}, false, 0, 6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Stream stream = Arrays.stream(stringArray).map(parseOperation.splitParts.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(stream, "Arrays.stream(op.split(\"\u2026.toRegex(), \"\")\n        }");
        List<String> splitParts2 = StreamsKt.toList(stream);
        ParserState state = new ParserState(currentPlayer, splitParts2);
        Node rootNode = Parser.parsePart$default(state, false, 2, null);
        if (rootNode == null) {
            Main.Companion.logError("Operation parse failed. Please check your syntax.", currentPlayer, null);
            return null;
        }
        Main.Companion.logDebug("Building entry node from root node");
        return new EntryNode(rootNode, state.getIndex() + 1);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Node parsePart(@NotNull ParserState parserState, boolean numberNode) {
        Node node;
        Intrinsics.checkNotNullParameter(parserState, "parserState");
        ParserState parserState2 = parserState;
        int n = parserState2.getIndex();
        parserState2.setIndex(n + 1);
        try {
            Node node2;
            int commentTicker = -1;
            if (StringsKt.equals(parserState.getParts().get(parserState.getIndex()), "/*", true)) {
                while (commentTicker > 0 || commentTicker == -1) {
                    if (commentTicker == -1) {
                        ++commentTicker;
                    }
                    if (StringsKt.equals(parserState.getParts().get(parserState.getIndex()), "/*", true)) {
                        ++commentTicker;
                    } else if (StringsKt.equals(parserState.getParts().get(parserState.getIndex()), "*/", true)) {
                        --commentTicker;
                    }
                    Main.Companion.logDebug("Skipped " + parserState.getParts().get(parserState.getIndex()) + " with comment ticker " + commentTicker);
                    ParserState parserState3 = parserState;
                    int n2 = parserState3.getIndex();
                    parserState3.setIndex(n2 + 1);
                }
            }
            int oldIndex = parserState.getIndex();
            if (operators.containsKey(parserState.getParts().get(parserState.getIndex()))) {
                Node node3 = operators.get(parserState.getParts().get(parserState.getIndex()));
                Intrinsics.checkNotNull(node3);
                Node n3 = node3.newNode(parserState);
                Main.Companion.logDebug(parserState.getParts().get(oldIndex) + " node created: " + n3.toString());
                node2 = n3;
            } else {
                boolean numNode = numberNode;
                CharSequence charSequence = parserState.getParts().get(parserState.getIndex());
                Regex regex = new Regex("-?\\d+");
                boolean bl = false;
                if (regex.matches(charSequence)) {
                    numNode = true;
                }
                if (!numNode) {
                    BlockNode bn;
                    StringNode strNode;
                    ParserState parserState4 = parserState;
                    int n4 = parserState4.getIndex();
                    parserState4.setIndex(n4 + -1);
                    StringNode stringNode = strNode = Parser.parseStringNode(parserState);
                    Intrinsics.checkNotNull(stringNode);
                    String string = stringNode.getText();
                    Intrinsics.checkNotNullExpressionValue(string, "strNode!!.text");
                    CharSequence charSequence2 = string;
                    boolean bl2 = false;
                    BlockNode blockNode = bn = !StringsKt.isBlank(charSequence2) ? new BlockNode().newNode(strNode.getText(), parserState) : null;
                    if (bn != null) {
                        Main.Companion.logDebug("Block node created: " + bn);
                        node2 = bn;
                    } else {
                        Main.Companion.logDebug("String node created: " + strNode);
                        node2 = strNode;
                    }
                } else {
                    node2 = new NumberNode().newNode(parserState);
                }
            }
            node = node2;
        }
        catch (IndexOutOfBoundsException e) {
            node = null;
        }
        return node;
    }

    public static /* synthetic */ Node parsePart$default(ParserState parserState, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return Parser.parsePart(parserState, bl);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Node parsePart(@NotNull ParserState parserState) {
        return Parser.parsePart$default(parserState, false, 2, null);
    }

    @JvmStatic
    @Nullable
    public static final NumberNode parseNumberNode(@NotNull ParserState parserState) {
        NumberNode numberNode;
        Intrinsics.checkNotNullParameter(parserState, "parserState");
        Main.Companion.logDebug("Number node created");
        try {
            Node node = Parser.parsePart(parserState, true);
            if (node == null) {
                throw new NullPointerException("null cannot be cast to non-null type com._14ercooper.worldeditor.operations.operators.core.NumberNode");
            }
            numberNode = (NumberNode)node;
        }
        catch (Exception e) {
            Main.Companion.logError("Number node expected. Did not find a number node.", parserState.getCurrentPlayer(), e);
            numberNode = null;
        }
        return numberNode;
    }

    @JvmStatic
    @Nullable
    public static final RangeNode parseRangeNode(@NotNull ParserState parserState) {
        RangeNode rangeNode;
        Intrinsics.checkNotNullParameter(parserState, "parserState");
        ParserState parserState2 = parserState;
        int n = parserState2.getIndex();
        parserState2.setIndex(n + 1);
        Main.Companion.logDebug("Range node created");
        try {
            rangeNode = new RangeNode().newNode(parserState);
        }
        catch (Exception e) {
            Main.Companion.logError("Range node expected. Could not create a range node.", parserState.getCurrentPlayer(), e);
            rangeNode = null;
        }
        return rangeNode;
    }

    @JvmStatic
    @Nullable
    public static final StringNode parseStringNode(@NotNull ParserState parserState) {
        StringNode stringNode;
        Intrinsics.checkNotNullParameter(parserState, "parserState");
        ParserState parserState2 = parserState;
        int n = parserState2.getIndex();
        parserState2.setIndex(n + 1);
        Main.Companion.logDebug("String node created");
        try {
            StringNode node = new StringNode();
            node.contents = parserState.getParts().get(parserState.getIndex());
            Main.Companion.logDebug(node.contents);
        }
        catch (Exception e) {
            stringNode = null;
        }
        return stringNode;
    }

    private Parser() {
    }

    static {
        Parser parser;
        INSTANCE = parser = new Parser();
        operators = new HashMap();
    }
}

