/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.operations;

import com._14ercooper.worldeditor.operations.Parser;
import com._14ercooper.worldeditor.operations.operators.Node;
import com._14ercooper.worldeditor.operations.operators.core.BrushNode;
import com._14ercooper.worldeditor.operations.operators.core.CraftscriptNode;
import com._14ercooper.worldeditor.operations.operators.core.LinkerNode;
import com._14ercooper.worldeditor.operations.operators.core.MacroNode;
import com._14ercooper.worldeditor.operations.operators.core.NumberNode;
import com._14ercooper.worldeditor.operations.operators.core.TemplateNode;
import com._14ercooper.worldeditor.operations.operators.core.XNode;
import com._14ercooper.worldeditor.operations.operators.core.YNode;
import com._14ercooper.worldeditor.operations.operators.core.ZNode;
import com._14ercooper.worldeditor.operations.operators.fun.SmallRuinNode;
import com._14ercooper.worldeditor.operations.operators.function.EveryXNode;
import com._14ercooper.worldeditor.operations.operators.function.FunctionNode;
import com._14ercooper.worldeditor.operations.operators.function.LimitNode;
import com._14ercooper.worldeditor.operations.operators.function.ModulusNode;
import com._14ercooper.worldeditor.operations.operators.function.MultiNoiseNode;
import com._14ercooper.worldeditor.operations.operators.function.NoiseNode;
import com._14ercooper.worldeditor.operations.operators.function.OddsNode;
import com._14ercooper.worldeditor.operations.operators.function.RangeNode;
import com._14ercooper.worldeditor.operations.operators.function.RemainderNode;
import com._14ercooper.worldeditor.operations.operators.function.SimplexNode;
import com._14ercooper.worldeditor.operations.operators.logical.AndNode;
import com._14ercooper.worldeditor.operations.operators.logical.AnyOfNode;
import com._14ercooper.worldeditor.operations.operators.logical.ElseNode;
import com._14ercooper.worldeditor.operations.operators.logical.FalseNode;
import com._14ercooper.worldeditor.operations.operators.logical.IfNode;
import com._14ercooper.worldeditor.operations.operators.logical.NotNode;
import com._14ercooper.worldeditor.operations.operators.logical.OrNode;
import com._14ercooper.worldeditor.operations.operators.logical.TrueNode;
import com._14ercooper.worldeditor.operations.operators.logical.XorNode;
import com._14ercooper.worldeditor.operations.operators.loop.WhileNode;
import com._14ercooper.worldeditor.operations.operators.math.AbsoluteValueNode;
import com._14ercooper.worldeditor.operations.operators.math.AddNode;
import com._14ercooper.worldeditor.operations.operators.math.ArccosineNode;
import com._14ercooper.worldeditor.operations.operators.math.ArcsineNode;
import com._14ercooper.worldeditor.operations.operators.math.ArctangentNode;
import com._14ercooper.worldeditor.operations.operators.math.BetweenNode;
import com._14ercooper.worldeditor.operations.operators.math.CeilingNode;
import com._14ercooper.worldeditor.operations.operators.math.CosecantNode;
import com._14ercooper.worldeditor.operations.operators.math.CosineNode;
import com._14ercooper.worldeditor.operations.operators.math.CotangentNode;
import com._14ercooper.worldeditor.operations.operators.math.DivideNode;
import com._14ercooper.worldeditor.operations.operators.math.ENode;
import com._14ercooper.worldeditor.operations.operators.math.EqualsNode;
import com._14ercooper.worldeditor.operations.operators.math.FloorNode;
import com._14ercooper.worldeditor.operations.operators.math.GreaterThanNode;
import com._14ercooper.worldeditor.operations.operators.math.HyperbolicCosineNode;
import com._14ercooper.worldeditor.operations.operators.math.HyperbolicSineNode;
import com._14ercooper.worldeditor.operations.operators.math.HyperbolicTangentNode;
import com._14ercooper.worldeditor.operations.operators.math.LessThanNode;
import com._14ercooper.worldeditor.operations.operators.math.Log10Node;
import com._14ercooper.worldeditor.operations.operators.math.Log2Node;
import com._14ercooper.worldeditor.operations.operators.math.LogarithmNode;
import com._14ercooper.worldeditor.operations.operators.math.MultiplyNode;
import com._14ercooper.worldeditor.operations.operators.math.NaturalLogNode;
import com._14ercooper.worldeditor.operations.operators.math.NegateNode;
import com._14ercooper.worldeditor.operations.operators.math.PhiNode;
import com._14ercooper.worldeditor.operations.operators.math.PiNode;
import com._14ercooper.worldeditor.operations.operators.math.PowerNode;
import com._14ercooper.worldeditor.operations.operators.math.RXNode;
import com._14ercooper.worldeditor.operations.operators.math.RYNode;
import com._14ercooper.worldeditor.operations.operators.math.RZNode;
import com._14ercooper.worldeditor.operations.operators.math.RadiusNode;
import com._14ercooper.worldeditor.operations.operators.math.RadiusSquaredNode;
import com._14ercooper.worldeditor.operations.operators.math.RandomNode;
import com._14ercooper.worldeditor.operations.operators.math.RoundNode;
import com._14ercooper.worldeditor.operations.operators.math.SecantNode;
import com._14ercooper.worldeditor.operations.operators.math.SigmoidNode;
import com._14ercooper.worldeditor.operations.operators.math.SignNode;
import com._14ercooper.worldeditor.operations.operators.math.SineNode;
import com._14ercooper.worldeditor.operations.operators.math.SquareNode;
import com._14ercooper.worldeditor.operations.operators.math.SquareRootNode;
import com._14ercooper.worldeditor.operations.operators.math.SubtractNode;
import com._14ercooper.worldeditor.operations.operators.math.TangentNode;
import com._14ercooper.worldeditor.operations.operators.math.ThetaNode;
import com._14ercooper.worldeditor.operations.operators.math.ToDegreesNode;
import com._14ercooper.worldeditor.operations.operators.math.ToRadiansNode;
import com._14ercooper.worldeditor.operations.operators.query.AngleNode;
import com._14ercooper.worldeditor.operations.operators.query.BlockAtNode;
import com._14ercooper.worldeditor.operations.operators.query.BlocklightNode;
import com._14ercooper.worldeditor.operations.operators.query.BlocksAboveNode;
import com._14ercooper.worldeditor.operations.operators.query.BlocksAdjacentHorizontalNode;
import com._14ercooper.worldeditor.operations.operators.query.BlocksAdjacentNode;
import com._14ercooper.worldeditor.operations.operators.query.BlocksAdjacentVerticalNode;
import com._14ercooper.worldeditor.operations.operators.query.BlocksBelowNode;
import com._14ercooper.worldeditor.operations.operators.query.CheckBiomeNode;
import com._14ercooper.worldeditor.operations.operators.query.FacesExposedNode;
import com._14ercooper.worldeditor.operations.operators.query.GetNBTNode;
import com._14ercooper.worldeditor.operations.operators.query.NearbyNode;
import com._14ercooper.worldeditor.operations.operators.query.NoiseAtNode;
import com._14ercooper.worldeditor.operations.operators.query.SkylightNode;
import com._14ercooper.worldeditor.operations.operators.variable.GetOperatorVariableNode;
import com._14ercooper.worldeditor.operations.operators.variable.GetPlayerVariableNode;
import com._14ercooper.worldeditor.operations.operators.variable.ResetOperatorVariablesNode;
import com._14ercooper.worldeditor.operations.operators.variable.ResetPlayerVariablesNode;
import com._14ercooper.worldeditor.operations.operators.variable.SetOperatorVariableNode;
import com._14ercooper.worldeditor.operations.operators.variable.SetPlayerVariableNode;
import com._14ercooper.worldeditor.operations.operators.world.BlockNode;
import com._14ercooper.worldeditor.operations.operators.world.BonemealNode;
import com._14ercooper.worldeditor.operations.operators.world.GetBlockDataNode;
import com._14ercooper.worldeditor.operations.operators.world.GravityNode;
import com._14ercooper.worldeditor.operations.operators.world.IgnorePhysicsNode;
import com._14ercooper.worldeditor.operations.operators.world.ReplaceNode;
import com._14ercooper.worldeditor.operations.operators.world.RotateNode;
import com._14ercooper.worldeditor.operations.operators.world.SameNode;
import com._14ercooper.worldeditor.operations.operators.world.SchemBlockNode;
import com._14ercooper.worldeditor.operations.operators.world.SetBiomeNode;
import com._14ercooper.worldeditor.operations.operators.world.SetNBTNode;
import com._14ercooper.worldeditor.operations.operators.world.SetNode;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

public class OperatorLoader {
    public static List<String> nodeNames = new ArrayList<String>();
    public static List<String> blockNodeNames = new ArrayList<String>();
    public static List<String> numberNodeNames = new ArrayList<String>();
    public static List<String> rangeNodeNames = new ArrayList<String>();
    public static List<String> nextRange = new ArrayList<String>();
    public static List<String> nextBlock = new ArrayList<String>();

    public static void LoadOperators(CommandSender commandSender) {
        OperatorLoader.LoadCore(commandSender);
        OperatorLoader.LoadFunction(commandSender);
        OperatorLoader.LoadLogical(commandSender);
        OperatorLoader.LoadLoop(commandSender);
        OperatorLoader.LoadQuery(commandSender);
        OperatorLoader.LoadWorld(commandSender);
        OperatorLoader.LoadFun(commandSender);
        OperatorLoader.LoadMath(commandSender);
        OperatorLoader.LoadVariable(commandSender);
    }

    public static void LoadOperators() {
        OperatorLoader.LoadOperators((CommandSender)Bukkit.getConsoleSender());
    }

    private static void loadNode(String name, Node node) {
        nodeNames.add(name);
        if (node instanceof BlockNode) {
            blockNodeNames.add(name);
        }
        if (node instanceof NumberNode) {
            numberNodeNames.add(name);
        }
        if (node instanceof RangeNode) {
            rangeNodeNames.add(name);
        }
        if (node.isNextNodeRange()) {
            nextRange.add(name);
        }
        if (node.isNextNodeBlock()) {
            nextBlock.add(name);
        }
        Parser.addOperator(name, node);
    }

    private static void LoadCore(CommandSender commandSender) {
        OperatorLoader.loadNode("$$", new CraftscriptNode());
        OperatorLoader.loadNode("craftscript", Parser.getOperator(commandSender, "$$"));
        OperatorLoader.loadNode("script", Parser.getOperator(commandSender, "$$"));
        OperatorLoader.loadNode("/", new LinkerNode());
        OperatorLoader.loadNode("link", Parser.getOperator(commandSender, "/"));
        OperatorLoader.loadNode("$", new MacroNode());
        OperatorLoader.loadNode("macro", Parser.getOperator(commandSender, "$"));
        OperatorLoader.loadNode("x", new XNode());
        OperatorLoader.loadNode("y", new YNode());
        OperatorLoader.loadNode("z", new ZNode());
        OperatorLoader.loadNode("br", new BrushNode());
        OperatorLoader.loadNode("brush", Parser.getOperator(commandSender, "br"));
    }

    private static void LoadFunction(CommandSender commandSender) {
        OperatorLoader.loadNode("%", new OddsNode());
        OperatorLoader.loadNode("odds", Parser.getOperator(commandSender, "%"));
        OperatorLoader.loadNode("chance", Parser.getOperator(commandSender, "%"));
        OperatorLoader.loadNode("-", new RangeNode());
        OperatorLoader.loadNode("range", Parser.getOperator(commandSender, "-"));
        OperatorLoader.loadNode("inrange", Parser.getOperator(commandSender, "-"));
        OperatorLoader.loadNode("in_range", Parser.getOperator(commandSender, "-"));
        OperatorLoader.loadNode(";", new RemainderNode());
        OperatorLoader.loadNode("rem", Parser.getOperator(commandSender, ";"));
        OperatorLoader.loadNode("remainder", Parser.getOperator(commandSender, ";"));
        OperatorLoader.loadNode("mod", new ModulusNode());
        OperatorLoader.loadNode("limit", new LimitNode());
        OperatorLoader.loadNode(";;", new EveryXNode());
        OperatorLoader.loadNode("every", Parser.getOperator(commandSender, ";;"));
        OperatorLoader.loadNode("step", Parser.getOperator(commandSender, ";;"));
        OperatorLoader.loadNode("#", new SimplexNode());
        OperatorLoader.loadNode("simplex", Parser.getOperator(commandSender, "#"));
        OperatorLoader.loadNode("##", new NoiseNode());
        OperatorLoader.loadNode("noise", Parser.getOperator(commandSender, "##"));
        OperatorLoader.loadNode("#a", new NoiseAtNode());
        OperatorLoader.loadNode("noiseat", Parser.getOperator(commandSender, "#a"));
        OperatorLoader.loadNode("fx", new FunctionNode());
        OperatorLoader.loadNode("function", Parser.getOperator(commandSender, "fx"));
        OperatorLoader.loadNode("m#", new MultiNoiseNode());
        OperatorLoader.loadNode("multinoise", Parser.getOperator(commandSender, "m#"));
    }

    private static void LoadLogical(CommandSender commandSender) {
        OperatorLoader.loadNode("&", new AndNode());
        OperatorLoader.loadNode("and", Parser.getOperator(commandSender, "&"));
        OperatorLoader.loadNode("both", Parser.getOperator(commandSender, "&"));
        OperatorLoader.loadNode("false", new FalseNode());
        OperatorLoader.loadNode("?", new IfNode());
        OperatorLoader.loadNode("if", Parser.getOperator(commandSender, "?"));
        OperatorLoader.loadNode(":", new ElseNode());
        OperatorLoader.loadNode("else", Parser.getOperator(commandSender, ":"));
        OperatorLoader.loadNode("~", new NotNode());
        OperatorLoader.loadNode("not", Parser.getOperator(commandSender, "~"));
        OperatorLoader.loadNode("|", new OrNode());
        OperatorLoader.loadNode("or", Parser.getOperator(commandSender, "|"));
        OperatorLoader.loadNode("either", Parser.getOperator(commandSender, "|"));
        OperatorLoader.loadNode("true", new TrueNode());
        OperatorLoader.loadNode("<", new XorNode());
        OperatorLoader.loadNode("xor", Parser.getOperator(commandSender, "<"));
        OperatorLoader.loadNode("one_of", Parser.getOperator(commandSender, "<"));
        OperatorLoader.loadNode("anyof", new AnyOfNode());
        OperatorLoader.loadNode("any_of", Parser.getOperator(commandSender, "anyof"));
    }

    private static void LoadLoop(CommandSender commandSender) {
        OperatorLoader.loadNode("loop", new WhileNode());
        OperatorLoader.loadNode("while", Parser.getOperator(commandSender, "loop"));
    }

    private static void LoadQuery(CommandSender commandSender) {
        OperatorLoader.loadNode("@", new BlocksAdjacentNode());
        OperatorLoader.loadNode("adj", Parser.getOperator(commandSender, "@"));
        OperatorLoader.loadNode("adjacent", Parser.getOperator(commandSender, "@"));
        OperatorLoader.loadNode("blocks_adjacent", Parser.getOperator(commandSender, "@"));
        OperatorLoader.loadNode("^", new BlocksAboveNode());
        OperatorLoader.loadNode("blocks_above", Parser.getOperator(commandSender, "^"));
        OperatorLoader.loadNode("above", Parser.getOperator(commandSender, "^"));
        OperatorLoader.loadNode("_", new BlocksBelowNode());
        OperatorLoader.loadNode("blocks_below", Parser.getOperator(commandSender, "_"));
        OperatorLoader.loadNode("below", Parser.getOperator(commandSender, "_"));
        OperatorLoader.loadNode("*", new FacesExposedNode());
        OperatorLoader.loadNode("exposed", Parser.getOperator(commandSender, "*"));
        OperatorLoader.loadNode("faces_exposed", Parser.getOperator(commandSender, "*"));
        OperatorLoader.loadNode("<<n", new GetNBTNode());
        OperatorLoader.loadNode("get_nbt", Parser.getOperator(commandSender, "<<n"));
        OperatorLoader.loadNode("at", new BlockAtNode());
        OperatorLoader.loadNode("block_at", Parser.getOperator(commandSender, "at"));
        OperatorLoader.loadNode("sky", new SkylightNode());
        OperatorLoader.loadNode("skylight", Parser.getOperator(commandSender, "sky"));
        OperatorLoader.loadNode("bl", new BlocklightNode());
        OperatorLoader.loadNode("blocklight", Parser.getOperator(commandSender, "bl"));
        OperatorLoader.loadNode("ang", new AngleNode());
        OperatorLoader.loadNode("angle", Parser.getOperator(commandSender, "ang"));
        OperatorLoader.loadNode("slope", Parser.getOperator(commandSender, "ang"));
        OperatorLoader.loadNode("biome_is", new CheckBiomeNode());
        OperatorLoader.loadNode("get_biome", Parser.getOperator(commandSender, "biome_is"));
        OperatorLoader.loadNode("is_biome", Parser.getOperator(commandSender, "biome_is"));
        OperatorLoader.loadNode("@@", new NearbyNode());
        OperatorLoader.loadNode("near", Parser.getOperator(commandSender, "@@"));
        OperatorLoader.loadNode("nearby", Parser.getOperator(commandSender, "@@"));
        OperatorLoader.loadNode("@v", new BlocksAdjacentVerticalNode());
        OperatorLoader.loadNode("adjv", Parser.getOperator(commandSender, "@v"));
        OperatorLoader.loadNode("adjacent_vertical", Parser.getOperator(commandSender, "@v"));
        OperatorLoader.loadNode("@h", new BlocksAdjacentHorizontalNode());
        OperatorLoader.loadNode("adjh", Parser.getOperator(commandSender, "@h"));
        OperatorLoader.loadNode("adjacent_horizontal", Parser.getOperator(commandSender, "@h"));
        OperatorLoader.loadNode("@d", new BlocksAdjacentHorizontalNode());
        OperatorLoader.loadNode("adjd", Parser.getOperator(commandSender, "@h"));
        OperatorLoader.loadNode("adjacent_diagonal", Parser.getOperator(commandSender, "@h"));
    }

    private static void LoadWorld(CommandSender commandSender) {
        OperatorLoader.loadNode("<<", new GetBlockDataNode());
        OperatorLoader.loadNode("get_data", Parser.getOperator(commandSender, "<<"));
        OperatorLoader.loadNode("data", Parser.getOperator(commandSender, "<<"));
        OperatorLoader.loadNode("get_block_data", Parser.getOperator(commandSender, "<<"));
        OperatorLoader.loadNode("!", new IgnorePhysicsNode());
        OperatorLoader.loadNode("physics", Parser.getOperator(commandSender, "!"));
        OperatorLoader.loadNode("ignore_physcics", Parser.getOperator(commandSender, "!"));
        OperatorLoader.loadNode("same", new SameNode());
        OperatorLoader.loadNode(">>n", new SetNBTNode());
        OperatorLoader.loadNode("set_nbt", Parser.getOperator(commandSender, ">>n"));
        OperatorLoader.loadNode(">", new SetNode());
        OperatorLoader.loadNode("set", Parser.getOperator(commandSender, ">"));
        OperatorLoader.loadNode("set_block", Parser.getOperator(commandSender, ">"));
        OperatorLoader.loadNode(">>", Parser.getOperator(commandSender, ">"));
        OperatorLoader.loadNode("grav", new GravityNode());
        OperatorLoader.loadNode("gravity", Parser.getOperator(commandSender, "grav"));
        OperatorLoader.loadNode("biome", new SetBiomeNode());
        OperatorLoader.loadNode("set_biome", Parser.getOperator(commandSender, "biome"));
        OperatorLoader.loadNode("schem", new SchemBlockNode());
        OperatorLoader.loadNode("schematic", Parser.getOperator(commandSender, "schem"));
        OperatorLoader.loadNode(">r", new ReplaceNode());
        OperatorLoader.loadNode("replace", Parser.getOperator(commandSender, ">r"));
        OperatorLoader.loadNode("bonemeal", new BonemealNode());
        OperatorLoader.loadNode("bone", Parser.getOperator(commandSender, "bonemeal"));
        OperatorLoader.loadNode("rotate", new RotateNode());
    }

    private static void LoadFun(CommandSender commandSender) {
        OperatorLoader.loadNode("smallruin", new SmallRuinNode());
        OperatorLoader.loadNode("template", new TemplateNode());
        OperatorLoader.loadNode("tpl", Parser.getOperator(commandSender, "template"));
    }

    private static void LoadMath(CommandSender commandSender) {
        OperatorLoader.loadNode("rx", new RXNode());
        OperatorLoader.loadNode("ry", new RYNode());
        OperatorLoader.loadNode("rz", new RZNode());
        OperatorLoader.loadNode("r", new RadiusNode());
        OperatorLoader.loadNode("r2", new RadiusSquaredNode());
        OperatorLoader.loadNode("theta", new ThetaNode());
        OperatorLoader.loadNode("phi", new PhiNode());
        OperatorLoader.loadNode("add", new AddNode());
        OperatorLoader.loadNode("sub", new SubtractNode());
        OperatorLoader.loadNode("mult", new MultiplyNode());
        OperatorLoader.loadNode("div", new DivideNode());
        OperatorLoader.loadNode("neg", new NegateNode());
        OperatorLoader.loadNode("sin", new SineNode());
        OperatorLoader.loadNode("cos", new CosineNode());
        OperatorLoader.loadNode("tan", new TangentNode());
        OperatorLoader.loadNode("cot", new CotangentNode());
        OperatorLoader.loadNode("sec", new SecantNode());
        OperatorLoader.loadNode("csc", new CosecantNode());
        OperatorLoader.loadNode("sqrt", new SquareRootNode());
        OperatorLoader.loadNode("square", new SquareNode());
        OperatorLoader.loadNode("abs", new AbsoluteValueNode());
        OperatorLoader.loadNode("log10", new Log10Node());
        OperatorLoader.loadNode("log2", new Log2Node());
        OperatorLoader.loadNode("ln", new NaturalLogNode());
        OperatorLoader.loadNode("2deg", new ToDegreesNode());
        OperatorLoader.loadNode("2rad", new ToRadiansNode());
        OperatorLoader.loadNode("asin", new ArcsineNode());
        OperatorLoader.loadNode("acos", new ArccosineNode());
        OperatorLoader.loadNode("atan", new ArctangentNode());
        OperatorLoader.loadNode("ceil", new CeilingNode());
        OperatorLoader.loadNode("floor", new FloorNode());
        OperatorLoader.loadNode("round", new RoundNode());
        OperatorLoader.loadNode("sinh", new HyperbolicSineNode());
        OperatorLoader.loadNode("cosh", new HyperbolicCosineNode());
        OperatorLoader.loadNode("tanh", new HyperbolicTangentNode());
        OperatorLoader.loadNode("sign", new SignNode());
        OperatorLoader.loadNode("sigmoid", new SigmoidNode());
        OperatorLoader.loadNode("e", new ENode());
        OperatorLoader.loadNode("pi", new PiNode());
        OperatorLoader.loadNode("rand", new RandomNode());
        OperatorLoader.loadNode("log", new LogarithmNode());
        OperatorLoader.loadNode("pow", new PowerNode());
        OperatorLoader.loadNode("eq", new EqualsNode());
        OperatorLoader.loadNode("equals", Parser.getOperator(commandSender, "eq"));
        OperatorLoader.loadNode("lt", new LessThanNode());
        OperatorLoader.loadNode("lessthan", Parser.getOperator(commandSender, "lt"));
        OperatorLoader.loadNode("gt", new GreaterThanNode());
        OperatorLoader.loadNode("greaterthan", Parser.getOperator(commandSender, "gt"));
        OperatorLoader.loadNode("between", new BetweenNode());
    }

    private static void LoadVariable(CommandSender sender) {
        OperatorLoader.loadNode("setVar", new SetOperatorVariableNode());
        OperatorLoader.loadNode("getVar", new GetOperatorVariableNode());
        OperatorLoader.loadNode("resetVars", new ResetOperatorVariablesNode());
        OperatorLoader.loadNode("setPlayerVar", new SetPlayerVariableNode());
        OperatorLoader.loadNode("getPlayerVar", new GetPlayerVariableNode());
        OperatorLoader.loadNode("resetPlayerVars", new ResetPlayerVariablesNode());
    }
}

