/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.main;

import com._14ercooper.worldeditor.async.AsyncManager;
import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.player.PlayerManager;
import com._14ercooper.worldeditor.player.PlayerWrapper;
import com._14ercooper.worldeditor.undo.UndoElement;
import com._14ercooper.worldeditor.undo.UndoMode;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Leaves;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J*\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0007J2\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0007J4\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0007J<\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0007J*\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00152\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0007J4\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00152\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0015H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/_14ercooper/worldeditor/main/SetBlock;", "", "()V", "invalidMaterial", "", "mat", "Lorg/bukkit/Material;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "currentPlayer", "Lorg/bukkit/command/CommandSender;", "setMaterial", "", "b", "Lorg/bukkit/block/Block;", "undo", "Lcom/_14ercooper/worldeditor/undo/UndoElement;", "physics", "data", "Lorg/bukkit/block/data/BlockData;", "Lorg/bukkit/block/BlockState;", "updateLeafData", "updateLeafDataState", "14erEdit"})
public final class SetBlock {
    @NotNull
    public static final SetBlock INSTANCE;

    @JvmStatic
    public static final boolean setMaterial(@NotNull Block b, @Nullable Material mat, @NotNull UndoElement undo, @NotNull CommandSender currentPlayer) {
        Intrinsics.checkNotNullParameter(b, "b");
        Intrinsics.checkNotNullParameter(undo, "undo");
        Intrinsics.checkNotNullParameter(currentPlayer, "currentPlayer");
        if (AsyncManager.INSTANCE.getCountEdits()) {
            AsyncManager asyncManager = AsyncManager.INSTANCE;
            asyncManager.setDoneOperations(asyncManager.getDoneOperations() + 1L);
            asyncManager.getDoneOperations();
        }
        if (PlayerManager.getPlayerWrapper(currentPlayer).outsideEditRegion(b.getX(), b.getY(), b.getZ())) {
            return false;
        }
        PlayerWrapper playerWrapper = PlayerManager.getPlayerWrapper(currentPlayer);
        Material material = b.getType();
        Intrinsics.checkNotNullExpressionValue(material, "b.type");
        if (!playerWrapper.shouldEdit(material)) {
            return false;
        }
        try {
            BlockState blockState = b.getState();
            Intrinsics.checkNotNullExpressionValue(blockState, "b.state");
            BlockState bs = blockState;
            Material material2 = mat;
            Intrinsics.checkNotNull(material2);
            b.setType(material2, false);
            if (undo.getCurrentState() != UndoMode.PERFORMING_UNDO && undo.getCurrentState() != UndoMode.PERFORMING_REDO) {
                BlockState blockState2 = b.getState();
                Intrinsics.checkNotNullExpressionValue(blockState2, "b.state");
                undo.addBlock(bs, blockState2);
            }
            INSTANCE.updateLeafData(mat, b);
            return true;
        }
        catch (Exception e) {
            INSTANCE.invalidMaterial(mat, e, currentPlayer);
            return false;
        }
    }

    @JvmStatic
    public static final boolean setMaterial(@NotNull Block b, @Nullable Material mat, boolean physics, @NotNull UndoElement undo, @NotNull CommandSender currentPlayer) {
        Intrinsics.checkNotNullParameter(b, "b");
        Intrinsics.checkNotNullParameter(undo, "undo");
        Intrinsics.checkNotNullParameter(currentPlayer, "currentPlayer");
        if (AsyncManager.INSTANCE.getCountEdits()) {
            AsyncManager asyncManager = AsyncManager.INSTANCE;
            asyncManager.setDoneOperations(asyncManager.getDoneOperations() + 1L);
            asyncManager.getDoneOperations();
        }
        if (PlayerManager.getPlayerWrapper(currentPlayer).outsideEditRegion(b.getX(), b.getY(), b.getZ())) {
            return false;
        }
        PlayerWrapper playerWrapper = PlayerManager.getPlayerWrapper(currentPlayer);
        Material material = b.getType();
        Intrinsics.checkNotNullExpressionValue(material, "b.type");
        if (!playerWrapper.shouldEdit(material)) {
            return false;
        }
        try {
            BlockState blockState = b.getState();
            Intrinsics.checkNotNullExpressionValue(blockState, "b.state");
            BlockState bs = blockState;
            Material material2 = mat;
            Intrinsics.checkNotNull(material2);
            b.setType(material2, physics);
            if (undo.getCurrentState() != UndoMode.PERFORMING_UNDO && undo.getCurrentState() != UndoMode.PERFORMING_REDO) {
                BlockState blockState2 = b.getState();
                Intrinsics.checkNotNullExpressionValue(blockState2, "b.state");
                undo.addBlock(bs, blockState2);
            }
            INSTANCE.updateLeafData(mat, b);
            return true;
        }
        catch (Exception e) {
            INSTANCE.invalidMaterial(mat, e, currentPlayer);
            return false;
        }
    }

    @JvmStatic
    public static final boolean setMaterial(@NotNull Block b, @Nullable Material mat, @Nullable BlockData data, @NotNull UndoElement undo, @NotNull CommandSender currentPlayer) {
        Intrinsics.checkNotNullParameter(b, "b");
        Intrinsics.checkNotNullParameter(undo, "undo");
        Intrinsics.checkNotNullParameter(currentPlayer, "currentPlayer");
        if (AsyncManager.INSTANCE.getCountEdits()) {
            AsyncManager asyncManager = AsyncManager.INSTANCE;
            asyncManager.setDoneOperations(asyncManager.getDoneOperations() + 1L);
            asyncManager.getDoneOperations();
        }
        if (PlayerManager.getPlayerWrapper(currentPlayer).outsideEditRegion(b.getX(), b.getY(), b.getZ())) {
            return false;
        }
        PlayerWrapper playerWrapper = PlayerManager.getPlayerWrapper(currentPlayer);
        Material material = b.getType();
        Intrinsics.checkNotNullExpressionValue(material, "b.type");
        if (!playerWrapper.shouldEdit(material)) {
            return false;
        }
        try {
            BlockState blockState = b.getState();
            Intrinsics.checkNotNullExpressionValue(blockState, "b.state");
            BlockState bs = blockState;
            Material material2 = mat;
            Intrinsics.checkNotNull(material2);
            b.setType(material2, false);
            INSTANCE.updateLeafData(mat, b);
            try {
                if (data != null) {
                    b.setBlockData(data, false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (undo.getCurrentState() != UndoMode.PERFORMING_UNDO && undo.getCurrentState() != UndoMode.PERFORMING_REDO) {
                BlockState blockState2 = b.getState();
                Intrinsics.checkNotNullExpressionValue(blockState2, "b.state");
                undo.addBlock(bs, blockState2);
            }
            return true;
        }
        catch (Exception e) {
            INSTANCE.invalidMaterial(mat, e, currentPlayer);
            return false;
        }
    }

    @JvmStatic
    public static final boolean setMaterial(@NotNull Block b, @Nullable Material mat, @Nullable BlockData data, boolean physics, @NotNull UndoElement undo, @NotNull CommandSender currentPlayer) {
        Intrinsics.checkNotNullParameter(b, "b");
        Intrinsics.checkNotNullParameter(undo, "undo");
        Intrinsics.checkNotNullParameter(currentPlayer, "currentPlayer");
        if (AsyncManager.INSTANCE.getCountEdits()) {
            AsyncManager asyncManager = AsyncManager.INSTANCE;
            asyncManager.setDoneOperations(asyncManager.getDoneOperations() + 1L);
            asyncManager.getDoneOperations();
        }
        if (PlayerManager.getPlayerWrapper(currentPlayer).outsideEditRegion(b.getX(), b.getY(), b.getZ())) {
            return false;
        }
        PlayerWrapper playerWrapper = PlayerManager.getPlayerWrapper(currentPlayer);
        Material material = b.getType();
        Intrinsics.checkNotNullExpressionValue(material, "b.type");
        if (!playerWrapper.shouldEdit(material)) {
            return false;
        }
        try {
            BlockState blockState = b.getState();
            Intrinsics.checkNotNullExpressionValue(blockState, "b.state");
            BlockState bs = blockState;
            Material material2 = mat;
            Intrinsics.checkNotNull(material2);
            b.setType(material2, physics);
            INSTANCE.updateLeafData(mat, b);
            try {
                if (data != null) {
                    b.setBlockData(data, physics);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (undo.getCurrentState() != UndoMode.PERFORMING_UNDO && undo.getCurrentState() != UndoMode.PERFORMING_REDO) {
                BlockState blockState2 = b.getState();
                Intrinsics.checkNotNullExpressionValue(blockState2, "b.state");
                undo.addBlock(bs, blockState2);
            }
            return true;
        }
        catch (Exception e) {
            INSTANCE.invalidMaterial(mat, e, currentPlayer);
            return false;
        }
    }

    private final void updateLeafData(Material mat, Block b) {
        String string = mat.toString();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.String).toLowerCase()");
        if (StringsKt.contains$default((CharSequence)string3, "leaves", false, 2, null)) {
            BlockData blockData = b.getBlockData();
            if (blockData == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.bukkit.block.data.type.Leaves");
            }
            Leaves leafData = (Leaves)blockData;
            leafData.setPersistent(true);
            b.setBlockData((BlockData)leafData);
        }
    }

    @JvmStatic
    public static final boolean setMaterial(@NotNull BlockState b, @Nullable Material mat, @NotNull UndoElement undo, @NotNull CommandSender currentPlayer) {
        Intrinsics.checkNotNullParameter(b, "b");
        Intrinsics.checkNotNullParameter(undo, "undo");
        Intrinsics.checkNotNullParameter(currentPlayer, "currentPlayer");
        if (AsyncManager.INSTANCE.getCountEdits()) {
            AsyncManager asyncManager = AsyncManager.INSTANCE;
            asyncManager.setDoneOperations(asyncManager.getDoneOperations() + 1L);
            asyncManager.getDoneOperations();
        }
        if (PlayerManager.getPlayerWrapper(currentPlayer).outsideEditRegion(b.getX(), b.getY(), b.getZ())) {
            return false;
        }
        PlayerWrapper playerWrapper = PlayerManager.getPlayerWrapper(currentPlayer);
        Material material = b.getType();
        Intrinsics.checkNotNullExpressionValue(material, "b.type");
        if (!playerWrapper.shouldEdit(material)) {
            return false;
        }
        try {
            Block block = b.getBlock();
            Intrinsics.checkNotNullExpressionValue(block, "b.block");
            BlockState blockState = block.getState();
            Intrinsics.checkNotNullExpressionValue(blockState, "b.block.state");
            BlockState bs = blockState;
            Material material2 = mat;
            Intrinsics.checkNotNull(material2);
            b.setType(material2);
            if (undo.getCurrentState() != UndoMode.PERFORMING_UNDO && undo.getCurrentState() != UndoMode.PERFORMING_REDO) {
                undo.addBlock(bs, b);
            }
            INSTANCE.updateLeafDataState(mat, b);
            return true;
        }
        catch (Exception e) {
            INSTANCE.invalidMaterial(mat, e, currentPlayer);
            return false;
        }
    }

    @JvmStatic
    public static final boolean setMaterial(@NotNull BlockState b, @Nullable Material mat, @Nullable BlockData data, @NotNull UndoElement undo, @NotNull CommandSender currentPlayer) {
        Intrinsics.checkNotNullParameter(b, "b");
        Intrinsics.checkNotNullParameter(undo, "undo");
        Intrinsics.checkNotNullParameter(currentPlayer, "currentPlayer");
        if (AsyncManager.INSTANCE.getCountEdits()) {
            AsyncManager asyncManager = AsyncManager.INSTANCE;
            asyncManager.setDoneOperations(asyncManager.getDoneOperations() + 1L);
            asyncManager.getDoneOperations();
        }
        if (PlayerManager.getPlayerWrapper(currentPlayer).outsideEditRegion(b.getX(), b.getY(), b.getZ())) {
            return false;
        }
        PlayerWrapper playerWrapper = PlayerManager.getPlayerWrapper(currentPlayer);
        Material material = b.getType();
        Intrinsics.checkNotNullExpressionValue(material, "b.type");
        if (!playerWrapper.shouldEdit(material)) {
            return false;
        }
        try {
            Block block = b.getBlock();
            Intrinsics.checkNotNullExpressionValue(block, "b.block");
            BlockState blockState = block.getState();
            Intrinsics.checkNotNullExpressionValue(blockState, "b.block.state");
            BlockState bs = blockState;
            Material material2 = mat;
            Intrinsics.checkNotNull(material2);
            b.setType(material2);
            INSTANCE.updateLeafDataState(mat, b);
            try {
                if (data != null) {
                    b.setBlockData(data);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (undo.getCurrentState() != UndoMode.PERFORMING_UNDO && undo.getCurrentState() != UndoMode.PERFORMING_REDO) {
                undo.addBlock(bs, b);
            }
            return true;
        }
        catch (Exception e) {
            INSTANCE.invalidMaterial(mat, e, currentPlayer);
            return false;
        }
    }

    private final void updateLeafDataState(Material mat, BlockState b) {
        String string = mat.toString();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.String).toLowerCase()");
        if (StringsKt.contains$default((CharSequence)string3, "leaves", false, 2, null)) {
            BlockData blockData = b.getBlockData();
            if (blockData == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.bukkit.block.data.type.Leaves");
            }
            Leaves leafData = (Leaves)blockData;
            leafData.setPersistent(true);
            b.setBlockData((BlockData)leafData);
        }
    }

    private final void invalidMaterial(Material mat, Exception e, CommandSender currentPlayer) {
        AsyncManager.dropAsync();
        Material material = mat;
        Main.Companion.logError("Invalid block ID " + (material != null ? material.toString() : null) + " provided. The async queue has been dropped.", currentPlayer, e);
    }

    private SetBlock() {
    }

    static {
        SetBlock setBlock;
        INSTANCE = setBlock = new SetBlock();
    }
}

