/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.main;

import com._14ercooper.worldeditor.main.Main;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u0004R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/_14ercooper/worldeditor/main/NBTExtractor;", "", "()V", "versionId", "", "getVersionId", "()Ljava/lang/String;", "setVersionId", "(Ljava/lang/String;)V", "getNBT", "b", "Lorg/bukkit/block/Block;", "bs", "Lorg/bukkit/block/BlockState;", "getServerVersionId", "14erEdit"})
public final class NBTExtractor {
    @Nullable
    private String versionId;

    @NotNull
    public final String getNBT(@NotNull BlockState bs) {
        String string;
        Intrinsics.checkNotNullParameter(bs, "bs");
        String string2 = bs.getClass().getName();
        Intrinsics.checkNotNullExpressionValue(string2, "bs.javaClass.name");
        if (!StringsKt.endsWith$default(string2, "CraftBlockState", false, 2, null)) {
            String string3;
            String craftbukkitApiVer = this.getServerVersionId();
            String className = "org.bukkit.craftbukkit.v" + craftbukkitApiVer + ".block.CraftBlockEntityState";
            Class<?> clazz = Class.forName(className);
            Intrinsics.checkNotNullExpressionValue(clazz, "Class.forName(className)");
            Class<?> unsafeClass = clazz;
            Object cb = unsafeClass.cast(bs);
            Object ntc = unsafeClass.getMethod("getSnapshotNBT", new Class[0]).invoke(cb, new Object[0]);
            try {
                Object object = ntc.getClass().getMethod("asString", new Class[0]).invoke(ntc, new Object[0]);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                string3 = (String)object;
            }
            catch (Exception e) {
                Object object = ntc.getClass().getMethod("toString", new Class[0]).invoke(ntc, new Object[0]);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                string3 = (String)object;
            }
            string = string3;
        } else {
            string = "";
        }
        return string;
    }

    @Nullable
    public final String getVersionId() {
        return this.versionId;
    }

    public final void setVersionId(@Nullable String string) {
        this.versionId = string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getServerVersionId() {
        if (this.versionId != null) {
            String string = this.versionId;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            return string;
        }
        int n = 1;
        int n2 = 10;
        while (n <= n2) {
            void majorMajor;
            int n3 = 0;
            int n4 = 100;
            while (n3 <= n4) {
                void major;
                int n5 = 0;
                int n6 = 25;
                while (n5 <= n6) {
                    void minor;
                    boolean didCrash = false;
                    try {
                        this.versionId = "" + (int)majorMajor + '_' + (int)major + "_R" + (int)minor;
                        Class.forName("org.bukkit.craftbukkit.v" + this.versionId + ".block.CraftBlockEntityState");
                    }
                    catch (ClassNotFoundException e) {
                        didCrash = true;
                    }
                    if (!didCrash) {
                        String string = this.versionId;
                        if (string == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                        }
                        return string;
                    }
                    ++minor;
                }
                ++major;
            }
            ++majorMajor;
        }
        Main.Companion.logError("Could not load NBT class", (CommandSender)null, (Exception)null);
        return "";
    }

    @NotNull
    public final String getNBT(@NotNull Block b) {
        Intrinsics.checkNotNullParameter(b, "b");
        BlockState blockState = b.getState();
        Intrinsics.checkNotNullExpressionValue(blockState, "b.state");
        return this.getNBT(blockState);
    }
}

