/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.macros.macros.technical;

import com._14ercooper.worldeditor.macros.macros.Macro;
import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.main.SetBlock;
import com._14ercooper.worldeditor.operations.OperatorState;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LineBrushMacro
extends Macro {
    @Override
    public boolean performMacro(String[] args2, Location loc, OperatorState state) {
        Player p = (Player)state.getCurrentPlayer();
        Material m = Material.matchMaterial((String)args2[0]);
        if (m == null) {
            Main.logError("Could not parse line brush macro. " + args2[0] + " does not match a known block.", (CommandSender)p, null);
            return false;
        }
        int blockCount = 1000;
        if (args2.length > 1) {
            try {
                blockCount = Integer.parseInt(args2[1]);
            }
            catch (Exception e) {
                Main.logError("Could not parse line brush macro. " + args2[1] + " is not a valid number.", (CommandSender)p, e);
                return false;
            }
        }
        float startDist = 1.2f;
        if (args2.length > 1) {
            try {
                startDist = Float.parseFloat(args2[2]);
            }
            catch (Exception e) {
                Main.logError("Could not parse line brush macro. " + args2[2] + " is not a valid number.", (CommandSender)p, e);
                return false;
            }
        }
        Location start = p.getLocation().add(p.getLocation().getDirection().multiply(startDist));
        float xStart = (float)start.getX();
        float yStart = (float)(start.getY() + 1.0);
        float zStart = (float)start.getZ();
        float xStep = (xStart - (float)loc.getBlockX()) / (float)blockCount;
        float yStep = (yStart - (float)loc.getBlockY()) / (float)blockCount;
        float zStep = (zStart - (float)loc.getBlockZ()) / (float)blockCount;
        for (int t = 0; t < blockCount; ++t) {
            int xPos = (int)((double)((int)(xStart - xStep * (float)t)) + 0.5);
            int yPos = (int)((double)((int)(yStart - yStep * (float)t)) + 0.5);
            int zPos = (int)((double)((int)(zStart - zStep * (float)t)) + 0.5);
            Block b = state.getCurrentWorld().getBlockAt(xPos, yPos, zPos);
            SetBlock.setMaterial(b, m, state.getCurrentUndo(), state.getCurrentPlayer());
        }
        return true;
    }
}

