/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.macros.macros.technical;

import com._14ercooper.worldeditor.macros.macros.Macro;
import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.main.SetBlock;
import com._14ercooper.worldeditor.operations.OperatorState;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class CatenaryMacro
extends Macro {
    @Override
    public boolean performMacro(String[] args2, Location loc, OperatorState state) {
        try {
            double x0 = Double.parseDouble(args2[0]);
            double y0 = Double.parseDouble(args2[1]);
            double z0 = Double.parseDouble(args2[2]);
            double dx = Double.parseDouble(args2[3]);
            double dy = Double.parseDouble(args2[4]);
            double dy2 = Double.parseDouble(args2[5]);
            double dz = Double.parseDouble(args2[6]);
            double step = Double.parseDouble(args2[7]);
            String block = args2[8];
            Main.logDebug("Performing catenary with parameters: " + x0 + "," + x0 + "," + y0 + "," + z0 + "," + dx + "," + dy + "," + dy2 + "," + dz + "," + step + "," + block);
            Main.logDebug("" + (1.0 + step / 2.0));
            for (double t = 0.0; t < 1.0 + step / 2.0; t += step) {
                int x = (int)((double)((int)(x0 + t * dx)) + 0.5);
                int y = (int)((double)((int)(y0 + t * dy + t * t * dy2)) + 0.5);
                int z = (int)((double)((int)(z0 + t * dz)) + 0.5);
                Block b = state.getCurrentWorld().getBlockAt(x, y, z);
                SetBlock.setMaterial(b, Material.matchMaterial((String)block), state.getCurrentUndo(), state.getCurrentPlayer());
            }
        }
        catch (Exception e) {
            Main.logError("Could not parse catenary macro. Did you pass in the correct 8 numerical arguments and material?", state.getCurrentPlayer(), e);
            return false;
        }
        return true;
    }
}

