/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.macros.macros.nature;

import com._14ercooper.worldeditor.macros.macros.Macro;
import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.main.SetBlock;
import com._14ercooper.worldeditor.operations.OperatorState;
import java.util.ArrayList;
import java.util.LinkedList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;

public class VinesMacro
extends Macro {
    double radius = 0.0;
    double length = 0.0;
    double variance = 0.0;
    double density = 0.0;
    String block;
    Location pos;

    private void SetupMacro(String[] args2, Location loc, CommandSender player) {
        try {
            this.radius = Double.parseDouble(args2[0]);
            this.length = Double.parseDouble(args2[1]);
            this.variance = Double.parseDouble(args2[2]);
            this.density = Double.parseDouble(args2[3]);
            try {
                this.block = args2[4];
            }
            catch (Exception e) {
                this.block = "vine";
            }
        }
        catch (Exception e) {
            Main.logError("Error parsing vine macro. Did you pass in radius, length, variance, density, and optionally block material?", player, e);
        }
        try {
            Material m = Material.matchMaterial((String)this.block);
            if (m == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            Main.logError("Error parsing vine macro. " + this.block + " is not a valid block.", player, e);
        }
        this.pos = loc;
    }

    @Override
    public boolean performMacro(String[] args2, Location loc, OperatorState state) {
        Block b;
        this.SetupMacro(args2, loc, state.getCurrentPlayer());
        double x = this.pos.getX();
        double y = this.pos.getY();
        double z = this.pos.getZ();
        int radiusInt = (int)Math.round(this.radius);
        ArrayList<Block> blockArray = new ArrayList<Block>();
        for (int rx = -radiusInt; rx <= radiusInt; ++rx) {
            for (int rz = -radiusInt; rz <= radiusInt; ++rz) {
                for (int ry = -radiusInt; ry <= radiusInt; ++ry) {
                    if (!((double)(rx * rx + ry * ry + rz * rz) <= (this.radius + 0.5) * (this.radius + 0.5))) continue;
                    blockArray.add(state.getCurrentWorld().getBlockAt((int)x + rx, (int)y + ry, (int)z + rz));
                }
            }
        }
        Main.logDebug("Block array size: " + blockArray.size());
        ArrayList<BlockState> snapshotArray = new ArrayList<BlockState>();
        for (Block b2 : blockArray) {
            snapshotArray.add(b2.getState());
        }
        Main.logDebug(snapshotArray.size() + " blocks in snapshot array");
        LinkedList<BlockState> operatedBlocks = new LinkedList<BlockState>();
        ArrayList<Material> nonsolidBlocks = new ArrayList<Material>();
        nonsolidBlocks.add(Material.AIR);
        nonsolidBlocks.add(Material.VINE);
        for (BlockState bs : snapshotArray) {
            b = state.getCurrentWorld().getBlockAt(bs.getLocation());
            if (b.getType() != Material.AIR || b.getRelative(BlockFace.DOWN).getType() != Material.AIR || Main.getRand().nextDouble() >= this.density) continue;
            String blockStateTop = "[";
            String blockState = "";
            if (this.block.equalsIgnoreCase("vine")) {
                boolean firstState = true;
                ArrayList<String> dirs = new ArrayList<String>();
                if (!nonsolidBlocks.contains(b.getRelative(BlockFace.NORTH).getType())) {
                    if (firstState) {
                        firstState = false;
                    } else {
                        blockStateTop = blockStateTop.concat(",");
                    }
                    blockStateTop = blockStateTop.concat("north=true");
                    dirs.add("[north=true]");
                }
                if (!nonsolidBlocks.contains(b.getRelative(BlockFace.EAST).getType())) {
                    if (firstState) {
                        firstState = false;
                    } else {
                        blockStateTop = blockStateTop.concat(",");
                    }
                    blockStateTop = blockStateTop.concat("east=true");
                    dirs.add("[east=true]");
                }
                if (!nonsolidBlocks.contains(b.getRelative(BlockFace.SOUTH).getType())) {
                    if (firstState) {
                        firstState = false;
                    } else {
                        blockStateTop = blockStateTop.concat(",");
                    }
                    blockStateTop = blockStateTop.concat("south=true");
                    dirs.add("[south=true]");
                }
                if (!nonsolidBlocks.contains(b.getRelative(BlockFace.WEST).getType())) {
                    if (firstState) {
                        firstState = false;
                    } else {
                        blockStateTop = blockStateTop.concat(",");
                    }
                    blockStateTop = blockStateTop.concat("west=true");
                    dirs.add("[west=true]");
                }
                if (blockStateTop.equals("[")) continue;
                if (!nonsolidBlocks.contains(b.getRelative(BlockFace.UP).getType())) {
                    blockStateTop = blockStateTop.concat(",up=true");
                }
                blockState = dirs.size() > 1 ? (String)dirs.get(Main.getRand().nextInt(dirs.size() - 1)) : (String)dirs.get(0);
                if (!blockStateTop.equals("[")) {
                    blockStateTop = blockStateTop.concat("]");
                }
            }
            double actVariance = (Main.getRand().nextDouble() * 2.0 - 1.0) * this.variance;
            int vineLength = (int)Math.round(this.length + actVariance);
            BlockState stateBS = b.getState();
            stateBS.setType(Material.matchMaterial((String)this.block));
            if (this.block.equalsIgnoreCase("vine")) {
                stateBS.setBlockData(Bukkit.getServer().createBlockData("minecraft:vine" + blockState));
            }
            operatedBlocks.add(stateBS);
            for (int i = 1; i <= vineLength && (stateBS = b.getRelative(BlockFace.DOWN, i).getState()).getType() == Material.AIR; ++i) {
                stateBS.setType(Material.matchMaterial((String)this.block));
                if (this.block.equalsIgnoreCase("vine")) {
                    stateBS.setBlockData(Bukkit.getServer().createBlockData("minecraft:vine" + blockState));
                }
                operatedBlocks.add(stateBS);
            }
        }
        Main.logDebug("Operated on and now placing " + operatedBlocks.size() + " blocks");
        for (BlockState bs : operatedBlocks) {
            b = state.getCurrentWorld().getBlockAt(bs.getLocation());
            SetBlock.setMaterial(b, bs.getType(), bs.getBlockData(), state.getCurrentUndo(), state.getCurrentPlayer());
        }
        return true;
    }
}

