/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.macros.macros.nature;

import com._14ercooper.worldeditor.macros.macros.Macro;
import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.main.SetBlock;
import com._14ercooper.worldeditor.operations.OperatorState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.NotNull;

public class ErodeMacro
extends Macro {
    public int erodeRadius = -1;
    public int erodeType = -1;
    public int erodeSubtype = -1;
    public boolean targetAir = false;
    public Location erodeCenter;

    private void SetupMacro(String[] args2, Location loc, OperatorState state) {
        try {
            this.erodeRadius = Integer.parseInt(args2[0]);
        }
        catch (Exception e) {
            Main.logError("Could not parse erode macro. Is your radius a number?", state.getCurrentPlayer(), e);
        }
        this.erodeCenter = loc;
        try {
            if (args2[1].equalsIgnoreCase("melt")) {
                this.erodeType = 0;
            } else if (args2[1].equalsIgnoreCase("blend")) {
                this.erodeType = 1;
                this.erodeSubtype = Integer.parseInt(args2[2]);
                this.targetAir = Boolean.parseBoolean(args2[3]);
            } else if (args2[1].equalsIgnoreCase("mix")) {
                this.erodeType = 2;
            } else if (args2[1].equalsIgnoreCase("blockblend")) {
                this.erodeType = 3;
            }
            if (this.erodeType == 0) {
                if (args2[2].equalsIgnoreCase("cut")) {
                    this.erodeSubtype = 0;
                } else if (args2[2].equalsIgnoreCase("raise")) {
                    this.erodeSubtype = 1;
                } else if (args2[2].equalsIgnoreCase("smooth")) {
                    this.erodeSubtype = 2;
                } else if (args2[2].equalsIgnoreCase("lift")) {
                    this.erodeSubtype = 3;
                } else if (args2[2].equalsIgnoreCase("carve")) {
                    this.erodeSubtype = 4;
                }
            }
            if (this.erodeType == 2) {
                if (args2[2].equalsIgnoreCase("add")) {
                    this.erodeSubtype = 0;
                } else if (args2[2].equalsIgnoreCase("subtract")) {
                    this.erodeSubtype = 1;
                } else if (args2[2].equalsIgnoreCase("blend")) {
                    this.erodeSubtype = 2;
                }
            }
        }
        catch (Exception e) {
            Main.logError("Could not parse erode macro. Did you provide a valid mode?", state.getCurrentPlayer(), e);
        }
    }

    @Override
    public boolean performMacro(String[] args2, Location loc, OperatorState state) {
        this.SetupMacro(args2, loc, state);
        double x = this.erodeCenter.getX();
        double y = this.erodeCenter.getY();
        double z = this.erodeCenter.getZ();
        List<BlockState> snapshotArray = this.generateSnapshotArray(x, y, z, state);
        if (this.erodeType == 0 && this.erodeSubtype == 0) {
            snapshotArray = this.meltCutErosion(snapshotArray, state);
        }
        if (this.erodeType == 0 && this.erodeSubtype == 1) {
            snapshotArray = this.meltRaiseErosion(snapshotArray, state);
        }
        if (this.erodeType == 0 && this.erodeSubtype == 2) {
            snapshotArray = this.meltSmoothErosion(snapshotArray, state);
        }
        if (this.erodeType == 0 && this.erodeSubtype == 3) {
            snapshotArray = this.meltLiftErosion(snapshotArray, state);
        }
        if (this.erodeType == 0 && this.erodeSubtype == 4) {
            snapshotArray = this.meltCarveErosion(snapshotArray, state);
        }
        if (this.erodeType == 1) {
            snapshotArray = this.blendErode(snapshotArray, state);
        }
        if (this.erodeType == 2 && this.erodeSubtype == 0) {
            snapshotArray = this.mixErosionAdd(snapshotArray, x, y, z, state);
        }
        if (this.erodeType == 2 && this.erodeSubtype == 1) {
            snapshotArray = this.mixErosionSubtract(snapshotArray, x, y, z, state);
        }
        if (this.erodeType == 2 && this.erodeSubtype == 2) {
            snapshotArray = this.mixErosionBlend(snapshotArray, x, y, z, state);
        }
        if (this.erodeType == 3) {
            snapshotArray = this.blendBlockErode(snapshotArray, state);
        }
        this.applyToWorld(snapshotArray, state);
        return true;
    }

    private List<BlockState> blendBlockErode(List<BlockState> snapshotArray, OperatorState state) {
        Main.logDebug("Starting blend block erode");
        ArrayList<Material> blockMaterials = new ArrayList<Material>();
        for (BlockState bs : snapshotArray) {
            if (bs.getType() == Material.AIR) continue;
            blockMaterials.add(bs.getType());
        }
        Collections.shuffle(blockMaterials);
        int j = 0;
        for (BlockState blockState : snapshotArray) {
            if (blockState.getType() == Material.AIR) continue;
            blockState.setType((Material)blockMaterials.get(j));
            ++j;
        }
        return snapshotArray;
    }

    private List<BlockState> blendErode(List<BlockState> snapshotArray, OperatorState state) {
        Main.logDebug("Starting blend erode");
        ArrayList<BlockState> snapshotCopy = new ArrayList<BlockState>();
        for (BlockState b : snapshotArray) {
            if (b.getType() == Material.AIR && !this.targetAir) {
                snapshotCopy.add(b);
                continue;
            }
            if (Main.getRand().nextInt(100) >= this.erodeSubtype) {
                snapshotCopy.add(b);
                continue;
            }
            Block current = state.getCurrentWorld().getBlockAt(b.getLocation());
            ArrayList<Block> adjBlocks = new ArrayList<Block>();
            adjBlocks.add(current.getRelative(BlockFace.UP));
            adjBlocks.add(current.getRelative(BlockFace.DOWN));
            adjBlocks.add(current.getRelative(BlockFace.NORTH));
            adjBlocks.add(current.getRelative(BlockFace.SOUTH));
            adjBlocks.add(current.getRelative(BlockFace.EAST));
            adjBlocks.add(current.getRelative(BlockFace.WEST));
            BlockState setMat = ((Block)adjBlocks.get(Main.getRand().nextInt(adjBlocks.size()))).getState();
            b.setType(setMat.getType());
            b.setBlockData(setMat.getBlockData());
            snapshotCopy.add(b);
        }
        return snapshotCopy;
    }

    private List<BlockState> generateSnapshotArray(double x, double y, double z, OperatorState state) {
        ArrayList<Block> erosionArray = new ArrayList<Block>();
        for (int rx = -this.erodeRadius; rx <= this.erodeRadius; ++rx) {
            for (int rz = -this.erodeRadius; rz <= this.erodeRadius; ++rz) {
                for (int ry = -this.erodeRadius; ry <= this.erodeRadius; ++ry) {
                    if (!((double)(rx * rx + ry * ry + rz * rz) <= ((double)this.erodeRadius + 0.5) * ((double)this.erodeRadius + 0.5))) continue;
                    erosionArray.add(state.getCurrentWorld().getBlockAt((int)x + rx, (int)y + ry, (int)z + rz));
                }
            }
        }
        Main.logDebug("Erosion array size: " + erosionArray.size());
        ArrayList<BlockState> snapshotArray = new ArrayList<BlockState>();
        for (Block b : erosionArray) {
            snapshotArray.add(b.getState());
        }
        return snapshotArray;
    }

    private List<BlockState> mixErosionSubtract(List<BlockState> snapshotArray, double x, double y, double z, OperatorState state) {
        snapshotArray = this.meltCarveErosion(snapshotArray, state);
        this.applyToWorld(snapshotArray, state);
        snapshotArray = this.generateSnapshotArray(x, y, z, state);
        snapshotArray = this.meltCarveErosion(snapshotArray, state);
        this.applyToWorld(snapshotArray, state);
        snapshotArray = this.generateSnapshotArray(x, y, z, state);
        snapshotArray = this.meltRaiseErosion(snapshotArray, state);
        this.applyToWorld(snapshotArray, state);
        snapshotArray = this.generateSnapshotArray(x, y, z, state);
        snapshotArray = this.meltRaiseErosion(snapshotArray, state);
        this.applyToWorld(snapshotArray, state);
        snapshotArray = this.generateSnapshotArray(x, y, z, state);
        snapshotArray = this.meltSmoothErosion(snapshotArray, state);
        this.applyToWorld(snapshotArray, state);
        snapshotArray = this.generateSnapshotArray(x, y, z, state);
        snapshotArray = this.meltSmoothErosion(snapshotArray, state);
        return snapshotArray;
    }

    private List<BlockState> mixErosionBlend(List<BlockState> snapshotArray, double x, double y, double z, OperatorState state) {
        snapshotArray = this.meltCarveErosion(snapshotArray, state);
        this.applyToWorld(snapshotArray, state);
        snapshotArray = this.generateSnapshotArray(x, y, z, state);
        snapshotArray = this.meltRaiseErosion(snapshotArray, state);
        this.applyToWorld(snapshotArray, state);
        snapshotArray = this.generateSnapshotArray(x, y, z, state);
        snapshotArray = this.meltRaiseErosion(snapshotArray, state);
        this.applyToWorld(snapshotArray, state);
        snapshotArray = this.generateSnapshotArray(x, y, z, state);
        snapshotArray = this.meltSmoothErosion(snapshotArray, state);
        this.applyToWorld(snapshotArray, state);
        snapshotArray = this.generateSnapshotArray(x, y, z, state);
        snapshotArray = this.meltSmoothErosion(snapshotArray, state);
        return snapshotArray;
    }

    private List<BlockState> mixErosionAdd(List<BlockState> snapshotArray, double x, double y, double z, OperatorState state) {
        snapshotArray = this.meltRaiseErosion(snapshotArray, state);
        this.applyToWorld(snapshotArray, state);
        snapshotArray = this.generateSnapshotArray(x, y, z, state);
        snapshotArray = this.meltRaiseErosion(snapshotArray, state);
        this.applyToWorld(snapshotArray, state);
        snapshotArray = this.generateSnapshotArray(x, y, z, state);
        snapshotArray = this.meltSmoothErosion(snapshotArray, state);
        this.applyToWorld(snapshotArray, state);
        snapshotArray = this.generateSnapshotArray(x, y, z, state);
        snapshotArray = this.meltSmoothErosion(snapshotArray, state);
        return snapshotArray;
    }

    private void applyToWorld(List<BlockState> snapshotArray, OperatorState state) {
        for (BlockState b : snapshotArray) {
            Location l = b.getLocation();
            Block block = state.getCurrentWorld().getBlockAt(l);
            SetBlock.setMaterial(block, b.getType(), b.getBlockData(), state.getCurrentUndo(), state.getCurrentPlayer());
        }
    }

    private List<BlockState> meltSmoothErosion(List<BlockState> snapshotArray, OperatorState state) {
        Main.logDebug("Starting melt smooth erode");
        int airCut = 4;
        int solidCut = 4;
        return this.erodeSnapshotArray(snapshotArray, airCut, solidCut, state);
    }

    @NotNull
    private List<BlockState> erodeSnapshotArray(List<BlockState> snapshotArray, int airCut, int solidCut, OperatorState state) {
        ArrayList<BlockState> snapshotCopy = new ArrayList<BlockState>();
        for (BlockState b : snapshotArray) {
            Block current = state.getCurrentWorld().getBlockAt(b.getLocation());
            ArrayList<Block> adjBlocks = new ArrayList<Block>();
            adjBlocks.add(current.getRelative(BlockFace.UP));
            adjBlocks.add(current.getRelative(BlockFace.DOWN));
            adjBlocks.add(current.getRelative(BlockFace.NORTH));
            adjBlocks.add(current.getRelative(BlockFace.SOUTH));
            adjBlocks.add(current.getRelative(BlockFace.EAST));
            adjBlocks.add(current.getRelative(BlockFace.WEST));
            if (b.getType() != Material.AIR) {
                int airCount = 0;
                for (Block adjBlock : adjBlocks) {
                    if (adjBlock == null || adjBlock.getType() != Material.AIR) continue;
                    ++airCount;
                }
                if (airCount >= airCut) {
                    b.setType(Material.AIR);
                }
                snapshotCopy.add(b);
                continue;
            }
            int blockCount = 0;
            Material adjMaterial = Material.AIR;
            BlockData adjData = null;
            for (Block adjBlock : adjBlocks) {
                if (adjBlock == null || adjBlock.getType() == Material.AIR) continue;
                ++blockCount;
                adjMaterial = adjBlock.getType();
                adjData = adjBlock.getBlockData();
            }
            if (blockCount >= solidCut) {
                b.setType(adjMaterial);
                if (adjData != null) {
                    b.setBlockData(adjData);
                }
            }
            snapshotCopy.add(b);
        }
        return snapshotCopy;
    }

    private List<BlockState> meltRaiseErosion(List<BlockState> snapshotArray, OperatorState state) {
        Main.logDebug("Starting melt raise erode");
        int airCut = 4;
        int solidCut = 2;
        return this.erodeSnapshotArray(snapshotArray, airCut, solidCut, state);
    }

    private List<BlockState> meltLiftErosion(List<BlockState> snapshotArray, OperatorState state) {
        Main.logDebug("Starting melt lift erode");
        int airCut = 4;
        int solidCut = 1;
        return this.erodeSnapshotArray(snapshotArray, airCut, solidCut, state);
    }

    private List<BlockState> meltCutErosion(List<BlockState> snapshotArray, OperatorState state) {
        Main.logDebug("Starting melt cut erode");
        int airCut = 3;
        int solidCut = 4;
        return this.erodeSnapshotArray(snapshotArray, airCut, solidCut, state);
    }

    private List<BlockState> meltCarveErosion(List<BlockState> snapshotArray, OperatorState state) {
        Main.logDebug("Starting melt cut erode");
        int airCut = 1;
        int solidCut = 4;
        return this.erodeSnapshotArray(snapshotArray, airCut, solidCut, state);
    }
}

