/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.macros.macros.nature;

import com._14ercooper.worldeditor.macros.macros.Macro;
import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.operations.OperatorState;
import java.util.ArrayList;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;

public class BiomeMacro
extends Macro {
    double radius;
    Biome biome;
    Location pos;

    private void SetupMacro(String[] args2, Location loc, OperatorState state) {
        try {
            this.radius = Double.parseDouble(args2[0]);
        }
        catch (Exception e) {
            Main.logError("Could not parse biome macro. " + args2[0] + " is not a number.", state.getCurrentPlayer(), e);
        }
        try {
            this.biome = Biome.valueOf((String)args2[1].toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            Main.logError("Could not parse biome macro. " + args2[1] + " is not a known biome.", state.getCurrentPlayer(), e);
        }
        this.pos = loc;
    }

    @Override
    public boolean performMacro(String[] args2, Location loc, OperatorState state) {
        this.SetupMacro(args2, loc, state);
        double x = this.pos.getX();
        double z = this.pos.getZ();
        double y = this.pos.getY();
        int radiusInt = (int)Math.round(this.radius);
        ArrayList<Block> blockArray = new ArrayList<Block>();
        for (int rx = -radiusInt; rx <= radiusInt; ++rx) {
            for (int rz = -radiusInt; rz <= radiusInt; ++rz) {
                for (int ry = -radiusInt; ry < radiusInt; ++ry) {
                    if (!((double)(rx * rx + rz * rz + ry * ry) <= (this.radius + 0.5) * (this.radius + 0.5))) continue;
                    blockArray.add(state.getCurrentWorld().getBlockAt((int)x + rx, (int)y + ry, (int)z + rz));
                }
            }
        }
        Main.logDebug("Block array size: " + blockArray.size());
        ArrayList<BlockState> snapshotArray = new ArrayList<BlockState>();
        for (Block b : blockArray) {
            snapshotArray.add(b.getState());
        }
        Main.logDebug(snapshotArray.size() + " blocks in snapshot array");
        for (BlockState bs : snapshotArray) {
            state.getCurrentWorld().setBiome(bs.getX(), bs.getY(), bs.getZ(), this.biome);
        }
        return true;
    }
}

