/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.macros.macros.nature;

import com._14ercooper.worldeditor.macros.macros.Macro;
import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.main.SetBlock;
import com._14ercooper.worldeditor.operations.OperatorState;
import java.util.ArrayList;
import java.util.Iterator;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class BasicTreeMacro
extends Macro {
    public int type = -1;
    public int size;
    public int variance;
    public Material leaves;
    public Material trunk;
    public Location plantOn;

    private void SetupMacro(String[] args2, Location loc, OperatorState state) {
        this.plantOn = loc;
        try {
            this.size = Integer.parseInt(args2[3]);
            this.variance = (int)Math.ceil(Double.parseDouble(args2[4]));
            this.leaves = Material.matchMaterial((String)args2[1]);
            this.trunk = Material.matchMaterial((String)args2[2]);
        }
        catch (Exception e) {
            Main.logError("Could not parse tree macro. Did you provide all 4 arguments correctly?", state.getCurrentPlayer(), e);
        }
        if (args2[0].equalsIgnoreCase("oak")) {
            this.type = 1;
        }
        if (args2[0].equalsIgnoreCase("branch")) {
            this.type = 2;
        }
        if (args2[0].equalsIgnoreCase("big")) {
            this.type = 3;
        }
        if (args2[0].equalsIgnoreCase("bush")) {
            this.type = 4;
        }
        if (args2[0].equalsIgnoreCase("birch")) {
            this.type = 5;
        }
        if (args2[0].equalsIgnoreCase("darkoak")) {
            this.type = 6;
        }
        if (args2[0].equalsIgnoreCase("redmushroom")) {
            this.type = 7;
        }
        if (args2[0].equalsIgnoreCase("brownmushroom")) {
            this.type = 8;
        }
        if (args2[0].equalsIgnoreCase("jungle")) {
            this.type = 9;
        }
        if (this.type == -1) {
            Main.logError("Could not parse tree macro. Did you provide a valid tree type?", state.getCurrentPlayer(), null);
        }
    }

    @Override
    public boolean performMacro(String[] args2, Location loc, OperatorState state) {
        this.SetupMacro(args2, loc, state);
        if (this.type == 1) {
            this.oakTreeGenerator(state);
            return true;
        }
        if (this.type == 2) {
            this.branchTreeGenerator(state);
            return true;
        }
        if (this.type == 3) {
            this.bigTreeGenerator(state);
            return true;
        }
        if (this.type == 4) {
            this.bushTreeGenerator(state);
            return true;
        }
        if (this.type == 5) {
            this.birchTreeGenerator(state);
            return true;
        }
        if (this.type == 6) {
            this.darkOakTreeGenerator(state);
            return true;
        }
        if (this.type == 7) {
            this.redMushroomTreeGenerator(state);
            return true;
        }
        if (this.type == 8) {
            this.brownMushroomTreeGenerator(state);
            return true;
        }
        if (this.type == 9) {
            this.jungleTreeGenerator(state);
            return true;
        }
        Main.logError("Could not perform tree macro. An invalid tree type was given.", state.getCurrentPlayer(), null);
        return false;
    }

    private void jungleTreeGenerator(OperatorState state) {
        double actVariance = (Main.getRand().nextDouble() * 2.0 - 1.0) * (double)this.variance;
        double treeSize = (double)this.size + actVariance;
        double eTopX = treeSize * 0.9;
        double eTopY = eTopX * 0.5;
        double branchSize = treeSize * 0.35;
        double branchVariance = (double)this.variance * 0.35;
        double branchStartHeight = treeSize * 0.4;
        double branchFrequency = 270.0 / treeSize / (treeSize - branchStartHeight) * 0.5;
        double eBranchX = branchSize * 1.25;
        double eBranchY = eBranchX * 0.7;
        Block currentBlock = state.getCurrentWorld().getBlockAt(this.plantOn);
        ArrayList<Block> branchEnds = new ArrayList<Block>();
        ArrayList<Block> branchStarts = new ArrayList<Block>();
        ArrayList<Block> trunkBlocks = new ArrayList<Block>();
        ArrayList<Block> leafBlocks = new ArrayList<Block>();
        int i22 = 1;
        while (true) {
            double d = i22;
            double d2 = treeSize * 0.25 > 7.0 ? treeSize * 0.25 : 7.0;
            if (!(d <= treeSize + d2)) break;
            currentBlock = currentBlock.getRelative(BlockFace.UP);
            trunkBlocks.add(currentBlock);
            trunkBlocks.add(currentBlock.getRelative(BlockFace.NORTH));
            trunkBlocks.add(currentBlock.getRelative(BlockFace.EAST));
            trunkBlocks.add(currentBlock.getRelative(BlockFace.NORTH_EAST));
            if (Main.getRand().nextDouble() <= branchFrequency && (double)i22 >= branchStartHeight && (double)i22 <= treeSize) {
                branchStarts.add(currentBlock);
            }
            ++i22;
        }
        Block topBlock = currentBlock.getRelative(BlockFace.UP);
        Iterator i22 = branchStarts.iterator();
        while (i22.hasNext()) {
            BlockFace branchDir;
            Block b;
            currentBlock = b = (Block)i22.next();
            boolean firstBlock = true;
            double randNum = Main.getRand().nextDouble();
            if (randNum <= 0.25) {
                branchDir = BlockFace.NORTH;
                currentBlock = currentBlock.getRelative(BlockFace.NORTH, 2);
            } else if (randNum <= 0.5) {
                branchDir = BlockFace.EAST;
                currentBlock = currentBlock.getRelative(BlockFace.EAST, 2);
            } else if (randNum <= 0.75) {
                branchDir = BlockFace.SOUTH;
                currentBlock = currentBlock.getRelative(BlockFace.SOUTH);
            } else {
                branchDir = BlockFace.WEST;
                currentBlock = currentBlock.getRelative(BlockFace.WEST);
            }
            double branchLength = branchSize + (Main.getRand().nextDouble() * 2.0 - 1.0) * branchVariance;
            int i = 1;
            while ((double)i <= branchLength) {
                if (!firstBlock) {
                    currentBlock = currentBlock.getRelative(branchDir);
                    if (Main.getRand().nextDouble() <= 0.33) {
                        if (branchDir == BlockFace.NORTH || branchDir == BlockFace.SOUTH) {
                            currentBlock = Main.getRand().nextBoolean() ? currentBlock.getRelative(BlockFace.EAST) : currentBlock.getRelative(BlockFace.WEST);
                        }
                        if (branchDir == BlockFace.EAST || branchDir == BlockFace.WEST) {
                            currentBlock = Main.getRand().nextBoolean() ? currentBlock.getRelative(BlockFace.NORTH) : currentBlock.getRelative(BlockFace.SOUTH);
                        }
                    }
                    if (Main.getRand().nextDouble() <= 0.15) {
                        currentBlock = currentBlock.getRelative(BlockFace.UP);
                    }
                }
                trunkBlocks.add(currentBlock);
                firstBlock = false;
                ++i;
            }
            branchEnds.add(currentBlock.getRelative(BlockFace.UP));
        }
        int x = topBlock.getX();
        int y = topBlock.getY();
        int z = topBlock.getZ();
        for (double rx = -eTopX; rx <= eTopX; rx += 1.0) {
            for (double ry = -(eTopY / 3.0); ry <= eTopY; ry += 1.0) {
                for (double rz = -eTopX; rz <= eTopX; rz += 1.0) {
                    double ellipsoidValue = rx * rx / (eTopX * eTopX) + ry * ry / (eTopY * eTopY) + rz * rz / (eTopX * eTopX);
                    if (!(ellipsoidValue <= 1.15)) continue;
                    leafBlocks.add(state.getCurrentWorld().getBlockAt((int)((double)x + rx), (int)((double)y + ry), (int)((double)z + rz)));
                }
            }
        }
        for (Block b : branchEnds) {
            x = b.getX();
            y = b.getY();
            z = b.getZ();
            for (double rx = -eBranchX; rx <= eBranchX; rx += 1.0) {
                for (double ry = -(eBranchY / 3.0); ry <= eBranchY / 2.0; ry += 1.0) {
                    for (double rz = -eBranchX; rz <= eBranchX; rz += 1.0) {
                        double ellipsoidValue = rx * rx / (eBranchX * eBranchX) + ry * ry / (eBranchY * eBranchY) + rz * rz / (eBranchX * eBranchX);
                        if (!(ellipsoidValue <= 1.15)) continue;
                        leafBlocks.add(state.getCurrentWorld().getBlockAt((int)((double)x + rx), (int)((double)y + ry), (int)((double)z + rz)));
                    }
                }
            }
        }
        for (Block b : trunkBlocks) {
            if (b.getType() != Material.AIR) continue;
            SetBlock.setMaterial(b, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
        }
        for (Block b : leafBlocks) {
            if (b.getType() != Material.AIR) continue;
            SetBlock.setMaterial(b, this.leaves, state.getCurrentUndo(), state.getCurrentPlayer());
        }
    }

    private void brownMushroomTreeGenerator(OperatorState state) {
        int rz;
        double cap3Cut;
        double cap2Cut;
        double cap1Cut;
        int numCaps;
        double actVariance = (Main.getRand().nextDouble() * 2.0 - 1.0) * (double)this.variance;
        double treeSize = (double)this.size + actVariance;
        Main.logDebug("Generating mushroom of size " + treeSize);
        if (treeSize > 60.0) {
            Main.logDebug("5 cap mushroom");
            numCaps = 5;
        } else if (treeSize > 40.0) {
            Main.logDebug("4 cap mushroom");
            numCaps = 4;
        } else if (treeSize > 27.0) {
            Main.logDebug("3 cap mushroom");
            numCaps = 3;
        } else if (treeSize > 15.0) {
            Main.logDebug("2 cap mushroom");
            numCaps = 2;
        } else {
            Main.logDebug("1 cap mushroom");
            numCaps = 1;
        }
        double radiusCorrection = 0.35;
        double cap4Cut = 0.0;
        double cap5Cut = 0.0;
        if (numCaps <= 3) {
            Main.logDebug("Less than or equal to 3 caps will be generated");
            cap1Cut = treeSize * 0.35;
            cap2Cut = treeSize * 0.65;
            cap3Cut = treeSize;
        } else {
            Main.logDebug("More than 3 caps will be generated");
            cap1Cut = treeSize * 0.25;
            cap2Cut = treeSize * 0.4;
            cap3Cut = treeSize * 0.55;
            cap4Cut = treeSize * 0.7;
            cap5Cut = treeSize * 0.85;
        }
        Main.logDebug("Generating mushroom stem");
        Block currentBlock = state.getCurrentWorld().getBlockAt(this.plantOn);
        BlockFace currentDirection = BlockFace.DOWN;
        int i = 1;
        while ((double)i <= treeSize) {
            double randNum = Main.getRand().nextDouble();
            if (randNum <= 0.333) {
                randNum = Main.getRand().nextDouble();
                if (randNum <= 0.125 || currentDirection == BlockFace.DOWN) {
                    randNum = Main.getRand().nextDouble();
                    currentDirection = randNum <= 0.125 ? BlockFace.NORTH : (randNum <= 0.25 ? BlockFace.NORTH_EAST : (randNum <= 0.375 ? BlockFace.EAST : (randNum <= 0.5 ? BlockFace.SOUTH_EAST : (randNum <= 0.625 ? BlockFace.SOUTH : (randNum <= 0.75 ? BlockFace.SOUTH_WEST : (randNum <= 0.875 ? BlockFace.WEST : BlockFace.NORTH_WEST))))));
                }
                currentBlock = currentBlock.getRelative(currentDirection);
            }
            if ((currentBlock = currentBlock.getRelative(BlockFace.UP)).getType() == Material.AIR) {
                SetBlock.setMaterial(currentBlock, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
            }
            ++i;
        }
        currentBlock = currentBlock.getRelative(BlockFace.UP);
        double x = currentBlock.getX();
        double y = currentBlock.getY();
        double z = currentBlock.getZ();
        Main.logDebug("Generating cap at (" + x + "," + y + "," + z + ")");
        ArrayList<Block> capBlocks = new ArrayList<Block>();
        Main.logDebug("Size 1 cap generating");
        for (double rx = -cap1Cut; rx <= cap1Cut; rx += 1.0) {
            for (double rz2 = -cap1Cut; rz2 <= cap1Cut; rz2 += 1.0) {
                if (!(rx * rx + rz2 * rz2 <= (cap1Cut + radiusCorrection) * (cap1Cut + radiusCorrection))) continue;
                capBlocks.add(state.getCurrentWorld().getBlockAt((int)(x + rx), (int)y, (int)(z + rz2)));
            }
        }
        Main.logDebug("Number of blocks: " + capBlocks.size());
        if (numCaps >= 2) {
            Main.logDebug("Size 2 cap generating");
            int rx = -((int)cap2Cut);
            while ((double)rx <= cap2Cut) {
                rz = -((int)cap2Cut);
                while ((double)rz <= cap2Cut) {
                    if ((double)(rx * rx + rz * rz) <= (cap2Cut + radiusCorrection) * (cap2Cut + radiusCorrection) && (double)(rx * rx + rz * rz) >= (cap1Cut - radiusCorrection) * (cap1Cut - radiusCorrection)) {
                        capBlocks.add(state.getCurrentWorld().getBlockAt((int)(x + (double)rx), (int)(y - 1.0), (int)(z + (double)rz)));
                    }
                    ++rz;
                }
                ++rx;
            }
            Main.logDebug("Number of blocks: " + capBlocks.size());
        }
        if (numCaps >= 3) {
            Main.logDebug("Size 3 cap generating");
            int rx = -((int)cap3Cut);
            while ((double)rx <= cap3Cut) {
                rz = -((int)cap3Cut);
                while ((double)rz <= cap3Cut) {
                    if ((double)(rx * rx + rz * rz) <= (cap3Cut + radiusCorrection) * (cap3Cut + radiusCorrection) && (double)(rx * rx + rz * rz) >= (cap2Cut - radiusCorrection) * (cap2Cut - radiusCorrection)) {
                        capBlocks.add(state.getCurrentWorld().getBlockAt((int)(x + (double)rx), (int)(y - 2.0), (int)(z + (double)rz)));
                    }
                    ++rz;
                }
                ++rx;
            }
            Main.logDebug("Number of blocks: " + capBlocks.size());
        }
        if (numCaps >= 4) {
            Main.logDebug("Size 4 cap generating");
            int rx = -((int)cap4Cut);
            while ((double)rx <= cap4Cut) {
                rz = -((int)cap4Cut);
                while ((double)rz <= cap4Cut) {
                    if ((double)(rx * rx + rz * rz) <= (cap4Cut + radiusCorrection) * (cap4Cut + radiusCorrection) && (double)(rx * rx + rz * rz) >= (cap3Cut - radiusCorrection) * (cap3Cut - radiusCorrection)) {
                        capBlocks.add(state.getCurrentWorld().getBlockAt((int)(x + (double)rx), (int)(y - 3.0), (int)(z + (double)rz)));
                    }
                    ++rz;
                }
                ++rx;
            }
            Main.logDebug("Number of blocks: " + capBlocks.size());
        }
        if (numCaps >= 5) {
            Main.logDebug("Size 5 cap generating");
            int rx = -((int)cap5Cut);
            while ((double)rx <= cap5Cut) {
                rz = -((int)cap5Cut);
                while ((double)rz <= cap5Cut) {
                    if ((double)(rx * rx + rz * rz) <= (cap5Cut + radiusCorrection) * (cap5Cut + radiusCorrection) && (double)(rx * rx + rz * rz) >= (cap4Cut - radiusCorrection) * (cap4Cut - radiusCorrection)) {
                        capBlocks.add(state.getCurrentWorld().getBlockAt((int)(x + (double)rx), (int)(y - 2.0), (int)(z + (double)rz)));
                    }
                    ++rz;
                }
                ++rx;
            }
            Main.logDebug("Number of blocks: " + capBlocks.size());
        }
        Main.logDebug("Placing cap blocks");
        for (Block bl : capBlocks) {
            if (bl.getType() != Material.AIR) continue;
            SetBlock.setMaterial(bl, this.leaves, state.getCurrentUndo(), state.getCurrentPlayer());
        }
    }

    private void redMushroomTreeGenerator(OperatorState state) {
        double actVariance = (Main.getRand().nextDouble() * 2.0 - 1.0) * (double)this.variance;
        double treeSize = (double)this.size + actVariance;
        Block currentBlock = state.getCurrentWorld().getBlockAt(this.plantOn);
        BlockFace currentDirection = BlockFace.DOWN;
        int i = 1;
        while ((double)i <= treeSize) {
            double randNum = Main.getRand().nextDouble();
            if (randNum <= 0.25) {
                randNum = Main.getRand().nextDouble();
                if (randNum <= 0.25 || currentDirection == BlockFace.DOWN) {
                    randNum = Main.getRand().nextDouble();
                    currentDirection = randNum <= 0.125 ? BlockFace.NORTH : (randNum <= 0.25 ? BlockFace.NORTH_EAST : (randNum <= 0.375 ? BlockFace.EAST : (randNum <= 0.5 ? BlockFace.SOUTH_EAST : (randNum <= 0.625 ? BlockFace.SOUTH : (randNum <= 0.75 ? BlockFace.SOUTH_WEST : (randNum <= 0.875 ? BlockFace.WEST : BlockFace.NORTH_WEST))))));
                }
                currentBlock = currentBlock.getRelative(currentDirection);
            }
            if ((currentBlock = currentBlock.getRelative(BlockFace.UP)).getType() == Material.AIR) {
                SetBlock.setMaterial(currentBlock, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
            }
            ++i;
        }
        ArrayList<Block> leafList = new ArrayList<Block>();
        leafList.add(currentBlock.getRelative(BlockFace.UP));
        leafList.add(currentBlock.getRelative(BlockFace.UP).getRelative(BlockFace.NORTH));
        leafList.add(currentBlock.getRelative(BlockFace.UP).getRelative(BlockFace.NORTH_EAST));
        leafList.add(currentBlock.getRelative(BlockFace.UP).getRelative(BlockFace.EAST));
        leafList.add(currentBlock.getRelative(BlockFace.UP).getRelative(BlockFace.SOUTH_EAST));
        leafList.add(currentBlock.getRelative(BlockFace.UP).getRelative(BlockFace.SOUTH));
        leafList.add(currentBlock.getRelative(BlockFace.UP).getRelative(BlockFace.SOUTH_WEST));
        leafList.add(currentBlock.getRelative(BlockFace.UP).getRelative(BlockFace.WEST));
        leafList.add(currentBlock.getRelative(BlockFace.UP).getRelative(BlockFace.NORTH_WEST));
        leafList.add(currentBlock.getRelative(BlockFace.NORTH, 2));
        leafList.add(currentBlock.getRelative(BlockFace.EAST, 2));
        leafList.add(currentBlock.getRelative(BlockFace.SOUTH, 2));
        leafList.add(currentBlock.getRelative(BlockFace.WEST, 2));
        leafList.add(currentBlock.getRelative(BlockFace.NORTH_EAST).getRelative(BlockFace.NORTH));
        leafList.add(currentBlock.getRelative(BlockFace.NORTH_EAST).getRelative(BlockFace.EAST));
        leafList.add(currentBlock.getRelative(BlockFace.SOUTH_EAST).getRelative(BlockFace.SOUTH));
        leafList.add(currentBlock.getRelative(BlockFace.SOUTH_EAST).getRelative(BlockFace.EAST));
        leafList.add(currentBlock.getRelative(BlockFace.NORTH_WEST).getRelative(BlockFace.NORTH));
        leafList.add(currentBlock.getRelative(BlockFace.NORTH_WEST).getRelative(BlockFace.WEST));
        leafList.add(currentBlock.getRelative(BlockFace.SOUTH_WEST).getRelative(BlockFace.SOUTH));
        leafList.add(currentBlock.getRelative(BlockFace.SOUTH_WEST).getRelative(BlockFace.WEST));
        double numCapDrops = treeSize * 0.333 > 2.0 ? treeSize * 0.333 : 2.0;
        int j = 1;
        while ((double)j <= numCapDrops) {
            leafList.add(currentBlock.getRelative(BlockFace.NORTH, 2).getRelative(BlockFace.DOWN, j));
            leafList.add(currentBlock.getRelative(BlockFace.EAST, 2).getRelative(BlockFace.DOWN, j));
            leafList.add(currentBlock.getRelative(BlockFace.SOUTH, 2).getRelative(BlockFace.DOWN, j));
            leafList.add(currentBlock.getRelative(BlockFace.WEST, 2).getRelative(BlockFace.DOWN, j));
            leafList.add(currentBlock.getRelative(BlockFace.NORTH_EAST).getRelative(BlockFace.NORTH).getRelative(BlockFace.DOWN, j));
            leafList.add(currentBlock.getRelative(BlockFace.NORTH_EAST).getRelative(BlockFace.EAST).getRelative(BlockFace.DOWN, j));
            leafList.add(currentBlock.getRelative(BlockFace.SOUTH_EAST).getRelative(BlockFace.SOUTH).getRelative(BlockFace.DOWN, j));
            leafList.add(currentBlock.getRelative(BlockFace.SOUTH_EAST).getRelative(BlockFace.EAST).getRelative(BlockFace.DOWN, j));
            leafList.add(currentBlock.getRelative(BlockFace.NORTH_WEST).getRelative(BlockFace.NORTH).getRelative(BlockFace.DOWN, j));
            leafList.add(currentBlock.getRelative(BlockFace.NORTH_WEST).getRelative(BlockFace.WEST).getRelative(BlockFace.DOWN, j));
            leafList.add(currentBlock.getRelative(BlockFace.SOUTH_WEST).getRelative(BlockFace.SOUTH).getRelative(BlockFace.DOWN, j));
            leafList.add(currentBlock.getRelative(BlockFace.SOUTH_WEST).getRelative(BlockFace.WEST).getRelative(BlockFace.DOWN, j));
            ++j;
        }
        for (Block b : leafList) {
            if (b.getType() != Material.AIR) continue;
            SetBlock.setMaterial(b, this.leaves, state.getCurrentUndo(), state.getCurrentPlayer());
        }
    }

    private void darkOakTreeGenerator(OperatorState state) {
        double curveGap;
        int trunkSize;
        double actVariance = (Main.getRand().nextDouble() * 2.0 - 1.0) * (double)this.variance;
        double treeSize = (double)this.size + actVariance;
        Block currentBlock = state.getCurrentWorld().getBlockAt(this.plantOn);
        double randNum = Main.getRand().nextDouble();
        BlockFace curveDirection = randNum <= 0.125 ? BlockFace.NORTH : (randNum <= 0.25 ? BlockFace.NORTH_EAST : (randNum <= 0.375 ? BlockFace.EAST : (randNum <= 0.5 ? BlockFace.SOUTH_EAST : (randNum <= 0.625 ? BlockFace.SOUTH : (randNum <= 0.75 ? BlockFace.SOUTH_WEST : (randNum <= 0.875 ? BlockFace.WEST : BlockFace.NORTH_WEST))))));
        if (treeSize > 23.0) {
            trunkSize = 3;
            curveGap = treeSize * 0.5 / 7.0;
        } else if (treeSize > 12.0) {
            trunkSize = 2;
            curveGap = treeSize * 0.5 / 3.0;
        } else {
            trunkSize = 2;
            curveGap = treeSize * 0.5 / 2.0;
        }
        double curveCut = 0.0;
        int i = 0;
        while ((double)i <= treeSize) {
            boolean doCurve = false;
            if ((double)i >= treeSize * 0.5) {
                if (curveCut >= curveGap) {
                    doCurve = true;
                    curveCut -= curveGap;
                }
                curveCut += 1.0;
            }
            currentBlock = doCurve ? currentBlock.getRelative(BlockFace.UP).getRelative(curveDirection) : currentBlock.getRelative(BlockFace.UP);
            ArrayList<Block> blockList = new ArrayList<Block>();
            if (trunkSize == 2) {
                blockList.add(currentBlock);
                blockList.add(currentBlock.getRelative(BlockFace.NORTH));
                blockList.add(currentBlock.getRelative(BlockFace.EAST));
                blockList.add(currentBlock.getRelative(BlockFace.NORTH_EAST));
            }
            if (trunkSize == 3) {
                blockList.add(currentBlock);
                blockList.add(currentBlock.getRelative(BlockFace.NORTH));
                blockList.add(currentBlock.getRelative(BlockFace.EAST));
                blockList.add(currentBlock.getRelative(BlockFace.NORTH_EAST));
                blockList.add(currentBlock.getRelative(BlockFace.NORTH, 2));
                blockList.add(currentBlock.getRelative(BlockFace.EAST, 2));
                blockList.add(currentBlock.getRelative(BlockFace.NORTH_EAST, 2));
                blockList.add(currentBlock.getRelative(BlockFace.NORTH_EAST).getRelative(BlockFace.NORTH));
                blockList.add(currentBlock.getRelative(BlockFace.NORTH_EAST).getRelative(BlockFace.EAST));
            }
            for (Block b : blockList) {
                if (b.getType() != Material.AIR) continue;
                SetBlock.setMaterial(b, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
            }
            ++i;
        }
        double eX = treeSize * 0.75;
        double eY = eX * 0.42;
        int x = currentBlock.getX();
        int y = currentBlock.getY();
        int z = currentBlock.getZ();
        for (double rx = -eX; rx <= eX; rx += 1.0) {
            for (double ry = -(eY / 3.0); ry <= eY; ry += 1.0) {
                for (double rz = -eX; rz <= eX; rz += 1.0) {
                    Block toPlace;
                    double ellipsoidValue = rx * rx / (eX * eX) + ry * ry / (eY * eY) + rz * rz / (eX * eX);
                    if (!(ellipsoidValue <= 1.15) || (toPlace = state.getCurrentWorld().getBlockAt((int)((double)x + rx), (int)((double)y + ry), (int)((double)z + rz))).getType() != Material.AIR) continue;
                    SetBlock.setMaterial(toPlace, this.leaves, state.getCurrentUndo(), state.getCurrentPlayer());
                }
            }
        }
    }

    private void birchTreeGenerator(OperatorState state) {
        double actVariance = (Main.getRand().nextDouble() * 2.0 - 1.0) * (double)this.variance;
        double treeSize = (double)this.size + actVariance;
        Block currentBlock = state.getCurrentWorld().getBlockAt(this.plantOn);
        int i = 1;
        while ((double)i <= treeSize) {
            if ((currentBlock = currentBlock.getRelative(BlockFace.UP)).getType() == Material.AIR) {
                SetBlock.setMaterial(currentBlock, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
            }
            ++i;
        }
        ArrayList<Block> leafList = new ArrayList<Block>();
        leafList.add(currentBlock.getRelative(BlockFace.UP));
        leafList.add(currentBlock.getRelative(BlockFace.UP).getRelative(BlockFace.NORTH));
        leafList.add(currentBlock.getRelative(BlockFace.UP).getRelative(BlockFace.SOUTH));
        leafList.add(currentBlock.getRelative(BlockFace.UP).getRelative(BlockFace.EAST));
        leafList.add(currentBlock.getRelative(BlockFace.UP).getRelative(BlockFace.WEST));
        leafList.add(currentBlock.getRelative(BlockFace.NORTH));
        leafList.add(currentBlock.getRelative(BlockFace.SOUTH));
        leafList.add(currentBlock.getRelative(BlockFace.EAST));
        leafList.add(currentBlock.getRelative(BlockFace.WEST));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.NORTH));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.SOUTH));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.EAST));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.WEST));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.NORTH).getRelative(BlockFace.DOWN));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.SOUTH).getRelative(BlockFace.DOWN));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.EAST).getRelative(BlockFace.DOWN));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.WEST).getRelative(BlockFace.DOWN));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.NORTH).getRelative(BlockFace.EAST));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.SOUTH).getRelative(BlockFace.EAST));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.EAST).getRelative(BlockFace.NORTH));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.WEST).getRelative(BlockFace.NORTH));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.NORTH).getRelative(BlockFace.WEST));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.SOUTH).getRelative(BlockFace.WEST));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.EAST).getRelative(BlockFace.SOUTH));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.WEST).getRelative(BlockFace.SOUTH));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.NORTH).getRelative(BlockFace.DOWN).getRelative(BlockFace.EAST));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.SOUTH).getRelative(BlockFace.DOWN).getRelative(BlockFace.EAST));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.EAST).getRelative(BlockFace.DOWN).getRelative(BlockFace.NORTH));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.WEST).getRelative(BlockFace.DOWN).getRelative(BlockFace.NORTH));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.NORTH).getRelative(BlockFace.DOWN).getRelative(BlockFace.WEST));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.SOUTH).getRelative(BlockFace.DOWN).getRelative(BlockFace.WEST));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.EAST).getRelative(BlockFace.DOWN).getRelative(BlockFace.SOUTH));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.WEST).getRelative(BlockFace.DOWN).getRelative(BlockFace.SOUTH));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.NORTH).getRelative(BlockFace.EAST).getRelative(BlockFace.NORTH));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.SOUTH).getRelative(BlockFace.EAST).getRelative(BlockFace.SOUTH));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.EAST).getRelative(BlockFace.NORTH).getRelative(BlockFace.EAST));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.WEST).getRelative(BlockFace.NORTH).getRelative(BlockFace.WEST));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.NORTH).getRelative(BlockFace.WEST).getRelative(BlockFace.NORTH));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.SOUTH).getRelative(BlockFace.WEST).getRelative(BlockFace.SOUTH));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.EAST).getRelative(BlockFace.SOUTH).getRelative(BlockFace.EAST));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.WEST).getRelative(BlockFace.SOUTH).getRelative(BlockFace.WEST));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.NORTH).getRelative(BlockFace.DOWN).getRelative(BlockFace.EAST).getRelative(BlockFace.NORTH));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.SOUTH).getRelative(BlockFace.DOWN).getRelative(BlockFace.EAST).getRelative(BlockFace.SOUTH));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.EAST).getRelative(BlockFace.DOWN).getRelative(BlockFace.NORTH).getRelative(BlockFace.EAST));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.WEST).getRelative(BlockFace.DOWN).getRelative(BlockFace.NORTH).getRelative(BlockFace.WEST));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.NORTH).getRelative(BlockFace.DOWN).getRelative(BlockFace.WEST).getRelative(BlockFace.NORTH));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.SOUTH).getRelative(BlockFace.DOWN).getRelative(BlockFace.WEST).getRelative(BlockFace.SOUTH));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.EAST).getRelative(BlockFace.DOWN).getRelative(BlockFace.SOUTH).getRelative(BlockFace.EAST));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.WEST).getRelative(BlockFace.DOWN).getRelative(BlockFace.SOUTH).getRelative(BlockFace.WEST));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN, 2).getRelative(BlockFace.NORTH, 2));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN, 2).getRelative(BlockFace.EAST, 2));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN, 2).getRelative(BlockFace.SOUTH, 2));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN, 2).getRelative(BlockFace.WEST, 2));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.NORTH, 2));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.EAST, 2));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.SOUTH, 2));
        leafList.add(currentBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.WEST, 2));
        if (Main.getRand().nextBoolean()) {
            leafList.add(currentBlock.getRelative(BlockFace.NORTH).getRelative(BlockFace.EAST));
        }
        if (Main.getRand().nextBoolean()) {
            leafList.add(currentBlock.getRelative(BlockFace.NORTH).getRelative(BlockFace.WEST));
        }
        if (Main.getRand().nextBoolean()) {
            leafList.add(currentBlock.getRelative(BlockFace.SOUTH).getRelative(BlockFace.EAST));
        }
        if (Main.getRand().nextBoolean()) {
            leafList.add(currentBlock.getRelative(BlockFace.SOUTH).getRelative(BlockFace.WEST));
        }
        if (Main.getRand().nextBoolean()) {
            leafList.add(currentBlock.getRelative(BlockFace.DOWN, 2).getRelative(BlockFace.NORTH, 2).getRelative(BlockFace.EAST, 2));
        }
        if (Main.getRand().nextBoolean()) {
            leafList.add(currentBlock.getRelative(BlockFace.DOWN, 2).getRelative(BlockFace.NORTH, 2).getRelative(BlockFace.WEST, 2));
        }
        if (Main.getRand().nextBoolean()) {
            leafList.add(currentBlock.getRelative(BlockFace.DOWN, 2).getRelative(BlockFace.SOUTH, 2).getRelative(BlockFace.EAST, 2));
        }
        if (Main.getRand().nextBoolean()) {
            leafList.add(currentBlock.getRelative(BlockFace.DOWN, 2).getRelative(BlockFace.SOUTH, 2).getRelative(BlockFace.WEST, 2));
        }
        for (Block b : leafList) {
            if (b.getType() != Material.AIR) continue;
            SetBlock.setMaterial(b, this.leaves, state.getCurrentUndo(), state.getCurrentPlayer());
        }
    }

    private void bushTreeGenerator(OperatorState state) {
        Block baseBlock = state.getCurrentWorld().getBlockAt(this.plantOn).getRelative(BlockFace.UP);
        if (baseBlock.getType() == Material.AIR) {
            SetBlock.setMaterial(baseBlock, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
        }
        double actVariance = (Main.getRand().nextDouble() * 2.0 - 1.0) * (double)this.variance;
        double bushSize = (double)this.size + actVariance;
        double eX = bushSize * 0.55;
        double eY = eX * 0.333;
        int x = baseBlock.getX();
        int y = baseBlock.getY();
        int z = baseBlock.getZ();
        for (double rx = -eX; rx <= eX; rx += 1.0) {
            for (double ry = -eY; ry <= eY; ry += 1.0) {
                for (double rz = -eX; rz <= eX; rz += 1.0) {
                    double ellipsoidValue = rx * rx / (eX * eX) + ry * ry / (eY * eY) + rz * rz / (eX * eX);
                    if (!(ellipsoidValue <= 1.15)) continue;
                    Block toPlace = state.getCurrentWorld().getBlockAt((int)((double)x + rx), (int)((double)y + ry), (int)((double)z + rz));
                    if (1.0 - ellipsoidValue * 0.869565217 < Main.getRand().nextDouble() * 0.5 || toPlace.getType() != Material.AIR) continue;
                    SetBlock.setMaterial(toPlace, this.leaves, state.getCurrentUndo(), state.getCurrentPlayer());
                }
            }
        }
    }

    private void bigTreeGenerator(OperatorState state) {
        int baseSize;
        int numSplits;
        double actVariance = (Main.getRand().nextDouble() * 2.0 - 1.0) * (double)this.variance;
        double treeHeight = (double)this.size + actVariance;
        if (treeHeight <= 15.0) {
            numSplits = 1;
            baseSize = 3;
        } else if (treeHeight <= 30.0) {
            numSplits = 2;
            baseSize = 6;
        } else if (treeHeight <= 60.0) {
            numSplits = 3;
            baseSize = 18;
        } else if (treeHeight <= 90.0) {
            numSplits = 4;
            baseSize = 36;
        } else {
            numSplits = 5;
            baseSize = 108;
        }
        double leafBallSize = treeHeight * 0.56 + 1.3;
        double startBranchThickness = baseSize;
        double nextBranchThickness = baseSize;
        ArrayList<Location> branchStarts = new ArrayList<Location>();
        branchStarts.add(state.getCurrentWorld().getBlockAt(this.plantOn).getRelative(BlockFace.UP).getLocation());
        double branchHeight = treeHeight;
        for (int i = 1; i <= numSplits + 1; ++i) {
            Block b;
            int rz;
            int z;
            int y;
            int x;
            double thicknessSquared;
            int j;
            Block currentBlock;
            Main.logDebug("i value of " + i);
            ArrayList<Location> theseBranches = branchStarts;
            branchStarts = new ArrayList();
            branchHeight = numSplits == 1 ? (branchHeight *= 0.75) : (numSplits == 2 ? (branchHeight *= 0.6666) : (numSplits == 3 ? (branchHeight *= 0.59) : (numSplits == 4 ? (branchHeight *= 0.54) : (branchHeight *= 0.5))));
            nextBranchThickness = i % 2 == 0 ? (nextBranchThickness /= 3.0) : (nextBranchThickness /= 2.0);
            double branchTaper = (startBranchThickness - nextBranchThickness) / branchHeight;
            double branchThickness = startBranchThickness;
            if (i == 1) {
                Main.logDebug("First branch growing, number of locations equals " + theseBranches.size());
                for (Location startLoc : theseBranches) {
                    currentBlock = state.getCurrentWorld().getBlockAt(startLoc);
                    j = 1;
                    while ((double)j <= branchHeight) {
                        double randNum;
                        branchThickness -= branchTaper;
                        if (currentBlock.getType() == Material.AIR) {
                            SetBlock.setMaterial(currentBlock, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                        }
                        thicknessSquared = (branchThickness + 0.5) * (branchThickness + 0.5);
                        x = currentBlock.getX();
                        y = currentBlock.getY();
                        z = currentBlock.getZ();
                        int rx = -((int)branchThickness);
                        while ((double)rx <= branchThickness) {
                            rz = -((int)branchThickness);
                            while ((double)rz <= branchThickness) {
                                if ((double)(rx * rx + rz * rz) <= thicknessSquared && (b = state.getCurrentWorld().getBlockAt(x + rx, y, z + rz)).getType() == Material.AIR) {
                                    SetBlock.setMaterial(b, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                                }
                                ++rz;
                            }
                            ++rx;
                        }
                        currentBlock = Main.getRand().nextDouble() <= 0.2 ? ((randNum = Main.getRand().nextDouble()) <= 0.125 ? currentBlock.getRelative(BlockFace.UP).getRelative(BlockFace.NORTH) : (randNum <= 0.25 ? currentBlock.getRelative(BlockFace.UP).getRelative(BlockFace.NORTH_EAST) : (randNum <= 0.375 ? currentBlock.getRelative(BlockFace.UP).getRelative(BlockFace.EAST) : (randNum <= 0.5 ? currentBlock.getRelative(BlockFace.UP).getRelative(BlockFace.SOUTH_EAST) : (randNum <= 0.625 ? currentBlock.getRelative(BlockFace.UP).getRelative(BlockFace.SOUTH) : (randNum <= 0.75 ? currentBlock.getRelative(BlockFace.UP).getRelative(BlockFace.SOUTH_WEST) : (randNum <= 0.875 ? currentBlock.getRelative(BlockFace.UP).getRelative(BlockFace.WEST) : currentBlock.getRelative(BlockFace.UP).getRelative(BlockFace.NORTH_WEST)))))))) : currentBlock.getRelative(BlockFace.UP);
                        ++j;
                    }
                    branchStarts.add(currentBlock.getLocation());
                }
            } else if (i % 2 == 1) {
                Main.logDebug("Even branch growing, number of locations " + theseBranches.size());
                for (Location startLoc : theseBranches) {
                    int rx;
                    if (Main.getRand().nextBoolean()) {
                        currentBlock = state.getCurrentWorld().getBlockAt(startLoc);
                        j = 1;
                        while ((double)j <= branchHeight) {
                            branchThickness -= branchTaper;
                            if (currentBlock.getType() == Material.AIR) {
                                SetBlock.setMaterial(currentBlock, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                            }
                            thicknessSquared = (branchThickness + 0.5) * (branchThickness + 0.5);
                            x = currentBlock.getX();
                            y = currentBlock.getY();
                            z = currentBlock.getZ();
                            rx = -((int)branchThickness);
                            while ((double)rx <= branchThickness) {
                                rz = -((int)branchThickness);
                                while ((double)rz <= branchThickness) {
                                    if ((double)(rx * rx + rz * rz) <= thicknessSquared && (b = state.getCurrentWorld().getBlockAt(x + rx, y, z + rz)).getType() == Material.AIR) {
                                        SetBlock.setMaterial(b, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                                    }
                                    ++rz;
                                }
                                ++rx;
                            }
                            currentBlock = Main.getRand().nextDouble() <= 0.2 ? (Main.getRand().nextBoolean() ? currentBlock.getRelative(BlockFace.NORTH).getRelative(BlockFace.UP).getRelative(BlockFace.EAST) : currentBlock.getRelative(BlockFace.NORTH).getRelative(BlockFace.UP).getRelative(BlockFace.WEST)) : currentBlock.getRelative(BlockFace.NORTH).getRelative(BlockFace.UP);
                            ++j;
                        }
                        branchStarts.add(currentBlock.getLocation());
                        currentBlock = state.getCurrentWorld().getBlockAt(startLoc);
                        branchThickness = startBranchThickness;
                        j = 1;
                        while ((double)j <= branchHeight) {
                            branchThickness -= branchTaper;
                            if (currentBlock.getType() == Material.AIR) {
                                SetBlock.setMaterial(currentBlock, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                            }
                            thicknessSquared = (branchThickness + 0.5) * (branchThickness + 0.5);
                            x = currentBlock.getX();
                            y = currentBlock.getY();
                            z = currentBlock.getZ();
                            rx = -((int)branchThickness);
                            while ((double)rx <= branchThickness) {
                                rz = -((int)branchThickness);
                                while ((double)rz <= branchThickness) {
                                    if ((double)(rx * rx + rz * rz) <= thicknessSquared && (b = state.getCurrentWorld().getBlockAt(x + rx, y, z + rz)).getType() == Material.AIR) {
                                        SetBlock.setMaterial(b, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                                    }
                                    ++rz;
                                }
                                ++rx;
                            }
                            currentBlock = Main.getRand().nextDouble() <= 0.2 ? (Main.getRand().nextBoolean() ? currentBlock.getRelative(BlockFace.SOUTH).getRelative(BlockFace.UP).getRelative(BlockFace.EAST) : currentBlock.getRelative(BlockFace.SOUTH).getRelative(BlockFace.UP).getRelative(BlockFace.WEST)) : currentBlock.getRelative(BlockFace.SOUTH).getRelative(BlockFace.UP);
                            ++j;
                        }
                        branchStarts.add(currentBlock.getLocation());
                        continue;
                    }
                    currentBlock = state.getCurrentWorld().getBlockAt(startLoc);
                    j = 1;
                    while ((double)j <= branchHeight) {
                        branchThickness -= branchTaper;
                        if (currentBlock.getType() == Material.AIR) {
                            SetBlock.setMaterial(currentBlock, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                        }
                        thicknessSquared = (branchThickness + 0.5) * (branchThickness + 0.5);
                        x = currentBlock.getX();
                        y = currentBlock.getY();
                        z = currentBlock.getZ();
                        rx = -((int)branchThickness);
                        while ((double)rx <= branchThickness) {
                            rz = -((int)branchThickness);
                            while ((double)rz <= branchThickness) {
                                if ((double)(rx * rx + rz * rz) <= thicknessSquared && (b = state.getCurrentWorld().getBlockAt(x + rx, y, z + rz)).getType() == Material.AIR) {
                                    SetBlock.setMaterial(b, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                                }
                                ++rz;
                            }
                            ++rx;
                        }
                        currentBlock = Main.getRand().nextDouble() <= 0.2 ? (Main.getRand().nextBoolean() ? currentBlock.getRelative(BlockFace.EAST).getRelative(BlockFace.UP).getRelative(BlockFace.NORTH) : currentBlock.getRelative(BlockFace.EAST).getRelative(BlockFace.UP).getRelative(BlockFace.SOUTH)) : currentBlock.getRelative(BlockFace.EAST).getRelative(BlockFace.UP);
                        ++j;
                    }
                    branchStarts.add(currentBlock.getLocation());
                    currentBlock = state.getCurrentWorld().getBlockAt(startLoc);
                    branchThickness = startBranchThickness;
                    j = 1;
                    while ((double)j <= branchHeight) {
                        branchThickness -= branchTaper;
                        if (currentBlock.getType() == Material.AIR) {
                            SetBlock.setMaterial(currentBlock, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                        }
                        thicknessSquared = (branchThickness + 0.5) * (branchThickness + 0.5);
                        x = currentBlock.getX();
                        y = currentBlock.getY();
                        z = currentBlock.getZ();
                        rx = -((int)branchThickness);
                        while ((double)rx <= branchThickness) {
                            rz = -((int)branchThickness);
                            while ((double)rz <= branchThickness) {
                                if ((double)(rx * rx + rz * rz) <= thicknessSquared && (b = state.getCurrentWorld().getBlockAt(x + rx, y, z + rz)).getType() == Material.AIR) {
                                    SetBlock.setMaterial(b, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                                }
                                ++rz;
                            }
                            ++rx;
                        }
                        currentBlock = Main.getRand().nextDouble() <= 0.2 ? (Main.getRand().nextBoolean() ? currentBlock.getRelative(BlockFace.WEST).getRelative(BlockFace.UP).getRelative(BlockFace.NORTH) : currentBlock.getRelative(BlockFace.WEST).getRelative(BlockFace.UP).getRelative(BlockFace.SOUTH)) : currentBlock.getRelative(BlockFace.WEST).getRelative(BlockFace.UP);
                        ++j;
                    }
                    branchStarts.add(currentBlock.getLocation());
                }
            } else if (i % 2 == 0) {
                Main.logDebug("Odd branch growing, number of locations " + theseBranches.size());
                for (Location startLoc : theseBranches) {
                    int rx;
                    if (Main.getRand().nextBoolean()) {
                        if (Main.getRand().nextBoolean()) {
                            currentBlock = state.getCurrentWorld().getBlockAt(startLoc);
                            j = 1;
                            while ((double)j <= branchHeight) {
                                branchThickness -= branchTaper;
                                if (currentBlock.getType() == Material.AIR) {
                                    SetBlock.setMaterial(currentBlock, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                                }
                                thicknessSquared = (branchThickness + 0.5) * (branchThickness + 0.5);
                                x = currentBlock.getX();
                                y = currentBlock.getY();
                                z = currentBlock.getZ();
                                rx = -((int)branchThickness);
                                while ((double)rx <= branchThickness) {
                                    rz = -((int)branchThickness);
                                    while ((double)rz <= branchThickness) {
                                        if ((double)(rx * rx + rz * rz) <= thicknessSquared && (b = state.getCurrentWorld().getBlockAt(x + rx, y, z + rz)).getType() == Material.AIR) {
                                            SetBlock.setMaterial(b, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                                        }
                                        ++rz;
                                    }
                                    ++rx;
                                }
                                currentBlock = Main.getRand().nextDouble() <= 0.2 ? (Main.getRand().nextBoolean() ? currentBlock.getRelative(BlockFace.NORTH).getRelative(BlockFace.UP).getRelative(BlockFace.EAST) : currentBlock.getRelative(BlockFace.NORTH).getRelative(BlockFace.UP).getRelative(BlockFace.WEST)) : currentBlock.getRelative(BlockFace.NORTH).getRelative(BlockFace.UP);
                                ++j;
                            }
                            branchStarts.add(currentBlock.getLocation());
                            currentBlock = state.getCurrentWorld().getBlockAt(startLoc);
                            branchThickness = startBranchThickness;
                            j = 1;
                            while ((double)j <= branchHeight) {
                                branchThickness -= branchTaper;
                                if (currentBlock.getType() == Material.AIR) {
                                    SetBlock.setMaterial(currentBlock, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                                }
                                thicknessSquared = (branchThickness + 0.5) * (branchThickness + 0.5);
                                x = currentBlock.getX();
                                y = currentBlock.getY();
                                z = currentBlock.getZ();
                                rx = -((int)branchThickness);
                                while ((double)rx <= branchThickness) {
                                    rz = -((int)branchThickness);
                                    while ((double)rz <= branchThickness) {
                                        if ((double)(rx * rx + rz * rz) <= thicknessSquared && (b = state.getCurrentWorld().getBlockAt(x + rx, y, z + rz)).getType() == Material.AIR) {
                                            SetBlock.setMaterial(b, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                                        }
                                        ++rz;
                                    }
                                    ++rx;
                                }
                                currentBlock = Main.getRand().nextDouble() <= 0.2 ? (Main.getRand().nextBoolean() ? currentBlock.getRelative(BlockFace.SOUTH_EAST).getRelative(BlockFace.UP).getRelative(BlockFace.NORTH_EAST) : currentBlock.getRelative(BlockFace.SOUTH_EAST).getRelative(BlockFace.UP).getRelative(BlockFace.SOUTH_WEST)) : currentBlock.getRelative(BlockFace.SOUTH_EAST).getRelative(BlockFace.UP);
                                ++j;
                            }
                            branchStarts.add(currentBlock.getLocation());
                            currentBlock = state.getCurrentWorld().getBlockAt(startLoc);
                            branchThickness = startBranchThickness;
                            j = 1;
                            while ((double)j <= branchHeight) {
                                branchThickness -= branchTaper;
                                if (currentBlock.getType() == Material.AIR) {
                                    SetBlock.setMaterial(currentBlock, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                                }
                                thicknessSquared = (branchThickness + 0.5) * (branchThickness + 0.5);
                                x = currentBlock.getX();
                                y = currentBlock.getY();
                                z = currentBlock.getZ();
                                rx = -((int)branchThickness);
                                while ((double)rx <= branchThickness) {
                                    rz = -((int)branchThickness);
                                    while ((double)rz <= branchThickness) {
                                        if ((double)(rx * rx + rz * rz) <= thicknessSquared && (b = state.getCurrentWorld().getBlockAt(x + rx, y, z + rz)).getType() == Material.AIR) {
                                            SetBlock.setMaterial(b, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                                        }
                                        ++rz;
                                    }
                                    ++rx;
                                }
                                currentBlock = Main.getRand().nextDouble() <= 0.2 ? (Main.getRand().nextBoolean() ? currentBlock.getRelative(BlockFace.SOUTH_WEST).getRelative(BlockFace.UP).getRelative(BlockFace.SOUTH_EAST) : currentBlock.getRelative(BlockFace.SOUTH_WEST).getRelative(BlockFace.UP).getRelative(BlockFace.NORTH_WEST)) : currentBlock.getRelative(BlockFace.SOUTH_WEST).getRelative(BlockFace.UP);
                                ++j;
                            }
                            branchStarts.add(currentBlock.getLocation());
                            continue;
                        }
                        currentBlock = state.getCurrentWorld().getBlockAt(startLoc);
                        j = 1;
                        while ((double)j <= branchHeight) {
                            branchThickness -= branchTaper;
                            if (currentBlock.getType() == Material.AIR) {
                                SetBlock.setMaterial(currentBlock, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                            }
                            thicknessSquared = (branchThickness + 0.5) * (branchThickness + 0.5);
                            x = currentBlock.getX();
                            y = currentBlock.getY();
                            z = currentBlock.getZ();
                            rx = -((int)branchThickness);
                            while ((double)rx <= branchThickness) {
                                rz = -((int)branchThickness);
                                while ((double)rz <= branchThickness) {
                                    if ((double)(rx * rx + rz * rz) <= thicknessSquared && (b = state.getCurrentWorld().getBlockAt(x + rx, y, z + rz)).getType() == Material.AIR) {
                                        SetBlock.setMaterial(b, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                                    }
                                    ++rz;
                                }
                                ++rx;
                            }
                            currentBlock = Main.getRand().nextDouble() <= 0.2 ? (Main.getRand().nextBoolean() ? currentBlock.getRelative(BlockFace.SOUTH).getRelative(BlockFace.UP).getRelative(BlockFace.EAST) : currentBlock.getRelative(BlockFace.SOUTH).getRelative(BlockFace.UP).getRelative(BlockFace.WEST)) : currentBlock.getRelative(BlockFace.SOUTH).getRelative(BlockFace.UP);
                            ++j;
                        }
                        branchStarts.add(currentBlock.getLocation());
                        currentBlock = state.getCurrentWorld().getBlockAt(startLoc);
                        branchThickness = startBranchThickness;
                        j = 1;
                        while ((double)j <= branchHeight) {
                            branchThickness -= branchTaper;
                            if (currentBlock.getType() == Material.AIR) {
                                SetBlock.setMaterial(currentBlock, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                            }
                            thicknessSquared = (branchThickness + 0.5) * (branchThickness + 0.5);
                            x = currentBlock.getX();
                            y = currentBlock.getY();
                            z = currentBlock.getZ();
                            rx = -((int)branchThickness);
                            while ((double)rx <= branchThickness) {
                                rz = -((int)branchThickness);
                                while ((double)rz <= branchThickness) {
                                    if ((double)(rx * rx + rz * rz) <= thicknessSquared && (b = state.getCurrentWorld().getBlockAt(x + rx, y, z + rz)).getType() == Material.AIR) {
                                        SetBlock.setMaterial(b, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                                    }
                                    ++rz;
                                }
                                ++rx;
                            }
                            currentBlock = Main.getRand().nextDouble() <= 0.2 ? (Main.getRand().nextBoolean() ? currentBlock.getRelative(BlockFace.NORTH_EAST).getRelative(BlockFace.UP).getRelative(BlockFace.SOUTH_EAST) : currentBlock.getRelative(BlockFace.NORTH_EAST).getRelative(BlockFace.UP).getRelative(BlockFace.NORTH_WEST)) : currentBlock.getRelative(BlockFace.NORTH_EAST).getRelative(BlockFace.UP);
                            ++j;
                        }
                        branchStarts.add(currentBlock.getLocation());
                        currentBlock = state.getCurrentWorld().getBlockAt(startLoc);
                        branchThickness = startBranchThickness;
                        j = 1;
                        while ((double)j <= branchHeight) {
                            branchThickness -= branchTaper;
                            if (currentBlock.getType() == Material.AIR) {
                                SetBlock.setMaterial(currentBlock, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                            }
                            thicknessSquared = (branchThickness + 0.5) * (branchThickness + 0.5);
                            x = currentBlock.getX();
                            y = currentBlock.getY();
                            z = currentBlock.getZ();
                            rx = -((int)branchThickness);
                            while ((double)rx <= branchThickness) {
                                rz = -((int)branchThickness);
                                while ((double)rz <= branchThickness) {
                                    if ((double)(rx * rx + rz * rz) <= thicknessSquared && (b = state.getCurrentWorld().getBlockAt(x + rx, y, z + rz)).getType() == Material.AIR) {
                                        SetBlock.setMaterial(b, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                                    }
                                    ++rz;
                                }
                                ++rx;
                            }
                            currentBlock = Main.getRand().nextDouble() <= 0.2 ? (Main.getRand().nextBoolean() ? currentBlock.getRelative(BlockFace.NORTH_WEST).getRelative(BlockFace.UP).getRelative(BlockFace.NORTH_EAST) : currentBlock.getRelative(BlockFace.NORTH_WEST).getRelative(BlockFace.UP).getRelative(BlockFace.SOUTH_WEST)) : currentBlock.getRelative(BlockFace.NORTH_WEST).getRelative(BlockFace.UP);
                            ++j;
                        }
                        branchStarts.add(currentBlock.getLocation());
                        continue;
                    }
                    if (Main.getRand().nextBoolean()) {
                        currentBlock = state.getCurrentWorld().getBlockAt(startLoc);
                        j = 1;
                        while ((double)j <= branchHeight) {
                            branchThickness -= branchTaper;
                            if (currentBlock.getType() == Material.AIR) {
                                SetBlock.setMaterial(currentBlock, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                            }
                            thicknessSquared = (branchThickness + 0.5) * (branchThickness + 0.5);
                            x = currentBlock.getX();
                            y = currentBlock.getY();
                            z = currentBlock.getZ();
                            rx = -((int)branchThickness);
                            while ((double)rx <= branchThickness) {
                                rz = -((int)branchThickness);
                                while ((double)rz <= branchThickness) {
                                    if ((double)(rx * rx + rz * rz) <= thicknessSquared && (b = state.getCurrentWorld().getBlockAt(x + rx, y, z + rz)).getType() == Material.AIR) {
                                        SetBlock.setMaterial(b, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                                    }
                                    ++rz;
                                }
                                ++rx;
                            }
                            currentBlock = Main.getRand().nextDouble() <= 0.2 ? (Main.getRand().nextBoolean() ? currentBlock.getRelative(BlockFace.EAST).getRelative(BlockFace.UP).getRelative(BlockFace.NORTH) : currentBlock.getRelative(BlockFace.EAST).getRelative(BlockFace.UP).getRelative(BlockFace.SOUTH)) : currentBlock.getRelative(BlockFace.EAST).getRelative(BlockFace.UP);
                            ++j;
                        }
                        branchStarts.add(currentBlock.getLocation());
                        currentBlock = state.getCurrentWorld().getBlockAt(startLoc);
                        branchThickness = startBranchThickness;
                        j = 1;
                        while ((double)j <= branchHeight) {
                            branchThickness -= branchTaper;
                            if (currentBlock.getType() == Material.AIR) {
                                SetBlock.setMaterial(currentBlock, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                            }
                            thicknessSquared = (branchThickness + 0.5) * (branchThickness + 0.5);
                            x = currentBlock.getX();
                            y = currentBlock.getY();
                            z = currentBlock.getZ();
                            rx = -((int)branchThickness);
                            while ((double)rx <= branchThickness) {
                                rz = -((int)branchThickness);
                                while ((double)rz <= branchThickness) {
                                    if ((double)(rx * rx + rz * rz) <= thicknessSquared && (b = state.getCurrentWorld().getBlockAt(x + rx, y, z + rz)).getType() == Material.AIR) {
                                        SetBlock.setMaterial(b, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                                    }
                                    ++rz;
                                }
                                ++rx;
                            }
                            currentBlock = Main.getRand().nextDouble() <= 0.2 ? (Main.getRand().nextBoolean() ? currentBlock.getRelative(BlockFace.NORTH_WEST).getRelative(BlockFace.UP).getRelative(BlockFace.NORTH_EAST) : currentBlock.getRelative(BlockFace.NORTH_WEST).getRelative(BlockFace.UP).getRelative(BlockFace.SOUTH_WEST)) : currentBlock.getRelative(BlockFace.NORTH_WEST).getRelative(BlockFace.UP);
                            ++j;
                        }
                        branchStarts.add(currentBlock.getLocation());
                        currentBlock = state.getCurrentWorld().getBlockAt(startLoc);
                        branchThickness = startBranchThickness;
                        j = 1;
                        while ((double)j <= branchHeight) {
                            branchThickness -= branchTaper;
                            if (currentBlock.getType() == Material.AIR) {
                                SetBlock.setMaterial(currentBlock, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                            }
                            thicknessSquared = (branchThickness + 0.5) * (branchThickness + 0.5);
                            x = currentBlock.getX();
                            y = currentBlock.getY();
                            z = currentBlock.getZ();
                            rx = -((int)branchThickness);
                            while ((double)rx <= branchThickness) {
                                rz = -((int)branchThickness);
                                while ((double)rz <= branchThickness) {
                                    if ((double)(rx * rx + rz * rz) <= thicknessSquared && (b = state.getCurrentWorld().getBlockAt(x + rx, y, z + rz)).getType() == Material.AIR) {
                                        SetBlock.setMaterial(b, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                                    }
                                    ++rz;
                                }
                                ++rx;
                            }
                            currentBlock = Main.getRand().nextDouble() <= 0.2 ? (Main.getRand().nextBoolean() ? currentBlock.getRelative(BlockFace.SOUTH_WEST).getRelative(BlockFace.UP).getRelative(BlockFace.SOUTH_EAST) : currentBlock.getRelative(BlockFace.SOUTH_WEST).getRelative(BlockFace.UP).getRelative(BlockFace.NORTH_WEST)) : currentBlock.getRelative(BlockFace.SOUTH_WEST).getRelative(BlockFace.UP);
                            ++j;
                        }
                        branchStarts.add(currentBlock.getLocation());
                        continue;
                    }
                    currentBlock = state.getCurrentWorld().getBlockAt(startLoc);
                    j = 1;
                    while ((double)j <= branchHeight) {
                        branchThickness -= branchTaper;
                        if (currentBlock.getType() == Material.AIR) {
                            SetBlock.setMaterial(currentBlock, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                        }
                        thicknessSquared = (branchThickness + 0.5) * (branchThickness + 0.5);
                        x = currentBlock.getX();
                        y = currentBlock.getY();
                        z = currentBlock.getZ();
                        rx = -((int)branchThickness);
                        while ((double)rx <= branchThickness) {
                            rz = -((int)branchThickness);
                            while ((double)rz <= branchThickness) {
                                if ((double)(rx * rx + rz * rz) <= thicknessSquared && (b = state.getCurrentWorld().getBlockAt(x + rx, y, z + rz)).getType() == Material.AIR) {
                                    SetBlock.setMaterial(b, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                                }
                                ++rz;
                            }
                            ++rx;
                        }
                        currentBlock = Main.getRand().nextDouble() <= 0.2 ? (Main.getRand().nextBoolean() ? currentBlock.getRelative(BlockFace.WEST).getRelative(BlockFace.UP).getRelative(BlockFace.NORTH) : currentBlock.getRelative(BlockFace.WEST).getRelative(BlockFace.UP).getRelative(BlockFace.SOUTH)) : currentBlock.getRelative(BlockFace.WEST).getRelative(BlockFace.UP);
                        ++j;
                    }
                    branchStarts.add(currentBlock.getLocation());
                    currentBlock = state.getCurrentWorld().getBlockAt(startLoc);
                    branchThickness = startBranchThickness;
                    j = 1;
                    while ((double)j <= branchHeight) {
                        branchThickness -= branchTaper;
                        if (currentBlock.getType() == Material.AIR) {
                            SetBlock.setMaterial(currentBlock, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                        }
                        thicknessSquared = (branchThickness + 0.5) * (branchThickness + 0.5);
                        x = currentBlock.getX();
                        y = currentBlock.getY();
                        z = currentBlock.getZ();
                        rx = -((int)branchThickness);
                        while ((double)rx <= branchThickness) {
                            rz = -((int)branchThickness);
                            while ((double)rz <= branchThickness) {
                                if ((double)(rx * rx + rz * rz) <= thicknessSquared && (b = state.getCurrentWorld().getBlockAt(x + rx, y, z + rz)).getType() == Material.AIR) {
                                    SetBlock.setMaterial(b, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                                }
                                ++rz;
                            }
                            ++rx;
                        }
                        currentBlock = Main.getRand().nextDouble() <= 0.2 ? (Main.getRand().nextBoolean() ? currentBlock.getRelative(BlockFace.NORTH_EAST).getRelative(BlockFace.UP).getRelative(BlockFace.SOUTH_EAST) : currentBlock.getRelative(BlockFace.NORTH_EAST).getRelative(BlockFace.UP).getRelative(BlockFace.NORTH_WEST)) : currentBlock.getRelative(BlockFace.NORTH_EAST).getRelative(BlockFace.UP);
                        ++j;
                    }
                    branchStarts.add(currentBlock.getLocation());
                    currentBlock = state.getCurrentWorld().getBlockAt(startLoc);
                    branchThickness = startBranchThickness;
                    j = 1;
                    while ((double)j <= branchHeight) {
                        branchThickness -= branchTaper;
                        if (currentBlock.getType() == Material.AIR) {
                            SetBlock.setMaterial(currentBlock, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                        }
                        thicknessSquared = (branchThickness + 0.5) * (branchThickness + 0.5);
                        x = currentBlock.getX();
                        y = currentBlock.getY();
                        z = currentBlock.getZ();
                        rx = -((int)branchThickness);
                        while ((double)rx <= branchThickness) {
                            rz = -((int)branchThickness);
                            while ((double)rz <= branchThickness) {
                                if ((double)(rx * rx + rz * rz) <= thicknessSquared && (b = state.getCurrentWorld().getBlockAt(x + rx, y, z + rz)).getType() == Material.AIR) {
                                    SetBlock.setMaterial(b, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                                }
                                ++rz;
                            }
                            ++rx;
                        }
                        currentBlock = Main.getRand().nextDouble() <= 0.2 ? (Main.getRand().nextBoolean() ? currentBlock.getRelative(BlockFace.SOUTH_EAST).getRelative(BlockFace.UP).getRelative(BlockFace.NORTH_EAST) : currentBlock.getRelative(BlockFace.SOUTH_EAST).getRelative(BlockFace.UP).getRelative(BlockFace.SOUTH_WEST)) : currentBlock.getRelative(BlockFace.SOUTH_EAST).getRelative(BlockFace.UP);
                        ++j;
                    }
                    branchStarts.add(currentBlock.getLocation());
                }
            }
            startBranchThickness = nextBranchThickness;
        }
        ArrayList<Location> endPoints = branchStarts;
        Main.logDebug("Generating leaf spheres");
        for (Location startLoc : endPoints) {
            double invLeafBallSize = 1.0 / leafBallSize;
            int x = startLoc.getBlockX();
            int y = startLoc.getBlockY();
            int z = startLoc.getBlockZ();
            for (int rx = -((int)leafBallSize); rx <= (int)leafBallSize; ++rx) {
                for (int ry = -((int)leafBallSize); ry <= (int)leafBallSize; ++ry) {
                    for (int rz = -((int)leafBallSize); rz <= (int)leafBallSize; ++rz) {
                        Block toSet;
                        double distFromCenter = Math.sqrt(rx * rx + ry * ry + rz * rz);
                        if (!(distFromCenter <= leafBallSize) || 1.0 - distFromCenter * invLeafBallSize < Main.getRand().nextDouble() * 0.333 || (toSet = state.getCurrentWorld().getBlockAt(x + rx, y + ry, z + rz)).getType() != Material.AIR) continue;
                        SetBlock.setMaterial(toSet, this.leaves, state.getCurrentUndo(), state.getCurrentPlayer());
                    }
                }
            }
        }
    }

    private void branchTreeGenerator(OperatorState state) {
        Block toSet;
        double distFromCenter;
        int rz;
        int ry;
        int rx;
        int z;
        int y;
        double invLeafBallSize;
        int i;
        BlockFace dir;
        double randNum;
        double actVariance = (Main.getRand().nextDouble() * 2.0 - 1.0) * (double)this.variance;
        double branchSize1 = (double)this.size + actVariance;
        double leafSize1 = branchSize1 * 0.461235 + 1.35425;
        double branchSize2 = branchSize1 * (0.8 * Main.getRand().nextDouble());
        double leafSize2 = branchSize2 * 0.411235 + 1.35425;
        double branchSize3 = branchSize2 * (0.8 * Main.getRand().nextDouble());
        double leafSize3 = branchSize3 * 0.361235 + 1.35425;
        double branch2StartDensity = 0.4;
        double branch3StartDensity = 0.7;
        double branch2StartOffset = branchSize1 * 0.5;
        double branch3StartOffset = branchSize2 * 0.5;
        ArrayList<Location> branch1Ends = new ArrayList<Location>();
        ArrayList<Location> branch2Ends = new ArrayList<Location>();
        ArrayList<Location> branch3Ends = new ArrayList<Location>();
        ArrayList<Location> branch2Starts = new ArrayList<Location>();
        ArrayList<Location> branch3Starts = new ArrayList<Location>();
        Block currentBlock = state.getCurrentWorld().getBlockAt(this.plantOn);
        int i2 = 1;
        while ((double)i2 < branchSize1) {
            currentBlock = currentBlock.getRelative(BlockFace.UP);
            if ((double)i2 >= branch2StartOffset && Main.getRand().nextDouble() <= branch2StartDensity) {
                branch2Starts.add(currentBlock.getLocation());
            }
            if (currentBlock.getType() == Material.AIR) {
                SetBlock.setMaterial(currentBlock, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
            }
            ++i2;
        }
        branch1Ends.add(currentBlock.getLocation());
        for (Location l : branch2Starts) {
            currentBlock = state.getCurrentWorld().getBlockAt(l);
            randNum = Main.getRand().nextDouble();
            dir = randNum <= 0.25 ? BlockFace.NORTH : (randNum <= 0.5 ? BlockFace.EAST : (randNum <= 0.75 ? BlockFace.SOUTH : BlockFace.WEST));
            i = 1;
            while ((double)i < branchSize2) {
                if (Main.getRand().nextDouble() <= 0.2) {
                    randNum = Main.getRand().nextDouble();
                    dir = randNum <= 0.1666 ? BlockFace.NORTH : (randNum <= 0.3333 ? BlockFace.EAST : (randNum <= 0.5 ? BlockFace.SOUTH : (randNum <= 0.6666 ? BlockFace.WEST : (randNum <= 0.8333 ? BlockFace.UP : BlockFace.DOWN))));
                }
                currentBlock = currentBlock.getRelative(dir);
                if ((double)i >= branch3StartOffset && Main.getRand().nextDouble() <= branch3StartDensity) {
                    branch3Starts.add(currentBlock.getLocation());
                }
                if (currentBlock.getType() == Material.AIR) {
                    SetBlock.setMaterial(currentBlock, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                }
                ++i;
            }
            branch2Ends.add(currentBlock.getLocation());
        }
        for (Location l : branch3Starts) {
            currentBlock = state.getCurrentWorld().getBlockAt(l);
            randNum = Main.getRand().nextDouble();
            dir = randNum <= 0.25 ? BlockFace.NORTH : (randNum <= 0.5 ? BlockFace.EAST : (randNum <= 0.75 ? BlockFace.SOUTH : BlockFace.WEST));
            i = 1;
            while ((double)i < branchSize3) {
                if (Main.getRand().nextDouble() <= 0.2) {
                    randNum = Main.getRand().nextDouble();
                    dir = randNum <= 0.1666 ? BlockFace.NORTH : (randNum <= 0.3333 ? BlockFace.EAST : (randNum <= 0.5 ? BlockFace.SOUTH : (randNum <= 0.6666 ? BlockFace.WEST : (randNum <= 0.8333 ? BlockFace.UP : BlockFace.DOWN))));
                }
                if ((currentBlock = currentBlock.getRelative(dir)).getType() == Material.AIR) {
                    SetBlock.setMaterial(currentBlock, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
                }
                ++i;
            }
            branch3Ends.add(currentBlock.getLocation());
        }
        for (Location startLoc : branch1Ends) {
            invLeafBallSize = 1.0 / leafSize1;
            int x = startLoc.getBlockX();
            y = startLoc.getBlockY();
            z = startLoc.getBlockZ();
            for (rx = -((int)leafSize1); rx <= (int)leafSize1; ++rx) {
                for (ry = -((int)leafSize1); ry <= (int)leafSize1; ++ry) {
                    for (rz = -((int)leafSize1); rz <= (int)leafSize1; ++rz) {
                        distFromCenter = Math.sqrt(rx * rx + ry * ry + rz * rz);
                        if (!(distFromCenter <= leafSize1) || 1.0 - distFromCenter * invLeafBallSize < Main.getRand().nextDouble() * 0.333 || (toSet = state.getCurrentWorld().getBlockAt(x + rx, y + ry, z + rz)).getType() != Material.AIR) continue;
                        SetBlock.setMaterial(toSet, this.leaves, state.getCurrentUndo(), state.getCurrentPlayer());
                    }
                }
            }
        }
        for (Location startLoc : branch2Ends) {
            invLeafBallSize = 1.0 / leafSize2;
            int x = startLoc.getBlockX();
            y = startLoc.getBlockY();
            z = startLoc.getBlockZ();
            for (rx = -((int)leafSize2); rx <= (int)leafSize2; ++rx) {
                for (ry = -((int)leafSize2); ry <= (int)leafSize2; ++ry) {
                    for (rz = -((int)leafSize2); rz <= (int)leafSize2; ++rz) {
                        distFromCenter = Math.sqrt(rx * rx + ry * ry + rz * rz);
                        if (!(distFromCenter <= leafSize2) || 1.0 - distFromCenter * invLeafBallSize < Main.getRand().nextDouble() * 0.333 || (toSet = state.getCurrentWorld().getBlockAt(x + rx, y + ry, z + rz)).getType() != Material.AIR) continue;
                        SetBlock.setMaterial(toSet, this.leaves, state.getCurrentUndo(), state.getCurrentPlayer());
                    }
                }
            }
        }
        for (Location startLoc : branch3Ends) {
            invLeafBallSize = 1.0 / leafSize3;
            int x = startLoc.getBlockX();
            y = startLoc.getBlockY();
            z = startLoc.getBlockZ();
            for (rx = -((int)leafSize3); rx <= (int)leafSize3; ++rx) {
                for (ry = -((int)leafSize3); ry <= (int)leafSize3; ++ry) {
                    for (rz = -((int)leafSize3); rz <= (int)leafSize3; ++rz) {
                        distFromCenter = Math.sqrt(rx * rx + ry * ry + rz * rz);
                        if (!(distFromCenter <= leafSize3) || 1.0 - distFromCenter * invLeafBallSize < Main.getRand().nextDouble() * 0.333 || (toSet = state.getCurrentWorld().getBlockAt(x + rx, y + ry, z + rz)).getType() != Material.AIR) continue;
                        SetBlock.setMaterial(toSet, this.leaves, state.getCurrentUndo(), state.getCurrentPlayer());
                    }
                }
            }
        }
    }

    private void oakTreeGenerator(OperatorState state) {
        double actVariance = (Main.getRand().nextDouble() * 2.0 - 1.0) * (double)this.variance;
        double treeHeight = (double)this.size + actVariance;
        double leafBallSize = treeHeight * 0.461235 + 1.35425;
        Block currentBlock = state.getCurrentWorld().getBlockAt(this.plantOn);
        int i = 0;
        while ((double)i < treeHeight) {
            if ((currentBlock = currentBlock.getRelative(BlockFace.UP)).getType() == Material.AIR) {
                SetBlock.setMaterial(currentBlock, this.trunk, state.getCurrentUndo(), state.getCurrentPlayer());
            }
            ++i;
        }
        Location topBlock = currentBlock.getLocation();
        double invLeafBallSize = 1.0 / leafBallSize;
        int x = topBlock.getBlockX();
        int y = topBlock.getBlockY();
        int z = topBlock.getBlockZ();
        for (int rx = -((int)leafBallSize); rx <= (int)leafBallSize; ++rx) {
            for (int ry = -((int)leafBallSize); ry <= (int)leafBallSize; ++ry) {
                for (int rz = -((int)leafBallSize); rz <= (int)leafBallSize; ++rz) {
                    Block toSet;
                    double distFromCenter = Math.sqrt(rx * rx + ry * ry + rz * rz);
                    if (!(distFromCenter <= leafBallSize) || 1.0 - distFromCenter * invLeafBallSize < Main.getRand().nextDouble() * 0.333 || (toSet = state.getCurrentWorld().getBlockAt(x + rx, y + ry, z + rz)).getType() != Material.AIR) continue;
                    SetBlock.setMaterial(toSet, this.leaves, state.getCurrentUndo(), state.getCurrentPlayer());
                }
            }
        }
    }
}

