/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.functions;

import com._14ercooper.worldeditor.async.AsyncManager;
import com._14ercooper.worldeditor.brush.BrushListener;
import com._14ercooper.worldeditor.functions.RegisterFunctions;
import com._14ercooper.worldeditor.functions.commands.InterpreterCommand;
import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.operations.OperatorState;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Function {
    public static long maxFunctionIters = 100000L;
    public static final Map<String, InterpreterCommand> commands = new HashMap<String, InterpreterCommand>();
    public static final List<Function> waitingFunctions = new LinkedList<Function>();
    public final List<Double> variables = new ArrayList<Double>();
    public static final List<Double> globalVariables = new ArrayList<Double>();
    public final List<Double> variableStack = new ArrayList<Double>();
    public final List<String> dataSegment = new LinkedList<String>();
    public final Map<String, Integer> labelsMap = new HashMap<String, Integer>();
    public final List<String> templateArgs = new LinkedList<String>();
    public final CommandSender player;
    public final Block target;
    public final boolean isOperator;
    public double ra;
    public double cmpres;
    public int waitDelay = 0;
    public boolean exit = false;
    public int currentLine = -1;
    public double exitVal = 1.0;
    long iters = 0L;
    public OperatorState operatorState;

    public Function(String filename, List<String> args2, CommandSender player, boolean isOperator, OperatorState opState) {
        int i;
        this.templateArgs.addAll(args2);
        this.player = player;
        this.isOperator = isOperator;
        this.operatorState = opState;
        this.target = player instanceof Player ? BrushListener.getTargetBlock((Player)player) : ((World)Bukkit.getServer().getWorlds().get(0)).getBlockAt(0, 0, 0);
        for (i = 0; i < 1000; ++i) {
            this.variables.add(0.0);
        }
        if (globalVariables.size() == 0) {
            for (i = 0; i < 100; ++i) {
                globalVariables.add(0.0);
            }
        }
        if (!Files.exists(Paths.get((String)(filename = "plugins/14erEdit/functions/" + (String)filename), new String[0]), new LinkOption[0])) {
            if (Files.exists(Paths.get((String)filename + ".fx", new String[0]), new LinkOption[0])) {
                filename = (String)filename + ".fx";
            } else if (Files.exists(Paths.get((String)filename + ".14fdl", new String[0]), new LinkOption[0])) {
                filename = (String)filename + ".14fdl";
            } else if (Files.exists(Paths.get((String)filename + ".txt", new String[0]), new LinkOption[0])) {
                filename = (String)filename + ".txt";
            } else if (Files.exists(Paths.get((String)filename + ".mcfunction", new String[0]), new LinkOption[0])) {
                filename = (String)filename + ".mcfunction";
            } else {
                Main.logError("Function file not found.", player, null);
                return;
            }
        }
        try {
            this.dataSegment.addAll(Files.readAllLines(Paths.get((String)filename, new String[0])));
        }
        catch (IOException e) {
            Main.logError("Could not open function file.", player, (Exception)e);
            return;
        }
        for (i = 0; i < this.dataSegment.size(); ++i) {
            String s = this.dataSegment.get(i).replaceAll("^\\s+", "");
            if (s.isBlank() || s.charAt(0) != ':') continue;
            this.labelsMap.put(s.substring(1), i);
        }
        Main.logDebug("Function loaded from " + (String)filename);
        Main.logDebug("Number of labels: " + this.labelsMap.size());
    }

    public static void SetupFunctions() {
        RegisterFunctions.RegisterAll();
        Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask(Main.getPlugin(), Function::CheckWaitingFunctions, 1L, 1L);
    }

    public static void CheckWaitingFunctions() {
        for (int i = 0; i < waitingFunctions.size(); ++i) {
            boolean didStart = waitingFunctions.get(i).checkCallback(i);
            if (!didStart) continue;
            Main.logDebug("Resuming paused function.");
            --i;
        }
    }

    public double run() {
        try {
            while (!this.exit && this.waitDelay == 0) {
                ++this.currentLine;
                ++this.iters;
                if (this.currentLine >= this.dataSegment.size()) {
                    Main.logDebug("Ran off end of function. Exiting.");
                    this.exit = true;
                    continue;
                }
                if (this.iters > maxFunctionIters) {
                    this.exit = true;
                    Main.logError("Function max iterations exceeded.", this.player, null);
                    continue;
                }
                String line = this.dataSegment.get(this.currentLine).replaceAll("^\\s+", "");
                for (int i = this.templateArgs.size(); i >= 1; --i) {
                    line = line.replaceAll("\\$" + i, this.templateArgs.get(i - 1));
                }
                ArrayList<String> lineContents = new ArrayList<String>(Arrays.asList(line.split("\\s")));
                if (((String)lineContents.get(0)).isEmpty()) {
                    Main.logDebug("Empty line processed.");
                    continue;
                }
                if (((String)lineContents.get(0)).charAt(0) == '#' || ((String)lineContents.get(0)).charAt(0) == ':') {
                    Main.logDebug("Comment or label processed.");
                    continue;
                }
                if (commands.containsKey(((String)lineContents.get(0)).replaceFirst("!", ""))) {
                    String functName = ((String)lineContents.get(0)).replaceFirst("!", "");
                    lineContents.remove(0);
                    Main.logDebug("Running interpreter command: " + functName);
                    commands.get(functName).run(lineContents, this);
                    continue;
                }
                Main.logDebug("Running as normal command.");
                boolean didRun = Bukkit.dispatchCommand((CommandSender)this.player, (String)line);
                if (didRun) continue;
                Main.logError("Invalid command detected. Line " + this.currentLine, this.player, null);
            }
        }
        catch (Exception e) {
            Main.logError("Error executing function. Error on line " + (this.currentLine + 1) + ".\nError: " + e.getMessage(), this.player, e);
            return 0.0;
        }
        if (this.waitDelay != 0 && !this.exit) {
            waitingFunctions.add(this);
        }
        return this.exitVal;
    }

    public double parseVariable(String var) {
        if (var.contains("$v")) {
            String s = var.substring(2);
            try {
                return this.variables.get(Integer.parseInt(s));
            }
            catch (Exception e) {
                Main.logError("Invalid variable: " + var, this.player, e);
                return 0.0;
            }
        }
        if (var.contains("$gv")) {
            String s = var.substring(2);
            try {
                return globalVariables.get(Integer.parseInt(s));
            }
            catch (Exception e) {
                Main.logError("Invalid variable: " + var, this.player, e);
                return 0.0;
            }
        }
        if (var.equalsIgnoreCase("$ra")) {
            return this.ra;
        }
        if (var.equalsIgnoreCase("$cmpres")) {
            return this.cmpres;
        }
        try {
            return Double.parseDouble(var);
        }
        catch (Exception e) {
            Main.logError("Invalid number: " + var, this.player, e);
            return 0.0;
        }
    }

    public void setVariable(String var, double num) {
        if (var.contains("$v")) {
            String s = var.substring(2);
            try {
                this.variables.set(Integer.parseInt(s), num);
            }
            catch (Exception e) {
                Main.logError("Invalid variable: " + var, this.player, e);
            }
            return;
        }
        if (var.contains("$gv")) {
            String s = var.substring(2);
            try {
                globalVariables.set(Integer.parseInt(s), num);
            }
            catch (Exception e) {
                Main.logError("Invalid variable: " + var, this.player, e);
            }
            return;
        }
        if (var.equalsIgnoreCase("$ra")) {
            this.ra = num;
            return;
        }
        if (var.equalsIgnoreCase("$cmpres")) {
            this.cmpres = num;
            return;
        }
        Main.logError("Unknown variable: " + var, this.player, null);
    }

    public boolean checkCallback(int waitPos) {
        if (this.waitDelay > 0) {
            --this.waitDelay;
        }
        if (this.waitDelay == 0) {
            waitingFunctions.remove(waitPos);
            this.run();
            return true;
        }
        if (this.waitDelay < 0 && AsyncManager.getRemainingBlocks() == 0L) {
            waitingFunctions.remove(waitPos);
            this.waitDelay = 0;
            this.run();
            return true;
        }
        return false;
    }
}

