/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.commands;

import com._14ercooper.worldeditor.main.Main;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class CommandTemplate
implements CommandExecutor {
    public boolean onCommand(CommandSender arg0, Command arg1, String arg2, String[] arg3) {
        String command2;
        String filename;
        if (arg0 instanceof Player && !arg0.isOp()) {
            arg0.sendMessage("You must be opped to use 14erEdit");
            return false;
        }
        try {
            filename = "plugins/14erEdit/templates/" + arg3[0];
        }
        catch (Exception e) {
            Main.logError("Template name required to use this command.", arg0, e);
            return false;
        }
        if (!Files.exists(Paths.get(filename, new String[0]), new LinkOption[0])) {
            if (Files.exists(Paths.get(filename + ".txt", new String[0]), new LinkOption[0])) {
                filename = filename + ".txt";
            } else if (Files.exists(Paths.get(filename + ".fx", new String[0]), new LinkOption[0])) {
                filename = filename + ".fx";
            } else {
                Main.logError("Template not found.", arg0, null);
                return false;
            }
        }
        try {
            command2 = CommandTemplate.readFile(filename);
        }
        catch (IOException e) {
            Main.logError("Error reading template file.", arg0, (Exception)e);
            return false;
        }
        command2 = command2.replaceAll("[\\n\\r\\t ]+", " ");
        for (int i = arg3.length - 1; i >= 1; --i) {
            command2 = command2.replaceAll("\\$" + i, arg3[i]);
        }
        Main.logDebug("Template command: " + command2);
        try {
            return Bukkit.dispatchCommand((CommandSender)arg0, (String)command2);
        }
        catch (Exception e) {
            Main.logError("Could not run command in template.", arg0, e);
            return false;
        }
    }

    static String readFile(String path) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, StandardCharsets.UTF_8);
    }

    public static List<String> getTemplateList() {
        try {
            Stream<Path> files = Files.list(Paths.get("plugins/14erEdit/templates", new String[0]));
            List<String> functions = files.map(path -> path.getFileName().toString()).collect(Collectors.toList());
            files.close();
            return functions;
        }
        catch (IOException e) {
            return new ArrayList<String>(Collections.singleton("<template_name>"));
        }
    }

    public static class TabComplete
    implements TabCompleter {
        public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args2) {
            ArrayList<String> tabArgs = new ArrayList<String>();
            if (args2.length == 1) {
                tabArgs.addAll(CommandTemplate.getTemplateList());
            }
            if (args2.length > 1) {
                tabArgs.add("[template_arg_" + (args2.length - 2) + "]");
            }
            return tabArgs;
        }
    }
}

