/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.commands;

import com._14ercooper.worldeditor.async.AsyncManager;
import com._14ercooper.worldeditor.brush.shapes.Voxel;
import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.operations.Operator;
import com._14ercooper.worldeditor.operations.OperatorLoader;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class CommandRunat
implements CommandExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command2, @NotNull String label, @NotNull String[] args2) {
        if (sender instanceof Player && !sender.isOp()) {
            sender.sendMessage("You must be opped to use 14erEdit");
            return false;
        }
        try {
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            if (args2[0].contains("~")) {
                if (sender instanceof BlockCommandSender) {
                    x = Double.parseDouble(args2[0].replaceAll("~", "")) + (double)((BlockCommandSender)sender).getBlock().getX();
                }
                if (sender instanceof Entity) {
                    x = Double.parseDouble(args2[0].replaceAll("~", "")) + ((Entity)sender).getLocation().getX();
                }
            } else {
                x = Double.parseDouble(args2[0]);
            }
            if (args2[1].contains("~")) {
                if (sender instanceof BlockCommandSender) {
                    y = Double.parseDouble(args2[1].replaceAll("~", "")) + (double)((BlockCommandSender)sender).getBlock().getY();
                }
                if (sender instanceof Entity) {
                    y = Double.parseDouble(args2[1].replaceAll("~", "")) + ((Entity)sender).getLocation().getY();
                }
            } else {
                y = Double.parseDouble(args2[1]);
            }
            if (args2[0].contains("~")) {
                if (sender instanceof BlockCommandSender) {
                    z = Double.parseDouble(args2[2].replaceAll("~", "")) + (double)((BlockCommandSender)sender).getBlock().getZ();
                }
                if (sender instanceof Entity) {
                    z = Double.parseDouble(args2[2].replaceAll("~", "")) + ((Entity)sender).getLocation().getZ();
                }
            } else {
                z = Double.parseDouble(args2[2]);
            }
            try {
                Voxel shape = new Voxel();
                StringBuilder opStr = new StringBuilder();
                for (int i = 3; i < args2.length; ++i) {
                    opStr.append(args2[i]).append(" ");
                }
                assert (sender instanceof Player);
                Operator op = new Operator(opStr.toString(), sender);
                AsyncManager.scheduleEdit(op, null, shape.GetBlocks(x, y, z, ((Player)sender).getWorld(), sender));
                return true;
            }
            catch (Exception e) {
                Main.logError("Error in runat. Please check your syntax.", sender, e);
                return false;
            }
        }
        catch (Exception e) {
            Main.logError("Could not parse runat command. Please check your syntax.", sender, e);
            return false;
        }
    }

    public static class TabComplete
    implements TabCompleter {
        public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String alias, String[] args2) {
            ArrayList<String> tabArgs = new ArrayList<String>();
            int initOffset = 4;
            if (args2.length < 2) {
                tabArgs.add("<x>");
            } else if (args2.length == 2) {
                tabArgs.add("<y>");
            } else if (args2.length == 3) {
                tabArgs.add("<z>");
            } else {
                String lastArg = args2[args2.length - initOffset];
                if (OperatorLoader.nextRange.contains(lastArg)) {
                    tabArgs.addAll(OperatorLoader.rangeNodeNames);
                } else if (OperatorLoader.nextBlock.contains(lastArg)) {
                    tabArgs.addAll(OperatorLoader.blockNodeNames);
                    tabArgs.addAll(Main.getBlockNames(args2[args2.length - 1]));
                } else {
                    tabArgs.addAll(OperatorLoader.nodeNames);
                    tabArgs.addAll(Main.getBlockNames(args2[args2.length - 1]));
                }
            }
            return tabArgs;
        }
    }
}

