/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.commands;

import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.player.PlayerManager;
import com._14ercooper.worldeditor.player.PlayerWrapper;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class CommandLimit
implements CommandExecutor {
    public boolean onCommand(CommandSender arg0, Command arg1, String arg2, String[] arg3) {
        long val;
        try {
            val = Long.parseLong(arg3[1]);
        }
        catch (NumberFormatException e) {
            if (arg3[1].equalsIgnoreCase("max")) {
                val = Long.MAX_VALUE;
            }
            if (arg3[1].equalsIgnoreCase("min")) {
                val = Long.MIN_VALUE;
            }
            Main.logError("Could not parse value for limiter, " + arg3[1] + "is not a number", arg0, null);
            return false;
        }
        PlayerWrapper playerWrapper = PlayerManager.getPlayerWrapper(arg0);
        if (arg3[0].equalsIgnoreCase("px")) {
            playerWrapper.setMaxEditX(val);
            arg0.sendMessage("\u00a7aPositive X edit box changed to " + val);
            return true;
        }
        if (arg3[0].equalsIgnoreCase("py")) {
            arg0.sendMessage("\u00a7aPositive Y edit box changed to " + val);
            playerWrapper.setMaxEditY(val);
            return true;
        }
        if (arg3[0].equalsIgnoreCase("pz")) {
            arg0.sendMessage("\u00a7aPositive Z edit box changed to " + val);
            playerWrapper.setMaxEditZ(val);
            return true;
        }
        if (arg3[0].equalsIgnoreCase("nx")) {
            arg0.sendMessage("\u00a7aPositive X edit box changed to " + val);
            playerWrapper.setMinEditX(val);
            return true;
        }
        if (arg3[0].equalsIgnoreCase("ny")) {
            arg0.sendMessage("\u00a7aNegative Y edit box changed to " + val);
            playerWrapper.setMinEditY(val);
            return true;
        }
        if (arg3[0].equalsIgnoreCase("nz")) {
            arg0.sendMessage("\u00a7aNegative Z edit box changed to " + val);
            playerWrapper.setMinEditZ(val);
            return true;
        }
        Main.logError("Invalid limiter provided: " + arg3[0], arg0, null);
        return false;
    }

    public static class TabComplete
    implements TabCompleter {
        public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args2) {
            ArrayList<String> tabArgs = new ArrayList<String>();
            if (args2.length == 1) {
                tabArgs.add("px");
                tabArgs.add("py");
                tabArgs.add("pz");
                tabArgs.add("nx");
                tabArgs.add("ny");
                tabArgs.add("nz");
            }
            if (args2.length == 2) {
                tabArgs.add("<value>");
            }
            return tabArgs;
        }
    }
}

