/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.commands;

import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.player.PlayerManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class CommandGmask
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command2, String lavel, String[] args2) {
        if (sender instanceof Player && !sender.isOp()) {
            sender.sendMessage("You must be opped to use 14erEdit");
            return false;
        }
        try {
            if (args2[0].equalsIgnoreCase("clear")) {
                PlayerManager.getPlayerWrapper(sender).resetGlobalMask();
                return true;
            }
            ArrayList<Material> materials = new ArrayList<Material>();
            for (int i = 0; i < args2.length; ++i) {
                String material = args2[i];
                try {
                    Material mat = Material.matchMaterial((String)material);
                    materials.add(mat);
                    continue;
                }
                catch (Exception e) {
                    Main.logError("Unknown material: " + i, sender, e);
                }
            }
            PlayerManager.getPlayerWrapper(sender).setGlobalMask(materials);
            sender.sendMessage("\u00a7dGlobal mask updated");
            return true;
        }
        catch (Exception e) {
            Main.logError("Could not update global mask", sender, e);
            return false;
        }
    }

    public static class TabComplete
    implements TabCompleter {
        public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args2) {
            ArrayList<String> tabArgs = new ArrayList<String>();
            if (args2.length == 1) {
                tabArgs.addAll(Main.getBlockNames(args2[args2.length - 1]));
                tabArgs.add("clear");
            } else if (args2.length > 1) {
                tabArgs.add("<block>");
            }
            return tabArgs;
        }
    }
}

