/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.commands;

import com._14ercooper.worldeditor.brush.Brush;
import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.operations.OperatorLoader;
import com._14ercooper.worldeditor.player.PlayerManager;
import com._14ercooper.worldeditor.selection.MultiselectCommandHandler;
import com._14ercooper.worldeditor.selection.SchematicHandler;
import com._14ercooper.worldeditor.selection.SelectionCommand;
import com._14ercooper.worldeditor.selection.SelectionManager;
import com._14ercooper.worldeditor.selection.SelectionWand;
import com._14ercooper.worldeditor.undo.UndoSystem;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class CommandFx
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command2, String label, String[] args2) {
        if (sender instanceof Player && !sender.isOp()) {
            sender.sendMessage("You must be opped to use 14erEdit");
            return false;
        }
        try {
            int argOffset = 0;
            if (args2.length < argOffset + 1) {
                Main.logError("fx requires at least one argument.", sender, null);
                return false;
            }
            if (sender instanceof Player) {
                if (args2[argOffset].equalsIgnoreCase("wand")) {
                    SelectionWand wand = SelectionWand.giveNewWand(((Player)sender).getPlayer());
                    return true;
                }
                if (args2[argOffset].equalsIgnoreCase("reset")) {
                    PlayerManager.deletePlayerWrapper(((Player)sender).getUniqueId().toString());
                    return true;
                }
                if (args2[argOffset].equalsIgnoreCase("multi")) {
                    SelectionManager manager = SelectionManager.getSelectionManager(((Player)sender).getUniqueId());
                    if (args2.length == argOffset + 1) {
                        manager.toggleMode(((Player)sender).getUniqueId().toString());
                        return true;
                    }
                    if (args2[argOffset + 1].equalsIgnoreCase("reset")) {
                        manager.resetMultiSelect(((Player)sender).getUniqueId().toString());
                        return true;
                    }
                    if (args2[argOffset + 1].equalsIgnoreCase("remove")) {
                        manager.removeAdditionalPoint(((Player)sender).getUniqueId().toString());
                        return true;
                    }
                    return MultiselectCommandHandler.handleCommand(manager, ((Player)sender).getUniqueId().toString(), args2);
                }
                if (args2[argOffset].equalsIgnoreCase("brush") || args2[argOffset].equalsIgnoreCase("br")) {
                    if (args2[argOffset + 1].equalsIgnoreCase("none")) {
                        sender.sendMessage("\u00a7dBrush removed.");
                        return Brush.removeBrush((Player)sender);
                    }
                    new Brush(args2, argOffset, (Player)sender);
                    return true;
                }
                if (args2[argOffset].equalsIgnoreCase("selection") || args2[argOffset].equalsIgnoreCase("sel")) {
                    return SelectionCommand.performCommand(args2, (Player)sender);
                }
                if (args2[argOffset].equalsIgnoreCase("undo")) {
                    return UndoSystem.findUserUndo(sender).undoChanges(Integer.parseInt(args2[argOffset + 1]));
                }
                if (args2[argOffset].equalsIgnoreCase("redo")) {
                    return UndoSystem.findUserUndo(sender).redoChanges(Integer.parseInt(args2[argOffset + 1]));
                }
                if (args2[argOffset].equalsIgnoreCase("schem")) {
                    if (args2[argOffset + 1].equalsIgnoreCase("save")) {
                        SchematicHandler.saveSchematic(args2[argOffset + 2], (Player)sender);
                        return true;
                    }
                    if (args2[argOffset + 1].equalsIgnoreCase("load")) {
                        SchematicHandler.loadSchematic(args2[argOffset + 2], (Player)sender, args2.length > argOffset + 3 ? args2[argOffset + 3] : "", args2.length > argOffset + 4 && Boolean.parseBoolean(args2[argOffset + 4]), args2.length > argOffset + 5 ? Integer.parseInt(args2[argOffset + 5]) : 0);
                        return true;
                    }
                    if (args2[argOffset + 1].equalsIgnoreCase("list")) {
                        Stream<Path> files = Files.list(Paths.get("plugins/14erEdit/schematics", new String[0]));
                        String regex = ".+";
                        if (args2.length > argOffset + 2) {
                            regex = args2[argOffset + 2];
                        }
                        String finalRegex = regex;
                        Set filePaths = files.filter(file -> !Files.isDirectory(file, new LinkOption[0])).map(Path::getFileName).map(Path::toString).filter(file -> file.matches(finalRegex)).collect(Collectors.toSet());
                        long schemNum = filePaths.size();
                        StringBuilder filesString = new StringBuilder();
                        for (String s : filePaths) {
                            filesString.append(" ").append(s);
                        }
                        sender.sendMessage("\u00a7aFound " + schemNum + " schematics:" + filesString);
                        files.close();
                        return true;
                    }
                    if (args2[argOffset + 1].equalsIgnoreCase("delete")) {
                        Main.logDebug("Deleting schematic " + args2[argOffset + 2]);
                        Files.deleteIfExists(Paths.get("plugins/14erEdit/schematics/" + args2[argOffset + 2], new String[0]));
                        sender.sendMessage("\u00a7aDeleted schematic " + args2[argOffset + 2]);
                        return true;
                    }
                }
                return false;
            }
            Main.logError("This command must be run as a player.", sender, null);
            return false;
        }
        catch (Exception e) {
            Main.logError("Error in fx command. Please check your syntax.", sender, e);
            e.printStackTrace();
            return false;
        }
    }

    public static List<String> getSchematicsList() {
        try {
            Stream<Path> files = Files.list(Paths.get("plugins/14erEdit/schematics", new String[0]));
            List<String> functions = files.map(path -> path.getFileName().toString()).collect(Collectors.toList());
            files.close();
            return functions;
        }
        catch (IOException e) {
            return new ArrayList<String>(Collections.singleton("<schematic_name>"));
        }
    }

    public static List<String> getTemplateList() {
        try {
            Stream<Path> files = Files.list(Paths.get("plugins/14erEdit/templates", new String[0]));
            List<String> functions = files.map(path -> path.getFileName().toString()).collect(Collectors.toList());
            files.close();
            return functions;
        }
        catch (IOException e) {
            return new ArrayList<String>(Collections.singleton("<template_name>"));
        }
    }

    public static List<String> getMultibrushList() {
        try {
            Stream<Path> files = Files.list(Paths.get("plugins/14erEdit/multibrushes", new String[0]));
            List<String> functions = files.map(path -> path.getFileName().toString()).collect(Collectors.toList());
            files.close();
            return functions;
        }
        catch (IOException e) {
            return new ArrayList<String>(Collections.singleton("<multibrush_name>"));
        }
    }

    public static class TabComplete
    implements TabCompleter {
        public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args2) {
            HashSet<Object> tabArgs = new HashSet<String>();
            int initOffset = 2;
            if (args2.length < 2) {
                tabArgs.add("brush");
                tabArgs.add("br");
                tabArgs.add("wand");
                tabArgs.add("selection");
                tabArgs.add("sel");
                tabArgs.add("schem");
                tabArgs.add("reset");
                tabArgs.add("multi");
            } else if (args2.length == 2) {
                if (args2[0].equalsIgnoreCase("brush") || args2[0].equalsIgnoreCase("br")) {
                    tabArgs.add("none");
                    tabArgs.addAll(Brush.brushShapes.keySet());
                }
                if (args2[0].equalsIgnoreCase("selection") || args2[0].equalsIgnoreCase("sel")) {
                    tabArgs.add("op");
                    tabArgs.add("expand");
                    tabArgs.add("reset");
                    tabArgs.add("copy");
                    tabArgs.add("paste");
                    tabArgs.add("origin");
                    tabArgs.add("pos1");
                    tabArgs.add("pos2");
                    tabArgs.add("mirror");
                    tabArgs.add("rotate");
                    tabArgs.add("clone");
                }
                if (args2[0].equalsIgnoreCase("schem")) {
                    tabArgs.add("save");
                    tabArgs.add("load");
                    tabArgs.add("list");
                }
            } else if (args2.length == 3 && args2[0].equalsIgnoreCase("schem")) {
                if (args2[1].equalsIgnoreCase("load")) {
                    tabArgs.addAll(CommandFx.getSchematicsList());
                }
                if (args2[1].equalsIgnoreCase("save")) {
                    tabArgs.add("<schematic_name>");
                }
                if (args2[1].equalsIgnoreCase("list")) {
                    tabArgs.add("[regex]");
                }
            } else if ((args2[0].equalsIgnoreCase("brush") || args2[0].equalsIgnoreCase("br")) && Brush.GetBrushShape(args2[1]) == null) {
                tabArgs.add("invalid_brush");
            } else if ((args2[0].equalsIgnoreCase("brush") || args2[0].equalsIgnoreCase("br")) && args2.length < 3 + Brush.GetBrushShape(args2[1]).minArgCount()) {
                tabArgs.add("<brush_arg>");
            } else if ((args2[0].equalsIgnoreCase("selection") || args2[0].equalsIgnoreCase("sel")) && !args2[1].equalsIgnoreCase("op")) {
                if (args2[1].equalsIgnoreCase("expand")) {
                    if (args2.length == 3) {
                        tabArgs.add("<amt>");
                    } else if (args2.length == 4) {
                        tabArgs.add("<direction>");
                    }
                } else if (args2[1].equalsIgnoreCase("paste")) {
                    tabArgs.add("true");
                    tabArgs.add("false");
                } else if (args2[1].equalsIgnoreCase("origin")) {
                    if (args2.length == 3) {
                        tabArgs.add("shift");
                        tabArgs.add("set");
                    } else if (args2.length == 4) {
                        tabArgs.add("<x>");
                    } else if (args2.length == 5) {
                        tabArgs.add("<y>");
                    } else if (args2.length == 6) {
                        tabArgs.add("<z>");
                    }
                } else if (args2[1].equalsIgnoreCase("pos1")) {
                    if (args2.length == 3) {
                        tabArgs.add("<x>");
                    } else if (args2.length == 4) {
                        tabArgs.add("<y>");
                    } else if (args2.length == 5) {
                        tabArgs.add("<z>");
                    }
                } else if (args2[1].equalsIgnoreCase("pos2")) {
                    if (args2.length == 3) {
                        tabArgs.add("<x>");
                    } else if (args2.length == 4) {
                        tabArgs.add("<y>");
                    } else if (args2.length == 5) {
                        tabArgs.add("<z>");
                    }
                } else if (args2[1].equalsIgnoreCase("mirror")) {
                    if (args2.length == 3) {
                        tabArgs.add("x");
                        tabArgs.add("y");
                        tabArgs.add("z");
                    }
                } else if (args2[1].equalsIgnoreCase("rotate")) {
                    if (args2.length == 3) {
                        tabArgs.add("0");
                        tabArgs.add("1");
                        tabArgs.add("2");
                        tabArgs.add("3");
                        tabArgs.add("4");
                        tabArgs.add("5");
                    }
                } else if (args2[1].equalsIgnoreCase("clone")) {
                    if (args2.length == 3) {
                        tabArgs.add("<xOffset>");
                    }
                    if (args2.length == 4) {
                        tabArgs.add("<yOffset>");
                    }
                    if (args2.length == 5) {
                        tabArgs.add("<zOffset>");
                    }
                    if (args2.length == 6) {
                        tabArgs.add("<times>");
                    }
                    if (args2.length == 7) {
                        tabArgs.add("false");
                        tabArgs.add("true");
                    }
                }
            } else {
                String lastArg;
                if (args2[1].equalsIgnoreCase("selection") || args2[1].equalsIgnoreCase("sel")) {
                    initOffset = 4;
                }
                if (args2[1].equalsIgnoreCase("brush") || args2[1].equalsIgnoreCase("br")) {
                    initOffset = 3 + Brush.GetBrushShape(args2[3]).minArgCount();
                }
                if (args2[1].equalsIgnoreCase("multi")) {
                    initOffset = 3;
                }
                if (OperatorLoader.nextRange.contains(lastArg = args2[args2.length - initOffset])) {
                    tabArgs.addAll(OperatorLoader.rangeNodeNames);
                } else if (OperatorLoader.nextBlock.contains(lastArg)) {
                    tabArgs.addAll(OperatorLoader.blockNodeNames);
                    tabArgs.addAll(Main.getBlockNames(args2[args2.length - 1]));
                } else {
                    tabArgs.addAll(OperatorLoader.nodeNames);
                    tabArgs.addAll(Main.getBlockNames(args2[args2.length - 1]));
                }
            }
            if (args2.length >= 2) {
                if (args2[args2.length - 2].equalsIgnoreCase("template") || args2[args2.length - 2].equalsIgnoreCase("tpl")) {
                    tabArgs = new HashSet<String>(CommandFx.getTemplateList());
                }
                if (args2[args2.length - 2].equalsIgnoreCase("multibrush") || args2[args2.length - 2].equalsIgnoreCase("multi")) {
                    tabArgs = new HashSet<String>(CommandFx.getMultibrushList());
                }
                if (args2[args2.length - 2].equalsIgnoreCase("brush") || args2[args2.length - 2].equalsIgnoreCase("br")) {
                    tabArgs = new HashSet();
                    if (args2.length == 2) {
                        tabArgs.add("none");
                    }
                    tabArgs.addAll(Brush.brushShapes.keySet());
                }
            }
            if (args2[0].equalsIgnoreCase("multi") && args2.length == 2) {
                tabArgs.add("reset");
                tabArgs.add("remove");
                tabArgs.add("spline");
                tabArgs.add("uniformspline");
                tabArgs.add("chordalspline");
            }
            return new ArrayList<String>(tabArgs);
        }
    }
}

