/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.brush.shapes;

import com._14ercooper.worldeditor.blockiterator.BlockIterator;
import com._14ercooper.worldeditor.blockiterator.IteratorManager;
import com._14ercooper.worldeditor.blockiterator.iterators.MultiIterator;
import com._14ercooper.worldeditor.brush.BrushShape;
import com._14ercooper.worldeditor.main.Main;
import java.util.ArrayList;
import java.util.HashSet;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class Splatter
extends BrushShape {
    int splatterRadius;
    int sphereCount;
    int sphereRadius;
    String correction = "0.5";
    int argsSeen = 0;

    @Override
    public BlockIterator GetBlocks_impl(double x, double y, double z, World world, CommandSender sender) {
        int spheresGenerated = 0;
        HashSet<BlockIterator> spheres = new HashSet<BlockIterator>();
        while (spheresGenerated < this.sphereCount) {
            double zOff;
            double yOff;
            double xOff = Main.getRand().nextInt(2 * this.splatterRadius + 1) - this.splatterRadius;
            if (!(xOff * xOff + (yOff = (double)(Main.getRand().nextInt(2 * this.splatterRadius + 1) - this.splatterRadius)) * yOff + (zOff = (double)(Main.getRand().nextInt(2 * this.splatterRadius + 1) - this.splatterRadius)) * zOff < (double)(this.splatterRadius * this.splatterRadius) + 0.5)) continue;
            ArrayList<String> argList = new ArrayList<String>();
            argList.add(Integer.toString((int)(x + xOff)));
            argList.add(Integer.toString((int)(y + yOff)));
            argList.add(Integer.toString((int)(z + zOff)));
            argList.add(Integer.toString(this.sphereRadius));
            argList.add(Integer.toString(0));
            argList.add(this.correction);
            spheres.add(IteratorManager.INSTANCE.getIterator("sphere").newIterator(argList, world, sender));
            ++spheresGenerated;
        }
        return ((MultiIterator)IteratorManager.INSTANCE.getIterator("multi")).newIterator(spheres);
    }

    @Override
    public void addNewArgument(String argument) {
        if (this.argsSeen == 0) {
            this.splatterRadius = Integer.parseInt(argument);
        }
        if (this.argsSeen == 1) {
            this.sphereCount = Integer.parseInt(argument);
        }
        if (this.argsSeen == 2) {
            this.sphereRadius = Integer.parseInt(argument);
        }
        if (this.argsSeen == 3) {
            try {
                Double.parseDouble(argument);
                this.correction = argument;
            }
            catch (NumberFormatException e) {
                ++this.argsSeen;
            }
        }
        ++this.argsSeen;
    }

    @Override
    public boolean lastInputProcessed() {
        return this.argsSeen < 5;
    }

    @Override
    public boolean gotEnoughArgs() {
        return this.argsSeen <= 2;
    }

    @Override
    public int minArgCount() {
        return 3;
    }
}

